/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.gui;

import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.items.ItemRollingStock;
import cam72cam.immersiverailroading.items.ItemRollingStockComponent;
import cam72cam.immersiverailroading.items.ItemTabs;
import cam72cam.immersiverailroading.library.CraftingType;
import cam72cam.immersiverailroading.library.ItemComponentType;
import cam72cam.immersiverailroading.util.IRFuzzy;
import cam72cam.mod.gui.helpers.ItemPickerGUI;
import cam72cam.mod.gui.screen.IScreenBuilder;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.item.ItemStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class CraftPicker {
    private ItemPickerGUI stockSelector;
    private ItemPickerGUI itemSelector;
    private List<ItemStack> items;
    private Consumer<ItemStack> onChoose = stack -> {
        screen.show();
        onChoose.accept((ItemStack)stack);
    };

    public static void showCraftPicker(IScreenBuilder screen, ItemStack current, CraftingType craftType, Consumer<ItemStack> onChoose) {
        new CraftPicker(screen, current, craftType, onChoose);
    }

    private CraftPicker(IScreenBuilder screen, ItemStack current, CraftingType craftType, Consumer<ItemStack> onChoose) {
        this.items = new ArrayList<ItemStack>(IRItems.ITEM_ROLLING_STOCK_COMPONENT.getItemVariants(ItemTabs.COMPONENT_TAB));
        ArrayList<ItemStack> stock = new ArrayList<ItemStack>();
        stock.addAll(IRItems.ITEM_ROLLING_STOCK.getItemVariants(ItemTabs.LOCOMOTIVE_TAB));
        stock.addAll(IRItems.ITEM_ROLLING_STOCK.getItemVariants(ItemTabs.PASSENGER_TAB));
        stock.addAll(IRItems.ITEM_ROLLING_STOCK.getItemVariants(ItemTabs.STOCK_TAB));
        ArrayList<ItemStack> toRemove = new ArrayList<ItemStack>();
        for (ItemStack item : this.items) {
            boolean isCastable;
            ItemRollingStockComponent.Data data = new ItemRollingStockComponent.Data(item);
            ItemComponentType comp = data.componentType;
            if (comp.isWooden(data.def)) {
                toRemove.add(item);
                continue;
            }
            boolean bl = isCastable = craftType == CraftingType.CASTING && comp.crafting == CraftingType.CASTING_HAMMER;
            if (comp.crafting == craftType || isCastable) continue;
            toRemove.add(item);
        }
        this.items.removeAll(toRemove);
        this.stockSelector = new ItemPickerGUI(stock, this::onStockExit);
        toRemove = new ArrayList();
        for (ItemStack itemStock : stock) {
            boolean hasComponent = false;
            for (ItemStack item : this.items) {
                if (!this.isPartOf(itemStock, item)) continue;
                hasComponent = true;
                break;
            }
            if (!hasComponent) {
                toRemove.add(itemStock);
                continue;
            }
            if (!this.isPartOf(itemStock, current)) continue;
            this.stockSelector.choosenItem = itemStock;
        }
        stock.removeAll(toRemove);
        if (craftType == CraftingType.CASTING) {
            stock.add(new ItemStack((CustomItem)IRItems.ITEM_CAST_RAIL, 1));
            stock.add(IRFuzzy.steelIngotOrFallback().example());
            stock.add(IRFuzzy.steelBlockOrFallback().example());
            stock.addAll(IRItems.ITEM_AUGMENT.getItemVariants(ItemTabs.MAIN_TAB));
        }
        this.stockSelector.setItems(stock);
        this.itemSelector = new ItemPickerGUI(new ArrayList(), this::onItemExit);
        if (current != null && current.is((CustomItem)IRItems.ITEM_ROLLING_STOCK_COMPONENT)) {
            this.itemSelector.choosenItem = current;
        }
        if (this.stockSelector.choosenItem != null) {
            this.setupItemSelector();
            if (this.itemSelector.hasOptions()) {
                this.itemSelector.show();
                return;
            }
        }
        this.stockSelector.show();
    }

    private boolean isPartOf(ItemStack stock, ItemStack item) {
        if (stock == null || item == null) {
            return false;
        }
        if (!stock.is((CustomItem)IRItems.ITEM_ROLLING_STOCK)) {
            return false;
        }
        if (!item.is((CustomItem)IRItems.ITEM_ROLLING_STOCK_COMPONENT)) {
            return false;
        }
        return new ItemRollingStockComponent.Data((ItemStack)item).def == new ItemRollingStock.Data((ItemStack)stock).def;
    }

    private void setupItemSelector() {
        ArrayList<ItemStack> filteredItems = new ArrayList<ItemStack>();
        for (ItemStack item : this.items) {
            if (!this.isPartOf(this.stockSelector.choosenItem, item)) continue;
            filteredItems.add(item);
        }
        this.itemSelector.setItems(filteredItems);
    }

    private void onStockExit(ItemStack stack) {
        if (stack == null) {
            this.onChoose.accept(null);
        } else {
            this.setupItemSelector();
            if (this.itemSelector.hasOptions()) {
                this.itemSelector.show();
            } else {
                this.itemSelector.choosenItem = null;
                this.onChoose.accept(stack);
            }
        }
    }

    private void onItemExit(ItemStack stack) {
        if (stack == null) {
            this.stockSelector.show();
        } else {
            this.onChoose.accept(stack);
        }
    }
}

