/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.gui;

import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.gui.ClickListHelper;
import cam72cam.immersiverailroading.gui.TrackGui;
import cam72cam.immersiverailroading.items.ItemTrackExchanger;
import cam72cam.immersiverailroading.items.nbt.RailSettings;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.GuiText;
import cam72cam.immersiverailroading.library.TrackDirection;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.library.TrackPositionType;
import cam72cam.immersiverailroading.library.TrackSmoothing;
import cam72cam.immersiverailroading.net.ItemTrackExchangerUpdatePacket;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.immersiverailroading.util.IRFuzzy;
import cam72cam.mod.MinecraftClient;
import cam72cam.mod.entity.Player;
import cam72cam.mod.gui.helpers.GUIHelpers;
import cam72cam.mod.gui.helpers.ItemPickerGUI;
import cam72cam.mod.gui.screen.Button;
import cam72cam.mod.gui.screen.IScreen;
import cam72cam.mod.gui.screen.IScreenBuilder;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.render.OpenGL;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class TrackExchangerGui
implements IScreen {
    private Button trackSelector;
    private Button bedTypeButton;
    private Button gaugeButton;
    private String track;
    private ItemStack railBed;
    private Gauge gauge;
    List<ItemStack> oreDict;

    public TrackExchangerGui() {
        Player player = MinecraftClient.getPlayer();
        ItemTrackExchanger.Data data = new ItemTrackExchanger.Data(player.getHeldItem(Player.Hand.PRIMARY));
        this.track = data.track;
        this.railBed = data.railBed;
        this.gauge = data.gauge;
        this.oreDict = new ArrayList<ItemStack>();
        this.oreDict.add(ItemStack.EMPTY);
        this.oreDict.addAll(IRFuzzy.IR_RAIL_BED.enumerate());
    }

    public void init(final IScreenBuilder screen) {
        this.trackSelector = new Button(screen, -100, 22, GuiText.SELECTOR_TRACK.toString(DefinitionManager.getTrack((String)this.track).name)){

            public void onClick(Player.Hand hand) {
                TrackExchangerGui.this.track = ClickListHelper.next(DefinitionManager.getTrackIDs(), TrackExchangerGui.this.track, hand);
                TrackExchangerGui.this.trackSelector.setText(GuiText.SELECTOR_TRACK.toString(DefinitionManager.getTrack((String)((TrackExchangerGui)TrackExchangerGui.this).track).name));
            }
        };
        this.bedTypeButton = new Button(screen, -100, 44, GuiText.SELECTOR_RAIL_BED.toString(TrackGui.getStackName(this.railBed))){

            public void onClick(Player.Hand hand) {
                ItemPickerGUI ip = new ItemPickerGUI(TrackExchangerGui.this.oreDict, bed -> {
                    if (bed != null) {
                        TrackExchangerGui.this.railBed = bed;
                        TrackExchangerGui.this.bedTypeButton.setText(GuiText.SELECTOR_RAIL_BED.toString(TrackGui.getStackName(bed)));
                    }
                    screen.show();
                });
                ip.choosenItem = TrackExchangerGui.this.railBed;
                ip.show();
            }
        };
        this.gaugeButton = new Button(screen, -100, 66, GuiText.SELECTOR_GAUGE.toString(this.gauge)){

            public void onClick(Player.Hand hand) {
                TrackExchangerGui.this.gauge = ClickListHelper.next(Gauge.values(), TrackExchangerGui.this.gauge, hand);
                TrackExchangerGui.this.gaugeButton.setText(GuiText.SELECTOR_GAUGE.toString(TrackExchangerGui.this.gauge));
            }
        };
    }

    public void onEnterKey(IScreenBuilder builder) {
        builder.close();
    }

    public void onClose() {
        new ItemTrackExchangerUpdatePacket(this.track, this.railBed, this.gauge).sendToServer();
    }

    public void draw(IScreenBuilder builder) {
        int scale = 8;
        RailSettings settings = new RailSettings(this.gauge, this.track, TrackItems.STRAIGHT, 10, 0.0f, TrackPositionType.FIXED, TrackSmoothing.BOTH, TrackDirection.NONE, this.railBed, ItemStack.EMPTY, false, false);
        ItemStack stack = new ItemStack((CustomItem)IRItems.ITEM_TRACK_BLUEPRINT, 1);
        settings.write(stack);
        try (OpenGL.With matrix = OpenGL.matrix();){
            GL11.glTranslated((double)(GUIHelpers.getScreenWidth() / 2 + builder.getWidth() / 4), (double)(builder.getHeight() / 4), (double)0.0);
            GL11.glScaled((double)scale, (double)scale, (double)1.0);
            GUIHelpers.drawItem((ItemStack)stack, (int)0, (int)0);
        }
        matrix = OpenGL.matrix();
        var6_6 = null;
        try {
            GL11.glTranslated((double)(GUIHelpers.getScreenWidth() / 2 - builder.getWidth() / 4), (double)(builder.getHeight() / 4), (double)0.0);
            GL11.glScaled((double)(-scale), (double)scale, (double)1.0);
            GUIHelpers.drawItem((ItemStack)stack, (int)0, (int)0);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (matrix != null) {
                if (var6_6 != null) {
                    try {
                        matrix.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    matrix.close();
                }
            }
        }
    }
}

