/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.gui.container;

import cam72cam.immersiverailroading.entity.LocomotiveSteam;
import cam72cam.mod.gui.container.IContainer;
import cam72cam.mod.gui.container.IContainerBuilder;
import cam72cam.mod.item.Fuzzy;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.item.ItemStackHandler;
import java.util.Map;

public class SteamLocomotiveContainer
implements IContainer {
    public final LocomotiveSteam stock;
    private final ItemStack template;

    public SteamLocomotiveContainer(LocomotiveSteam stock) {
        this.stock = stock;
        this.template = Fuzzy.BUCKET.example();
    }

    public void draw(IContainerBuilder container) {
        int currY = 0;
        int horizSlots = this.stock.getInventoryWidth();
        int inventoryRows = (int)Math.ceil(((double)this.stock.getInventorySize() - 2.0) / (double)horizSlots);
        int slotY = 0;
        int tankY = currY = container.drawTopBar(0, currY, horizSlots * 2);
        for (int i = 0; i < inventoryRows; ++i) {
            currY = container.drawSlotRow(null, 0, horizSlots * 2, 0, currY);
            if (i != 0) continue;
            slotY = currY;
        }
        container.drawTankBlock(0, tankY, horizSlots * 2, inventoryRows, this.stock.getLiquid(), (float)this.stock.getLiquidAmount() / (float)this.stock.getTankCapacity().MilliBuckets());
        int containerY = currY = container.drawBottomBar(0, currY, horizSlots * 2);
        currY = container.drawSlotBlock((ItemStackHandler)this.stock.cargoItems, 2, this.stock.getInventoryWidth(), 0, currY);
        Map<Integer, Integer> burnTime = this.stock.getBurnTime();
        Map<Integer, Integer> burnMax = this.stock.getBurnMax();
        for (int slot : burnTime.keySet()) {
            int time = this.stock.getBurnTime().get(slot);
            if (time == 0) continue;
            float perc = Math.min(1.0f, (float)time / (float)burnMax.get(slot).intValue());
            int xSlot = (slot - 2) % horizSlots;
            int ySlot = (slot - 2) / horizSlots;
            container.drawSlotOverlay("minecraft:blocks/fire_layer_1", xSlot * 18 + horizSlots * 9, containerY + ySlot * 18, (double)perc, 2009481990);
        }
        container.drawSlotOverlay(this.template, 1, slotY);
        container.drawSlot((ItemStackHandler)this.stock.cargoItems, 0, 1, slotY);
        container.drawSlot((ItemStackHandler)this.stock.cargoItems, 1, (horizSlots * 2 - 1) * 18 - 1, slotY);
        String quantityStr = String.format("%s/%s", this.stock.getLiquidAmount(), this.stock.getTankCapacity().MilliBuckets());
        container.drawCenteredString(quantityStr, 0, slotY);
        currY = container.drawPlayerInventoryConnector(0, currY, horizSlots);
        currY = container.drawPlayerInventory(currY, horizSlots * 2);
    }

    public int getSlotsX() {
        return this.stock.getInventoryWidth() * 2;
    }

    public int getSlotsY() {
        return this.stock.getInventorySize() / this.stock.getInventoryWidth();
    }
}

