/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.items;

import cam72cam.immersiverailroading.ConfigGraphics;
import cam72cam.immersiverailroading.items.BaseItemRollingStock;
import cam72cam.immersiverailroading.items.ItemTabs;
import cam72cam.immersiverailroading.library.ChatText;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.GuiText;
import cam72cam.immersiverailroading.registry.CarPassengerDefinition;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.registry.LocomotiveDefinition;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.util.BlockUtil;
import cam72cam.mod.entity.Entity;
import cam72cam.mod.entity.Player;
import cam72cam.mod.item.ArmorSlot;
import cam72cam.mod.item.ClickResult;
import cam72cam.mod.item.CreativeTab;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.util.Facing;
import cam72cam.mod.world.World;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ItemRollingStock
extends BaseItemRollingStock {
    public ItemRollingStock() {
        super("immersiverailroading", "item_rolling_stock");
    }

    public int getStackSize() {
        return 1;
    }

    public List<CreativeTab> getCreativeTabs() {
        return Arrays.asList(ItemTabs.STOCK_TAB, ItemTabs.LOCOMOTIVE_TAB, ItemTabs.PASSENGER_TAB);
    }

    public List<ItemStack> getItemVariants(CreativeTab tab) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (EntityRollingStockDefinition def : DefinitionManager.getDefinitions()) {
            if (tab != null && (def instanceof CarPassengerDefinition ? !tab.equals((Object)ItemTabs.PASSENGER_TAB) : (def instanceof LocomotiveDefinition ? !tab.equals((Object)ItemTabs.LOCOMOTIVE_TAB) : !tab.equals((Object)ItemTabs.STOCK_TAB)))) continue;
            ItemStack stack = new ItemStack((CustomItem)this, 1);
            Data data = new Data(stack);
            data.def = def;
            data.gauge = def.recommended_gauge;
            data.write();
            items.add(stack);
        }
        return items;
    }

    public List<String> getTooltip(ItemStack stack) {
        ArrayList<String> tooltip = new ArrayList<String>();
        Data data = new Data(stack);
        Gauge gauge = data.gauge;
        EntityRollingStockDefinition def = data.def;
        if (def != null) {
            tooltip.addAll(def.getTooltip(gauge));
        }
        tooltip.add(GuiText.GAUGE_TOOLTIP.toString(gauge));
        String texture = data.texture;
        if (texture != null && def != null && def.textureNames.get(texture) != null) {
            tooltip.add(GuiText.TEXTURE_TOOLTIP.toString(def.textureNames.get(texture)));
        }
        return tooltip;
    }

    public ClickResult onClickBlock(Player player, World world, Vec3i pos, Player.Hand hand, Facing facing, Vec3d hit) {
        TileRailBase te;
        if (BlockUtil.isIRRail(world, pos) && (te = (TileRailBase)world.getBlockEntity(pos, TileRailBase.class)).getAugment() != null) {
            switch (te.getAugment()) {
                case DETECTOR: 
                case LOCO_CONTROL: 
                case FLUID_LOADER: 
                case FLUID_UNLOADER: 
                case ITEM_LOADER: 
                case ITEM_UNLOADER: {
                    if (world.isServer) {
                        Data data = new Data(player.getHeldItem(hand));
                        boolean set = te.setAugmentFilter(data.def != null ? data.def.defID : null);
                        if (set) {
                            player.sendMessage(ChatText.SET_AUGMENT_FILTER.getMessage(data.def != null ? data.def.name() : "Unknown"));
                        } else {
                            player.sendMessage(ChatText.RESET_AUGMENT_FILTER.getMessage(new Object[0]));
                        }
                    }
                    return ClickResult.ACCEPTED;
                }
            }
        }
        return ItemRollingStock.tryPlaceStock(player, world, pos, hand, null);
    }

    public boolean isValidArmor(ItemStack stack, ArmorSlot armorType, Entity entity) {
        return armorType == ArmorSlot.HEAD && ConfigGraphics.trainsOnTheBrain;
    }

    public static class Data
    extends BaseItemRollingStock.Data {
        public Data(ItemStack stack) {
            super(stack);
        }
    }
}

