/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model;

import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.model.ComponentRenderer;
import cam72cam.immersiverailroading.model.FreightModel;
import cam72cam.immersiverailroading.model.components.ComponentProvider;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.immersiverailroading.model.part.Bell;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.registry.LocomotiveDefinition;
import java.util.List;

public class LocomotiveModel<T extends Locomotive>
extends FreightModel<T> {
    private List<ModelComponent> components;
    private Bell bell;

    public LocomotiveModel(LocomotiveDefinition def) throws Exception {
        super(def);
    }

    @Override
    protected void parseComponents(ComponentProvider provider, EntityRollingStockDefinition def) {
        super.parseComponents(provider, def);
        this.components = provider.parse(new ModelComponentType[]{ModelComponentType.CAB});
        this.bell = Bell.get(provider, ((LocomotiveDefinition)def).bell);
    }

    @Override
    protected void effects(T stock) {
        super.effects(stock);
        this.bell.effects((EntityMoveableRollingStock)((Object)stock), ((Locomotive)((Object)stock)).getBell() > 0 ? 0.8f : 0.0f);
    }

    @Override
    protected void removed(T stock) {
        super.removed(stock);
        this.bell.removed((EntityMoveableRollingStock)((Object)stock));
    }

    @Override
    protected void render(T stock, ComponentRenderer draw, double distanceTraveled) {
        super.render(stock, draw, distanceTraveled);
        draw.render(this.components);
        this.bell.render(draw);
    }
}

