/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.multiblock;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.items.ItemCastRail;
import cam72cam.immersiverailroading.items.ItemRail;
import cam72cam.immersiverailroading.multiblock.Multiblock;
import cam72cam.immersiverailroading.tile.TileMultiblock;
import cam72cam.mod.energy.IEnergy;
import cam72cam.mod.entity.Player;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.math.Rotation;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.sound.Audio;
import cam72cam.mod.sound.SoundCategory;
import cam72cam.mod.sound.StandardSound;
import cam72cam.mod.world.World;

public class RailRollerMultiblock
extends Multiblock {
    public static final String NAME = "RAIL_MACHINE";
    private static final Vec3i render = new Vec3i(0, 0, 0);
    private static final Vec3i crafter = new Vec3i(1, 1, 15);
    private static final Vec3i input = new Vec3i(1, 0, 0);
    private static final Vec3i output = new Vec3i(1, 0, 29);
    private static final Vec3i power = new Vec3i(1, 2, 15);

    private static Multiblock.FuzzyProvider[][][] componentGenerator() {
        Multiblock.FuzzyProvider[][][] result = new Multiblock.FuzzyProvider[30][][];
        Multiblock.FuzzyProvider[] bed = new Multiblock.FuzzyProvider[]{RailRollerMultiblock.S_SCAF(), RailRollerMultiblock.S_SCAF()};
        for (int i = 0; i < 30; ++i) {
            result[i] = i >= 11 && i <= 18 ? new Multiblock.FuzzyProvider[][]{{RailRollerMultiblock.L_ENG(), RailRollerMultiblock.L_ENG()}, {RailRollerMultiblock.H_ENG(), RailRollerMultiblock.H_ENG()}, {RailRollerMultiblock.L_ENG(), RailRollerMultiblock.L_ENG()}} : new Multiblock.FuzzyProvider[][]{bed};
        }
        return result;
    }

    public RailRollerMultiblock() {
        super(NAME, RailRollerMultiblock.componentGenerator());
    }

    @Override
    public Vec3i placementPos() {
        return input;
    }

    @Override
    protected Multiblock.MultiblockInstance newInstance(World world, Vec3i origin, Rotation rot) {
        return new RailRollerInstance(world, origin, rot);
    }

    public class RailRollerInstance
    extends Multiblock.MultiblockInstance {
        public RailRollerInstance(World world, Vec3i origin, Rotation rot) {
            super(world, origin, rot);
        }

        @Override
        public boolean onBlockActivated(Player player, Player.Hand hand, Vec3i offset) {
            if (this.world.isClient) {
                return false;
            }
            if (!player.isCrouching()) {
                ItemStack held = player.getHeldItem(hand);
                if (held.isEmpty() && this.outputFull()) {
                    TileMultiblock outputTe = this.getTile(output);
                    if (outputTe == null) {
                        return false;
                    }
                    ItemStack outstack = outputTe.getContainer().get(0);
                    this.world.dropItem(outstack, player.getPosition());
                    outputTe.getContainer().set(0, ItemStack.EMPTY);
                } else if (held.is((CustomItem)IRItems.ITEM_CAST_RAIL)) {
                    TileMultiblock inputTe = this.getTile(input);
                    if (inputTe == null) {
                        return false;
                    }
                    if (inputTe.getContainer().get(0).isEmpty()) {
                        ItemStack inputStack = held.copy();
                        inputStack.setCount(1);
                        inputTe.getContainer().set(0, inputStack);
                        held.shrink(1);
                        player.setHeldItem(hand, held);
                    }
                }
            }
            return false;
        }

        @Override
        public boolean isRender(Vec3i offset) {
            return render.equals((Object)offset);
        }

        @Override
        public int getInvSize(Vec3i offset) {
            return offset.equals((Object)input) || offset.equals((Object)output) ? 1 : 0;
        }

        @Override
        public void tick(Vec3i offset) {
            if (!offset.equals((Object)crafter)) {
                return;
            }
            TileMultiblock craftingTe = this.getTile(crafter);
            if (craftingTe == null) {
                return;
            }
            TileMultiblock powerTe = this.getTile(power);
            if (powerTe == null) {
                return;
            }
            TileMultiblock inputTe = this.getTile(input);
            if (inputTe == null) {
                return;
            }
            TileMultiblock outputTe = this.getTile(output);
            if (outputTe == null) {
                return;
            }
            if (!this.hasPower()) {
                return;
            }
            if (this.world.isClient) {
                if (craftingTe.getRenderTicks() % 10L == 0L && craftingTe.getCraftProgress() != 0) {
                    Audio.playSound((World)this.world, (Vec3i)craftingTe.getPos(), (StandardSound)StandardSound.BLOCK_ANVIL_PLACE, (SoundCategory)SoundCategory.BLOCKS, (float)1.0f, (float)0.2f);
                }
                return;
            }
            if (craftingTe.getCraftProgress() != 0) {
                IEnergy energy = powerTe.getEnergy(null);
                energy.extract(this.powerRequired(), false);
                craftingTe.setCraftProgress(Math.max(0, craftingTe.getCraftProgress() - 1));
            }
            float progress = craftingTe.getCraftProgress();
            ItemStack input = inputTe.getContainer().get(0);
            ItemStack output = outputTe.getContainer().get(0);
            if (progress == 0.0f && input.is((CustomItem)IRItems.ITEM_CAST_RAIL) && output.isEmpty()) {
                progress = 100.0f;
                craftingTe.setCraftProgress(100);
            }
            if (progress == 1.0f) {
                ItemStack out = new ItemStack((CustomItem)IRItems.ITEM_RAIL, 12);
                ItemRail.Data data = new ItemRail.Data(out);
                data.gauge = new ItemCastRail.Data((ItemStack)input).gauge;
                data.write();
                outputTe.getContainer().set(0, out);
                input.shrink(1);
                inputTe.getContainer().set(0, input);
            }
        }

        @Override
        public boolean canInsertItem(Vec3i offset, int slot, ItemStack stack) {
            return offset.equals((Object)input) && stack.is((CustomItem)IRItems.ITEM_CAST_RAIL);
        }

        @Override
        public boolean isOutputSlot(Vec3i offset, int slot) {
            return offset.equals((Object)output);
        }

        @Override
        public int getSlotLimit(Vec3i offset, int slot) {
            return offset.equals((Object)input) || offset.equals((Object)output) ? 1 : 0;
        }

        @Override
        public boolean canRecievePower(Vec3i offset) {
            return offset.equals((Object)power);
        }

        public boolean hasPower() {
            TileMultiblock powerTe = this.getTile(power);
            if (powerTe == null) {
                return false;
            }
            return powerTe.getEnergy(null).getCurrent() >= this.powerRequired();
        }

        private int powerRequired() {
            return (int)Math.ceil(32.0f * Config.ConfigBalance.machinePowerFactor);
        }

        public int getCraftProgress() {
            TileMultiblock craftingTe = this.getTile(crafter);
            if (craftingTe == null) {
                return 0;
            }
            return craftingTe.getCraftProgress();
        }

        public boolean outputFull() {
            TileMultiblock outputTe = this.getTile(output);
            if (outputTe == null) {
                return false;
            }
            return !outputTe.getContainer().get(0).isEmpty();
        }
    }
}

