/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.registry;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityBuildableRollingStock;
import cam72cam.immersiverailroading.entity.EntityCoupleableRollingStock;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.GuiText;
import cam72cam.immersiverailroading.library.ItemComponentType;
import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.library.ValveGearType;
import cam72cam.immersiverailroading.model.StockModel;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.immersiverailroading.util.RealBB;
import cam72cam.mod.entity.EntityRegistry;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.model.obj.OBJGroup;
import cam72cam.mod.model.obj.VertexBuffer;
import cam72cam.mod.resource.Identifier;
import cam72cam.mod.serialization.ResourceCache;
import cam72cam.mod.serialization.TagCompound;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.serialization.TagMapped;
import cam72cam.mod.serialization.TagMapper;
import cam72cam.mod.text.TextUtil;
import cam72cam.mod.world.World;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@TagMapped(value=TagMapper.class)
public abstract class EntityRollingStockDefinition {
    private static Identifier default_wheel_sound = new Identifier("immersiverailroading", "sounds/default/track_wheels.ogg");
    private static Identifier default_clackFront = new Identifier("immersiverailroading", "sounds/default/clack.ogg");
    private static Identifier default_clackRear = new Identifier("immersiverailroading", "sounds/default/clack.ogg");
    public final String defID;
    private final Class<? extends EntityRollingStock> type;
    public Map<String, String> textureNames = null;
    public float dampeningAmount;
    public Gauge recommended_gauge;
    public Boolean shouldSit;
    public Identifier wheel_sound;
    public Identifier clackFront;
    public Identifier clackRear;
    public double internal_model_scale;
    double internal_inv_scale;
    private String name = "Unknown";
    private String modelerName = "N/A";
    private String packName = "N/A";
    private ValveGearType valveGear;
    public float darken;
    public Identifier modelLoc;
    private StockModel<?> model;
    private Vec3d passengerCenter = new Vec3d(0.0, 0.0, 0.0);
    private float bogeyFront;
    private float bogeyRear;
    private float couplerOffsetFront;
    private float couplerOffsetRear;
    private boolean scalePitch;
    private double frontBounds;
    private double rearBounds;
    private double heightBounds;
    private double widthBounds;
    private double passengerCompartmentLength;
    private double passengerCompartmentWidth;
    private int weight;
    private int maxPassengers;
    private final Map<ModelComponentType, List<ModelComponent>> renderComponents;
    private final List<ItemComponentType> itemComponents;
    private final Function<EntityBuildableRollingStock, float[][]> heightmap;

    public EntityRollingStockDefinition(Class<? extends EntityRollingStock> type, String defID, JsonObject data) throws Exception {
        this.type = type;
        this.defID = defID;
        this.parseJson(data);
        this.model = this.createModel();
        this.renderComponents = new HashMap<ModelComponentType, List<ModelComponent>>();
        for (ModelComponent component2 : this.model.allComponents) {
            this.renderComponents.computeIfAbsent(component2.type, v -> new ArrayList()).add(0, component2);
        }
        this.itemComponents = this.model.allComponents.stream().map(component -> component.type).map(ItemComponentType::from).filter(Objects::nonNull).collect(Collectors.toList());
        this.frontBounds = -this.model.minOfGroup((Iterable)this.model.groups()).x + (double)this.couplerOffsetFront;
        this.rearBounds = this.model.maxOfGroup((Iterable)this.model.groups()).x + (double)this.couplerOffsetRear;
        this.widthBounds = this.model.widthOfGroups(this.model.groups());
        ArrayList<String> heightGroups = new ArrayList<String>();
        for (String group : this.model.groups()) {
            boolean ignore = false;
            for (ModelComponentType rct : ModelComponentType.values()) {
                if (rct.collisionsEnabled) continue;
                for (int i = 0; i < 10; ++i) {
                    if (!Pattern.matches(rct.regex.replace("#ID#", "" + i), group)) continue;
                    ignore = true;
                    break;
                }
                if (ignore) break;
            }
            if (ignore) continue;
            heightGroups.add(group);
        }
        this.heightBounds = this.model.heightOfGroups(heightGroups);
        this.heightmap = this.initHeightmap();
    }

    public final EntityRollingStock spawn(World world, Vec3d pos, float yaw, Gauge gauge, String texture) {
        EntityRollingStock stock = (EntityRollingStock)EntityRegistry.create((World)world, this.type);
        stock.setPosition(pos);
        stock.setRotationYaw(yaw);
        stock.setRotationYaw(yaw);
        stock.setup(this.defID, gauge, texture);
        return stock;
    }

    public boolean shouldScalePitch() {
        return this.scalePitch;
    }

    public void parseJson(JsonObject data) throws Exception {
        JsonObject sounds;
        this.name = data.get("name").getAsString();
        if (data.has("modeler")) {
            this.modelerName = data.get("modeler").getAsString();
        }
        if (data.has("pack")) {
            this.packName = data.get("pack").getAsString();
        }
        this.darken = 0.0f;
        if (data.has("darken_model")) {
            this.darken = data.get("darken_model").getAsFloat();
        }
        this.internal_model_scale = 1.0;
        this.internal_inv_scale = 1.0;
        this.recommended_gauge = Gauge.from(1.435);
        if (data.has("model_gauge_m")) {
            this.recommended_gauge = Gauge.from(data.get("model_gauge_m").getAsDouble());
            this.internal_model_scale = 1.435 / data.get("model_gauge_m").getAsDouble();
        }
        if (data.has("recommended_gauge_m")) {
            this.recommended_gauge = Gauge.from(data.get("recommended_gauge_m").getAsDouble());
        }
        if (this.recommended_gauge != Gauge.from(1.435)) {
            this.internal_inv_scale = 1.435 / this.recommended_gauge.value();
        }
        this.textureNames = new LinkedHashMap<String, String>();
        this.textureNames.put("", "Default");
        if (data.has("tex_variants")) {
            JsonElement variants = data.get("tex_variants");
            for (Object variant : variants.getAsJsonObject().entrySet()) {
                this.textureNames.put(((JsonElement)variant.getValue()).getAsString(), (String)variant.getKey());
            }
        }
        Identifier alt_textures = new Identifier("immersiverailroading", this.defID.replace(".json", "_variants.json"));
        try {
            List alts = alt_textures.getResourceStreamAll();
            for (InputStream input : alts) {
                JsonParser parser = new JsonParser();
                JsonElement variants = parser.parse((Reader)new InputStreamReader(input));
                for (Map.Entry variant : variants.getAsJsonObject().entrySet()) {
                    this.textureNames.put(((JsonElement)variant.getValue()).getAsString(), (String)variant.getKey());
                }
            }
        }
        catch (FileNotFoundException alts) {
            // empty catch block
        }
        this.modelLoc = new Identifier(data.get("model").getAsString());
        JsonObject passenger = data.get("passenger").getAsJsonObject();
        this.passengerCenter = new Vec3d(0.0, passenger.get("center_y").getAsDouble() - 0.35, passenger.get("center_x").getAsDouble()).scale(this.internal_model_scale);
        this.passengerCompartmentLength = passenger.get("length").getAsDouble() * this.internal_model_scale;
        this.passengerCompartmentWidth = passenger.get("width").getAsDouble() * this.internal_model_scale;
        this.maxPassengers = passenger.get("slots").getAsInt();
        if (passenger.has("should_sit")) {
            this.shouldSit = passenger.get("should_sit").getAsBoolean();
        }
        this.bogeyFront = (float)((double)data.get("trucks").getAsJsonObject().get("front").getAsFloat() * this.internal_model_scale);
        this.bogeyRear = (float)((double)data.get("trucks").getAsJsonObject().get("rear").getAsFloat() * this.internal_model_scale);
        this.dampeningAmount = 0.75f;
        if (data.has("sound_dampening_percentage") && data.get("sound_dampening_percentage").getAsFloat() >= 0.0f && data.get("sound_dampening_percentage").getAsFloat() <= 1.0f) {
            this.dampeningAmount = data.get("sound_dampening_percentage").getAsFloat();
        }
        this.scalePitch = true;
        if (data.has("scale_pitch")) {
            this.scalePitch = data.get("scale_pitch").getAsBoolean();
        }
        if (data.has("couplers")) {
            this.couplerOffsetFront = (float)((double)data.get("couplers").getAsJsonObject().get("front_offset").getAsFloat() * this.internal_model_scale);
            this.couplerOffsetRear = (float)((double)data.get("couplers").getAsJsonObject().get("rear_offset").getAsFloat() * this.internal_model_scale);
        }
        JsonObject properties = data.get("properties").getAsJsonObject();
        this.weight = (int)Math.ceil((double)properties.get("weight_kg").getAsInt() * this.internal_inv_scale);
        this.valveGear = properties.has("valve_gear") ? ValveGearType.from(properties.get("valve_gear").getAsString().toUpperCase(Locale.ROOT)) : null;
        this.wheel_sound = default_wheel_sound;
        this.clackFront = default_clackFront;
        this.clackRear = default_clackRear;
        JsonObject jsonObject = sounds = data.has("sounds") ? data.get("sounds").getAsJsonObject() : null;
        if (sounds != null) {
            if (sounds.has("wheels")) {
                this.wheel_sound = new Identifier("immersiverailroading", sounds.get("wheels").getAsString()).getOrDefault(default_wheel_sound);
            }
            if (sounds.has("clack")) {
                this.clackFront = new Identifier("immersiverailroading", sounds.get("clack").getAsString()).getOrDefault(default_clackFront);
                this.clackRear = new Identifier("immersiverailroading", sounds.get("clack").getAsString()).getOrDefault(default_clackRear);
            }
            if (sounds.has("clack_front")) {
                this.clackFront = new Identifier("immersiverailroading", sounds.get("clack_front").getAsString()).getOrDefault(default_clackFront);
            }
            if (sounds.has("clack_rear")) {
                this.clackRear = new Identifier("immersiverailroading", sounds.get("clack_rear").getAsString()).getOrDefault(default_clackRear);
            }
        }
    }

    public List<ModelComponent> getComponents(ModelComponentType name) {
        if (!this.renderComponents.containsKey((Object)name)) {
            return null;
        }
        return this.renderComponents.get((Object)name);
    }

    public Vec3d correctPassengerBounds(Gauge gauge, Vec3d pos, boolean shouldSit) {
        double gs = gauge.scale();
        Vec3d passengerCenter = this.passengerCenter.scale(gs);
        pos = pos.subtract(passengerCenter);
        if (pos.z > this.passengerCompartmentLength * gs) {
            pos = new Vec3d(pos.x, pos.y, this.passengerCompartmentLength * gs);
        }
        if (pos.z < -this.passengerCompartmentLength * gs) {
            pos = new Vec3d(pos.x, pos.y, -this.passengerCompartmentLength * gs);
        }
        if (Math.abs(pos.x) > this.passengerCompartmentWidth / 2.0 * gs) {
            pos = new Vec3d(Math.copySign(this.passengerCompartmentWidth / 2.0 * gs, pos.x), pos.y, pos.z);
        }
        pos = new Vec3d(pos.x, passengerCenter.y - (shouldSit ? 0.75 : 0.0), pos.z + passengerCenter.z);
        return pos;
    }

    public boolean isAtFront(Gauge gauge, Vec3d pos) {
        pos = pos.subtract(this.passengerCenter.scale(gauge.scale()));
        return pos.z >= this.passengerCompartmentLength * gauge.scale();
    }

    public boolean isAtRear(Gauge gauge, Vec3d pos) {
        pos = pos.subtract(this.passengerCenter.scale(gauge.scale()));
        return pos.z <= -this.passengerCompartmentLength * gauge.scale();
    }

    public List<ItemComponentType> getItemComponents() {
        return this.itemComponents;
    }

    public float getBogeyFront(Gauge gauge) {
        return (float)gauge.scale() * this.bogeyFront;
    }

    public float getBogeyRear(Gauge gauge) {
        return (float)gauge.scale() * this.bogeyRear;
    }

    public double getCouplerPosition(EntityCoupleableRollingStock.CouplerType coupler, Gauge gauge) {
        switch (coupler) {
            case FRONT: {
                return gauge.scale() * this.frontBounds;
            }
            case BACK: {
                return gauge.scale() * this.rearBounds;
            }
        }
        return 0.0;
    }

    private Function<EntityBuildableRollingStock, float[][]> initHeightmap() {
        String key = String.format("heightmap-%s-%s-%s-%s-%s-%s", this.model.hash, this.frontBounds, this.rearBounds, this.widthBounds, this.heightBounds, this.renderComponents.size());
        try {
            ResourceCache cache = new ResourceCache(this.modelLoc, key, provider -> new HeightMapData(this));
            Supplier data = cache.getResource("data.bin", builder -> new ResourceCache.GenericByteBuffer(builder.data));
            Supplier meta = cache.getResource("meta.nbt", builder -> {
                try {
                    return new ResourceCache.GenericByteBuffer(new TagCompound().setInteger("xRes", Integer.valueOf(builder.xRes)).setInteger("zRes", Integer.valueOf(builder.zRes)).setList("components", builder.components, v -> new TagCompound().setString("key", v.key)).toBytes());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            cache.close();
            return arg_0 -> this.lambda$initHeightmap$7((Supplier)data, (Supplier)meta, arg_0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public float[][] createHeightMap(EntityBuildableRollingStock stock) {
        return this.heightmap.apply(stock);
    }

    public RealBB getBounds(EntityMoveableRollingStock stock, Gauge gauge) {
        return new RealBB(gauge.scale() * this.frontBounds, gauge.scale() * -this.rearBounds, gauge.scale() * this.widthBounds, gauge.scale() * this.heightBounds, stock.getRotationYaw()).offset(stock.getPosition());
    }

    public String name() {
        String transStr;
        String[] sp = this.defID.replaceAll(".json", "").split("/");
        String localStr = String.format("%s:entity.%s.%s", "immersiverailroading", sp[sp.length - 2], sp[sp.length - 1]);
        return !localStr.equals(transStr = TextUtil.translate((String)localStr)) ? transStr : this.name;
    }

    public List<String> getTooltip(Gauge gauge) {
        ArrayList<String> tips = new ArrayList<String>();
        tips.add(GuiText.WEIGHT_TOOLTIP.toString(this.getWeight(gauge)));
        tips.add(GuiText.MODELER_TOOLTIP.toString(this.modelerName));
        tips.add(GuiText.PACK_TOOLTIP.toString(this.packName));
        return tips;
    }

    protected StockModel<?> createModel() throws Exception {
        return new StockModel(this);
    }

    public StockModel<?> getModel() {
        return this.model;
    }

    public int getWeight(Gauge gauge) {
        return (int)Math.ceil(gauge.scale() * (double)this.weight);
    }

    public double getHeight(Gauge gauge) {
        return gauge.scale() * this.heightBounds;
    }

    public double getWidth(Gauge gauge) {
        return gauge.scale() * this.widthBounds;
    }

    public double getLength(Gauge gauge) {
        return gauge.scale() * this.frontBounds + this.rearBounds;
    }

    public int getMaxPassengers() {
        return this.maxPassengers;
    }

    public boolean acceptsPassengers() {
        return false;
    }

    public boolean acceptsLivestock() {
        return false;
    }

    public ValveGearType getValveGear() {
        return this.valveGear;
    }

    private /* synthetic */ float[][] lambda$initHeightmap$7(Supplier data, Supplier meta, EntityBuildableRollingStock stock) {
        try {
            float[] raw = ((ResourceCache.GenericByteBuffer)data.get()).floats();
            TagCompound tc = new TagCompound(((ResourceCache.GenericByteBuffer)meta.get()).bytes());
            int xRes = tc.getInteger("xRes");
            int zRes = tc.getInteger("zRes");
            List componentKeys = tc.getList("components", v -> v.getString("key"));
            float[][] heightMap = new float[xRes][zRes];
            ArrayList<ModelComponentType> availComponents = new ArrayList<ModelComponentType>();
            for (ItemComponentType itemComponentType : stock.getItemComponents()) {
                availComponents.addAll(itemComponentType.render);
            }
            for (List list : this.renderComponents.values()) {
                for (ModelComponent rc : list) {
                    if (!rc.type.collisionsEnabled) continue;
                    if (availComponents.contains((Object)rc.type)) {
                        availComponents.remove((Object)rc.type);
                    } else if (rc.type != ModelComponentType.REMAINING || !stock.isBuilt()) continue;
                    int idx = componentKeys.indexOf(rc.key) * xRes * zRes;
                    if (idx < 0) continue;
                    for (int x = 0; x < xRes; ++x) {
                        for (int z = 0; z < zRes; ++z) {
                            heightMap[x][z] = Math.max(heightMap[x][z], raw[idx + x * zRes + z]);
                        }
                    }
                }
            }
            return heightMap;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static class TagMapper
    implements cam72cam.mod.serialization.TagMapper<EntityRollingStockDefinition> {
        TagMapper() {
        }

        public TagMapper.TagAccessor<EntityRollingStockDefinition> apply(Class<EntityRollingStockDefinition> type, String fieldName, TagField tag) {
            return new TagMapper.TagAccessor((d, o) -> d.setString(fieldName, o == null ? null : o.defID), d -> DefinitionManager.getDefinition(d.getString(fieldName)));
        }
    }

    private static class HeightMapData {
        final int xRes;
        final int zRes;
        final List<ModelComponent> components;
        final float[] data;

        HeightMapData(EntityRollingStockDefinition def) {
            ImmersiveRailroading.info((String)"Generating heightmap %s", (Object[])new Object[]{def.defID});
            double ratio = 8.0;
            int precision = (int)Math.ceil(def.heightBounds * 4.0);
            this.xRes = (int)Math.ceil((def.frontBounds + def.rearBounds) * ratio);
            this.zRes = (int)Math.ceil(def.widthBounds * ratio);
            this.components = def.renderComponents.values().stream().flatMap(Collection::stream).filter(rc -> rc.type.collisionsEnabled).collect(Collectors.toList());
            this.data = new float[this.components.size() * this.xRes * this.zRes];
            VertexBuffer vb = (VertexBuffer)((EntityRollingStockDefinition)def).model.vbo.get();
            for (int i = 0; i < this.components.size(); ++i) {
                ModelComponent rc2 = this.components.get(i);
                int idx = i * this.xRes * this.zRes;
                for (String group : rc2.modelIDs) {
                    OBJGroup faces = (OBJGroup)((EntityRollingStockDefinition)def).model.groups.get(group);
                    for (int face = faces.faceStart; face <= faces.faceStop; ++face) {
                        Path2D.Float path = new Path2D.Float();
                        float fheight = 0.0f;
                        boolean first = true;
                        for (int point = 0; point < vb.vertsPerFace; ++point) {
                            int vertex = face * vb.vertsPerFace * vb.stride + point * vb.stride;
                            float vertX = vb.data[vertex + 0];
                            float vertY = vb.data[vertex + 1];
                            float vertZ = vb.data[vertex + 2];
                            vertX = (float)((double)vertX + def.frontBounds);
                            vertZ = (float)((double)vertZ + def.widthBounds / 2.0);
                            if (first) {
                                ((Path2D)path).moveTo((double)vertX * ratio, (double)vertZ * ratio);
                                first = false;
                            } else {
                                ((Path2D)path).lineTo((double)vertX * ratio, (double)vertZ * ratio);
                            }
                            fheight += vertY / (float)vb.vertsPerFace;
                        }
                        Rectangle2D bounds = path.getBounds2D();
                        if (bounds.getWidth() * bounds.getHeight() < 1.0) continue;
                        for (int x = 0; x < this.xRes; ++x) {
                            for (int z = 0; z < this.zRes; ++z) {
                                float relX = this.xRes - 1 - x;
                                float relZ = z;
                                if (!bounds.contains(relX, relZ) || !path.contains(relX, relZ)) continue;
                                float relHeight = fheight / (float)def.heightBounds;
                                relHeight = (float)((int)Math.ceil(relHeight * (float)precision)) / (float)precision;
                                this.data[idx + x * this.zRes + z] = Math.max(this.data[idx + x * this.zRes + z], relHeight);
                            }
                        }
                    }
                }
            }
        }
    }
}

