/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.rail;

import cam72cam.immersiverailroading.render.DisplayListCache;
import cam72cam.immersiverailroading.track.TrackBase;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.render.OpenGL;
import cam72cam.mod.world.World;
import org.lwjgl.opengl.GL11;

public class RailBaseOverlayRender {
    private static DisplayListCache cache = new DisplayListCache(){

        @Override
        public int lifespan() {
            return 1;
        }

        @Override
        public boolean sliding() {
            return false;
        }
    };

    private static void doDraw(RailInfo info, World world, Vec3i pos) {
        Vec3i placePos = new Vec3i(info.placementInfo.placementPosition).add(pos);
        for (TrackBase base : info.getBuilder(world, placePos).getTracksForRender()) {
            boolean canPlace = base.canPlaceTrack();
            if (canPlace) continue;
            OpenGL.With matrix = OpenGL.matrix();
            Throwable throwable = null;
            try {
                Vec3i tpos = base.getPos();
                tpos = tpos.subtract(placePos);
                GL11.glTranslated((double)tpos.x, (double)tpos.y, (double)(tpos.z + 1));
                GL11.glScaled((double)1.002, (double)(base.getBedHeight() + 0.2f), (double)1.002);
                GL11.glTranslated((double)-0.001, (double)0.0, (double)0.001);
                GL11.glBegin((int)7);
                GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
                GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
                GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glVertex3f((float)0.0f, (float)1.0f, (float)-1.0f);
                GL11.glVertex3f((float)1.0f, (float)1.0f, (float)-1.0f);
                GL11.glVertex3f((float)1.0f, (float)0.0f, (float)-1.0f);
                GL11.glVertex3f((float)0.0f, (float)0.0f, (float)-1.0f);
                GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glVertex3f((float)1.0f, (float)0.0f, (float)-1.0f);
                GL11.glVertex3f((float)1.0f, (float)1.0f, (float)-1.0f);
                GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
                GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glVertex3f((float)0.0f, (float)1.0f, (float)-1.0f);
                GL11.glVertex3f((float)0.0f, (float)0.0f, (float)-1.0f);
                GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
                GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
                GL11.glVertex3f((float)1.0f, (float)1.0f, (float)-1.0f);
                GL11.glVertex3f((float)0.0f, (float)1.0f, (float)-1.0f);
                GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
                GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glVertex3f((float)1.0f, (float)0.0f, (float)-1.0f);
                GL11.glVertex3f((float)0.0f, (float)0.0f, (float)-1.0f);
                GL11.glEnd();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (matrix == null) continue;
                if (throwable != null) {
                    try {
                        matrix.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                matrix.close();
            }
        }
    }

    public static void draw(RailInfo info, World world, Vec3i pos) {
        String key = info.uniqueID + pos.add(new Vec3i(info.placementInfo.placementPosition));
        Integer displayList = (Integer)cache.get(key);
        if (displayList == null) {
            displayList = GL11.glGenLists((int)1);
            GL11.glNewList((int)displayList, (int)4864);
            RailBaseOverlayRender.doDraw(info, world, pos);
            GL11.glEndList();
            cache.put(key, displayList);
        }
        try (OpenGL.With tex = OpenGL.bool((int)3553, (boolean)false);
             OpenGL.With color = OpenGL.color((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);){
            GL11.glCallList((int)displayList);
        }
    }
}

