/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import team.chisel.ctm.Configurations;
import team.chisel.ctm.api.IFacade;
import team.chisel.ctm.api.texture.ISubmap;
import team.chisel.ctm.client.util.ConnectionLocations;
import team.chisel.ctm.client.util.Dir;
import team.chisel.ctm.client.util.Submap;

@ParametersAreNonnullByDefault
public class CTMLogic {
    public static final ISubmap[] uvs = new ISubmap[]{new Submap(4.0f, 4.0f, 0.0f, 0.0f), new Submap(4.0f, 4.0f, 4.0f, 0.0f), new Submap(4.0f, 4.0f, 8.0f, 0.0f), new Submap(4.0f, 4.0f, 12.0f, 0.0f), new Submap(4.0f, 4.0f, 0.0f, 4.0f), new Submap(4.0f, 4.0f, 4.0f, 4.0f), new Submap(4.0f, 4.0f, 8.0f, 4.0f), new Submap(4.0f, 4.0f, 12.0f, 4.0f), new Submap(4.0f, 4.0f, 0.0f, 8.0f), new Submap(4.0f, 4.0f, 4.0f, 8.0f), new Submap(4.0f, 4.0f, 8.0f, 8.0f), new Submap(4.0f, 4.0f, 12.0f, 8.0f), new Submap(4.0f, 4.0f, 0.0f, 12.0f), new Submap(4.0f, 4.0f, 4.0f, 12.0f), new Submap(4.0f, 4.0f, 8.0f, 12.0f), new Submap(4.0f, 4.0f, 12.0f, 12.0f), new Submap(8.0f, 8.0f, 0.0f, 0.0f), new Submap(8.0f, 8.0f, 8.0f, 0.0f), new Submap(8.0f, 8.0f, 0.0f, 8.0f), new Submap(8.0f, 8.0f, 8.0f, 8.0f)};
    public static final ISubmap FULL_TEXTURE = new Submap(16.0f, 16.0f, 0.0f, 0.0f);
    protected static int[] submapOffsets = new int[]{4, 5, 1, 0};
    public Optional<Boolean> disableObscuredFaceCheck = Optional.empty();
    protected static final Dir[][] submapMap = new Dir[][]{{Dir.BOTTOM, Dir.LEFT, Dir.BOTTOM_LEFT}, {Dir.BOTTOM, Dir.RIGHT, Dir.BOTTOM_RIGHT}, {Dir.TOP, Dir.RIGHT, Dir.TOP_RIGHT}, {Dir.TOP, Dir.LEFT, Dir.TOP_LEFT}};
    protected byte connectionMap;
    protected int[] submapCache = new int[]{18, 19, 17, 16};
    protected boolean ignoreStates;
    protected StateComparisonCallback stateComparator = StateComparisonCallback.DEFAULT;

    public static CTMLogic getInstance() {
        return new CTMLogic();
    }

    public int[] createSubmapIndices(@Nullable IBlockReader world, BlockPos pos, Direction side) {
        if (world == null) {
            return this.submapCache;
        }
        this.buildConnectionMap(world, pos, side);
        for (int i = 0; i < 4; ++i) {
            this.fillSubmaps(i);
        }
        return this.submapCache;
    }

    public int[] createSubmapIndices(long data, Direction side) {
        this.submapCache = new int[]{18, 19, 17, 16};
        this.buildConnectionMap(data, side);
        for (int i = 0; i < 4; ++i) {
            this.fillSubmaps(i);
        }
        return this.submapCache;
    }

    public int[] getSubmapIndices() {
        return this.submapCache;
    }

    public long serialized() {
        return Byte.toUnsignedLong(this.connectionMap);
    }

    public static boolean isDefaultTexture(int id) {
        return id == 16 || id == 17 || id == 18 || id == 19;
    }

    protected void setConnectedState(Dir dir, boolean connected) {
        this.connectionMap = CTMLogic.setConnectedState(this.connectionMap, dir, connected);
    }

    private static byte setConnectedState(byte map, Dir dir, boolean connected) {
        if (connected) {
            return (byte)(map | 1 << dir.ordinal());
        }
        return (byte)(map & ~(1 << dir.ordinal()));
    }

    public void buildConnectionMap(IBlockReader world, BlockPos pos, Direction side) {
        BlockState state = this.getConnectionState(world, pos, side, pos);
        for (Dir dir : Dir.VALUES) {
            this.setConnectedState(dir, dir.isConnected(this, world, pos, side, state));
        }
    }

    public void buildConnectionMap(long data, Direction side) {
        this.connectionMap = 0;
        List<ConnectionLocations> connections = ConnectionLocations.decode(data);
        for (ConnectionLocations loc : connections) {
            Dir dir;
            if (loc.getDirForSide(side) == null || (dir = loc.getDirForSide(side)) == null) continue;
            this.setConnectedState(dir, true);
        }
    }

    protected void fillSubmaps(int idx) {
        Dir[] dirs = submapMap[idx];
        if (this.connectedOr(dirs[0], dirs[1])) {
            this.submapCache[idx] = this.connectedAnd(dirs) ? submapOffsets[idx] : submapOffsets[idx] + (this.connected(dirs[0]) ? 2 : 0) + (this.connected(dirs[1]) ? 8 : 0);
        }
    }

    public boolean connected(Dir dir) {
        return (this.connectionMap >> dir.ordinal() & 1) == 1;
    }

    public boolean connectedAnd(Dir ... dirs) {
        for (Dir dir : dirs) {
            if (this.connected(dir)) continue;
            return false;
        }
        return true;
    }

    public boolean connectedOr(Dir ... dirs) {
        for (Dir dir : dirs) {
            if (!this.connected(dir)) continue;
            return true;
        }
        return false;
    }

    public boolean connectedNone(Dir ... dirs) {
        for (Dir dir : dirs) {
            if (!this.connected(dir)) continue;
            return false;
        }
        return true;
    }

    public boolean connectedOnly(Dir ... dirs) {
        byte map = 0;
        for (Dir dir : dirs) {
            map = CTMLogic.setConnectedState(map, dir, true);
        }
        return map == this.connectionMap;
    }

    public int numConnections() {
        return Integer.bitCount(this.connectionMap);
    }

    public final boolean isConnected(IBlockReader world, BlockPos current, BlockPos connection, Direction dir) {
        BlockState state = this.getConnectionState(world, current, dir, connection);
        return this.isConnected(world, current, connection, dir, state);
    }

    public boolean isConnected(IBlockReader world, BlockPos current, BlockPos connection, Direction dir, BlockState state) {
        BlockState obscuring;
        BlockPos obscuringPos = connection.func_177972_a(dir);
        boolean disableObscured = this.disableObscuredFaceCheck.orElse(Configurations.connectInsideCTM);
        BlockState con = this.getConnectionState(world, connection, dir, current);
        BlockState blockState = obscuring = disableObscured ? null : this.getConnectionState(world, obscuringPos, dir, current);
        if (con == null) {
            throw new IllegalStateException("Error, received null blockstate as facade from block " + world.func_180495_p(connection));
        }
        boolean ret = this.stateComparator(state, con, dir);
        if (obscuring == null) {
            return ret;
        }
        return ret &= !this.stateComparator(state, obscuring, dir);
    }

    protected boolean stateComparator(BlockState from, BlockState to, Direction dir) {
        return this.stateComparator.connects(this, from, to, dir);
    }

    @Deprecated
    public static BlockState getBlockOrFacade(IBlockReader world, BlockPos pos, @Nullable Direction side, BlockPos connection) {
        return CTMLogic.getInstance().getConnectionState(world, pos, side, connection);
    }

    public BlockState getConnectionState(IBlockReader world, BlockPos pos, @Nullable Direction side, BlockPos connection) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof IFacade) {
            return ((IFacade)state.func_177230_c()).getFacade(world, pos, side, connection);
        }
        return state;
    }

    public boolean ignoreStates() {
        return this.ignoreStates;
    }

    public CTMLogic ignoreStates(boolean ignoreStates) {
        this.ignoreStates = ignoreStates;
        return this;
    }

    public StateComparisonCallback stateComparator() {
        return this.stateComparator;
    }

    public CTMLogic stateComparator(StateComparisonCallback stateComparator) {
        this.stateComparator = stateComparator;
        return this;
    }

    public static interface StateComparisonCallback {
        public static final StateComparisonCallback DEFAULT = (ctm, from, to, dir) -> ctm.ignoreStates ? from.func_177230_c() == to.func_177230_c() : from == to;

        public boolean connects(CTMLogic var1, BlockState var2, BlockState var3, Direction var4);
    }
}

