/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.entity.movement;

import javax.annotation.Nullable;
import me.jellysquid.mods.lithium.common.entity.LithiumEntityCollisions;
import me.jellysquid.mods.lithium.common.entity.movement.BlockCollisionPredicate;
import me.jellysquid.mods.lithium.common.shapes.VoxelShapeCaster;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;

public class ChunkAwareBlockCollisionSweeper {
    private static final boolean OVERSIZED_BLOCK_COUNTING_ENABLED = OversizedBlocksCounter.class.isAssignableFrom(ChunkSection.class);
    private final BlockPos.Mutable pos = new BlockPos.Mutable();
    private final AxisAlignedBB box;
    private final VoxelShape shape;
    private final ICollisionReader view;
    private final ISelectionContext context;
    private final BlockCollisionPredicate collisionPredicate;
    private final Entity entity;
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int maxX;
    private final int maxY;
    private final int maxZ;
    private int chunkX;
    private int chunkY;
    private int chunkZ;
    private int cStartX;
    private int cStartZ;
    private int cEndX;
    private int cEndZ;
    private int cX;
    private int cY;
    private int cZ;
    private int cTotalSize;
    private int cIterated;
    private boolean sectionOversizedBlocks;
    private IBlockReader cachedChunk;
    @Nullable
    private ChunkSection cachedChunkSection;
    private boolean needEntityCollisionCheck;

    public ChunkAwareBlockCollisionSweeper(ICollisionReader view, Entity entity, AxisAlignedBB box, BlockCollisionPredicate collisionPredicate) {
        this.box = box;
        this.shape = VoxelShapes.func_197881_a((AxisAlignedBB)box);
        this.context = entity == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a((Entity)entity);
        this.view = view;
        this.entity = entity;
        this.needEntityCollisionCheck = entity != null;
        this.minX = MathHelper.func_76128_c((double)(box.field_72340_a - 1.0E-7));
        this.maxX = MathHelper.func_76128_c((double)(box.field_72336_d + 1.0E-7));
        this.minY = MathHelper.func_76125_a((int)((int)(box.field_72338_b - 1.0E-7)), (int)0, (int)255);
        this.maxY = MathHelper.func_76125_a((int)((int)(box.field_72337_e + 1.0E-7)), (int)0, (int)255);
        this.minZ = MathHelper.func_76128_c((double)(box.field_72339_c - 1.0E-7));
        this.maxZ = MathHelper.func_76128_c((double)(box.field_72334_f + 1.0E-7));
        this.collisionPredicate = collisionPredicate;
        this.chunkX = this.minX - 1 >> 4;
        this.chunkZ = this.minZ - 1 >> 4;
        this.cIterated = 0;
        this.cTotalSize = 0;
        --this.chunkX;
    }

    private boolean nextSection() {
        while (true) {
            if (this.cachedChunk != null && this.chunkY < 15 && this.chunkY < this.maxY + 1 >> 4) {
                ++this.chunkY;
                this.cachedChunkSection = this.cachedChunk instanceof IChunk ? ((IChunk)this.cachedChunk).func_76587_i()[this.chunkY] : null;
            } else {
                this.chunkY = MathHelper.func_76125_a((int)(this.minY - 1 >> 4), (int)0, (int)15);
                if (this.chunkX < this.maxX + 1 >> 4) {
                    ++this.chunkX;
                } else {
                    this.chunkX = this.minX - 1 >> 4;
                    if (this.chunkZ < this.maxZ + 1 >> 4) {
                        ++this.chunkZ;
                    } else {
                        return false;
                    }
                }
                this.cachedChunk = this.view.func_225522_c_(this.chunkX, this.chunkZ);
                this.cachedChunkSection = this.cachedChunk instanceof IChunk ? ((IChunk)this.cachedChunk).func_76587_i()[this.chunkY] : null;
            }
            if (this.cachedChunk == null || this.cachedChunk instanceof IChunk && ChunkSection.func_222628_a((ChunkSection)this.cachedChunkSection)) continue;
            this.sectionOversizedBlocks = ChunkAwareBlockCollisionSweeper.hasChunkSectionOversizedBlocks(this.cachedChunk, this.chunkY);
            int sizeExtension = this.sectionOversizedBlocks ? 1 : 0;
            this.cEndX = Math.min(this.maxX + sizeExtension, 15 + (this.chunkX << 4));
            int cEndY = Math.min(this.maxY + sizeExtension, 15 + (this.chunkY << 4));
            this.cEndZ = Math.min(this.maxZ + sizeExtension, 15 + (this.chunkZ << 4));
            this.cStartX = Math.max(this.minX - sizeExtension, this.chunkX << 4);
            int cStartY = Math.max(this.minY - sizeExtension, this.chunkY << 4);
            this.cStartZ = Math.max(this.minZ - sizeExtension, this.chunkZ << 4);
            this.cX = this.cStartX;
            this.cY = cStartY;
            this.cZ = this.cStartZ;
            this.cTotalSize = (this.cEndX - this.cStartX + 1) * (cEndY - cStartY + 1) * (this.cEndZ - this.cStartZ + 1);
            if (this.cTotalSize != 0) break;
        }
        this.cIterated = 0;
        return true;
    }

    public VoxelShape getNextCollidedShape() {
        VoxelShape shape = null;
        if (this.needEntityCollisionCheck) {
            shape = this.getNextEntityCollision();
            this.needEntityCollisionCheck = false;
        }
        if (shape == null) {
            shape = this.getNextBlockCollision();
        }
        return shape;
    }

    private VoxelShape getNextBlockCollision() {
        while (this.cIterated < this.cTotalSize || this.nextSection()) {
            VoxelShape collidedShape;
            VoxelShape collisionShape;
            BlockState state;
            int edgesHit;
            ++this.cIterated;
            int x = this.cX;
            int y = this.cY++;
            int z = this.cZ;
            if (this.cX < this.cEndX) {
                ++this.cX;
            } else if (this.cZ < this.cEndZ) {
                this.cX = this.cStartX;
                ++this.cZ;
            } else {
                this.cX = this.cStartX;
                this.cZ = this.cStartZ;
            }
            if ((edgesHit = this.sectionOversizedBlocks ? (x < this.minX || x > this.maxX ? 1 : 0) + (y < this.minY || y > this.maxY ? 1 : 0) + (z < this.minZ || z > this.maxZ ? 1 : 0) : 0) == 3 || !ChunkAwareBlockCollisionSweeper.canInteractWithBlock(state = this.cachedChunkSection != null ? this.cachedChunkSection.func_177485_a(x & 0xF, y & 0xF, z & 0xF) : this.cachedChunk.func_180495_p(new BlockPos(x, y, z)), edgesHit)) continue;
            this.pos.func_181079_c(x, y, z);
            if (!this.collisionPredicate.test(this.view, (BlockPos)this.pos, state) || (collisionShape = state.func_215685_b((IBlockReader)this.view, (BlockPos)this.pos, this.context)) == VoxelShapes.func_197880_a() || (collidedShape = ChunkAwareBlockCollisionSweeper.getCollidedShape(this.box, this.shape, collisionShape, x, y, z)) == null) continue;
            return collidedShape;
        }
        return null;
    }

    private VoxelShape getNextEntityCollision() {
        if (LithiumEntityCollisions.canEntityCollideWithWorldBorder(this.view, this.entity)) {
            return this.view.func_175723_af().func_222521_a();
        }
        return null;
    }

    private static boolean canInteractWithBlock(BlockState state, int edgesHit) {
        return !(edgesHit == 1 && !state.func_215704_f() || edgesHit == 2 && state.func_177230_c() != Blocks.field_196603_bb);
    }

    private static VoxelShape getCollidedShape(AxisAlignedBB entityBox, VoxelShape entityShape, VoxelShape shape, int x, int y, int z) {
        if (shape instanceof VoxelShapeCaster) {
            if (((VoxelShapeCaster)shape).intersects(entityBox, x, y, z)) {
                return shape.func_197751_a((double)x, (double)y, (double)z);
            }
            return null;
        }
        if (VoxelShapes.func_197879_c((VoxelShape)(shape = shape.func_197751_a((double)x, (double)y, (double)z)), (VoxelShape)entityShape, (IBooleanFunction)IBooleanFunction.field_223238_i_)) {
            return shape;
        }
        return null;
    }

    private static boolean hasChunkSectionOversizedBlocks(IBlockReader chunk, int chunkY) {
        if (OVERSIZED_BLOCK_COUNTING_ENABLED && chunk instanceof IChunk) {
            ChunkSection section = ((IChunk)chunk).func_76587_i()[chunkY];
            return section != null && ((OversizedBlocksCounter)section).hasOversizedBlocks();
        }
        return true;
    }

    public static interface OversizedBlocksCounter {
        public boolean hasOversizedBlocks();
    }
}

