/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.shapes;

import com.google.common.base.Preconditions;
import me.jellysquid.mods.lithium.common.shapes.hash.VoxelShapeHash;
import me.jellysquid.mods.lithium.common.util.collections.RepeatedlyAccessedMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.BlockVoxelShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.EmptyBlockReader;
import net.minecraft.world.IBlockReader;

public class SideShapeTypeCache {
    private static final ThreadLocal<ThreadState> threadLocalState = ThreadLocal.withInitial(() -> new ThreadState());
    private static final VoxelShape CENTER_SUPPORT_SHAPE = Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)10.0, (double)9.0);
    private static final VoxelShape RIGID_SUPPORT_SHAPE = VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);

    public static boolean isSupporting(BlockVoxelShape supportType, BlockState state, Direction direction) {
        ThreadState threadState = threadLocalState.get();
        VoxelShape shape = threadState.getShape(state);
        ShapeResultCache specificCache = threadState.cachedResults.computeIfAbsent(shape, $ -> new ShapeResultCache());
        return specificCache.getOrCompute(shape, direction, supportType);
    }

    private static boolean computeIsSupporting(VoxelShape shape, Direction direction, BlockVoxelShape type) {
        switch (type) {
            case FULL: {
                return Block.func_208061_a((VoxelShape)shape, (Direction)direction);
            }
            case CENTER: {
                return !VoxelShapes.func_197879_c((VoxelShape)shape.func_212434_a(direction), (VoxelShape)CENTER_SUPPORT_SHAPE, (IBooleanFunction)IBooleanFunction.field_223232_c_);
            }
            case RIGID: {
                return !VoxelShapes.func_197879_c((VoxelShape)shape.func_212434_a(direction), (VoxelShape)RIGID_SUPPORT_SHAPE, (IBooleanFunction)IBooleanFunction.field_223232_c_);
            }
        }
        throw new IllegalArgumentException("Unknown support type: " + type.name());
    }

    private static class ThreadState {
        private final RepeatedlyAccessedMap<VoxelShape, ShapeResultCache> cachedResults = new RepeatedlyAccessedMap(VoxelShapeHash.INSTANCE);
        private VoxelShape blockShape;
        private BlockState stateForShape;

        private ThreadState() {
        }

        public VoxelShape getShape(BlockState state) {
            if (state != this.stateForShape) {
                this.stateForShape = state;
                this.blockShape = state.func_196951_e((IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a);
            }
            return this.blockShape;
        }
    }

    private static class ShapeResultCache {
        private static final int NUM_DIRECTIONS = 6;
        private static final int NUM_TYPES = BlockVoxelShape.values().length;
        private final Boolean[] values = new Boolean[6 * NUM_TYPES];

        private ShapeResultCache() {
        }

        public boolean getOrCompute(VoxelShape shape, Direction direction, BlockVoxelShape type) {
            int index = type.ordinal() * 6 + direction.ordinal();
            if (this.values[index] == null) {
                this.values[index] = SideShapeTypeCache.computeIsSupporting(shape, direction, type);
            }
            return this.values[index];
        }

        static {
            Preconditions.checkState((6 == Direction.values().length ? 1 : 0) != 0);
        }
    }
}

