/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.shapes;

import it.unimi.dsi.fastutil.doubles.DoubleList;
import me.jellysquid.mods.lithium.common.shapes.VoxelShapeAlignedCuboid;
import me.jellysquid.mods.lithium.common.shapes.lists.OffsetFractionalDoubleList;
import net.minecraft.util.AxisRotation;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapePart;

public class VoxelShapeAlignedCuboidOffset
extends VoxelShapeAlignedCuboid {
    private final double xOffset;
    private final double yOffset;
    private final double zOffset;

    public VoxelShapeAlignedCuboidOffset(VoxelShapeAlignedCuboid originalShape, VoxelShapePart voxels, double xOffset, double yOffset, double zOffset) {
        super(voxels, originalShape.xSegments, originalShape.ySegments, originalShape.zSegments, originalShape.minX + xOffset, originalShape.minY + yOffset, originalShape.minZ + zOffset, originalShape.maxX + xOffset, originalShape.maxY + yOffset, originalShape.maxZ + zOffset);
        if (originalShape instanceof VoxelShapeAlignedCuboidOffset) {
            this.xOffset = ((VoxelShapeAlignedCuboidOffset)originalShape).xOffset + xOffset;
            this.yOffset = ((VoxelShapeAlignedCuboidOffset)originalShape).yOffset + yOffset;
            this.zOffset = ((VoxelShapeAlignedCuboidOffset)originalShape).zOffset + zOffset;
        } else {
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.zOffset = zOffset;
        }
    }

    @Override
    public VoxelShape func_197751_a(double x, double y, double z) {
        return new VoxelShapeAlignedCuboidOffset(this, this.field_197768_g, x, y, z);
    }

    @Override
    public double func_212431_a(AxisRotation cycleDirection, AxisAlignedBB box, double maxDist) {
        if (Math.abs(maxDist) < 1.0E-7) {
            return 0.0;
        }
        double penetration = this.calculatePenetration(cycleDirection, box, maxDist);
        if (penetration != maxDist && this.intersects(cycleDirection, box)) {
            return penetration;
        }
        return maxDist;
    }

    private double calculatePenetration(AxisRotation dir, AxisAlignedBB box, double maxDist) {
        switch (dir) {
            case NONE: {
                return VoxelShapeAlignedCuboidOffset.calculatePenetration(this.minX, this.maxX, this.xSegments, this.xOffset, box.field_72340_a, box.field_72336_d, maxDist);
            }
            case FORWARD: {
                return VoxelShapeAlignedCuboidOffset.calculatePenetration(this.minZ, this.maxZ, this.zSegments, this.zOffset, box.field_72339_c, box.field_72334_f, maxDist);
            }
            case BACKWARD: {
                return VoxelShapeAlignedCuboidOffset.calculatePenetration(this.minY, this.maxY, this.ySegments, this.yOffset, box.field_72338_b, box.field_72337_e, maxDist);
            }
        }
        throw new IllegalArgumentException();
    }

    private static double calculatePenetration(double aMin, double aMax, int segmentsPerUnit, double shapeOffset, double bMin, double bMax, double maxDist) {
        if (maxDist > 0.0) {
            double gap = aMin - bMax;
            if (gap >= -1.0E-7) {
                return Math.min(gap, maxDist);
            }
            if (segmentsPerUnit == 1) {
                return maxDist;
            }
            int segment = MathHelper.func_76143_f((double)((bMax - 1.0E-6 - shapeOffset) * (double)segmentsPerUnit));
            double wallPos = (double)segment / (double)segmentsPerUnit + shapeOffset;
            if (wallPos < bMax - 1.0E-7) {
                wallPos = (double)(++segment) / (double)segmentsPerUnit + shapeOffset;
            }
            if (wallPos < aMax - 1.0E-6) {
                return Math.min(maxDist, wallPos - bMax);
            }
            return maxDist;
        }
        double gap = aMax - bMin;
        if (gap <= 1.0E-7) {
            return Math.max(gap, maxDist);
        }
        if (segmentsPerUnit == 1) {
            return maxDist;
        }
        int segment = MathHelper.func_76128_c((double)((bMin + 1.0E-6 - shapeOffset) * (double)segmentsPerUnit));
        double wallPos = (double)segment / (double)segmentsPerUnit + shapeOffset;
        if (wallPos > bMin + 1.0E-7) {
            wallPos = (double)(--segment) / (double)segmentsPerUnit + shapeOffset;
        }
        if (wallPos > aMin + 1.0E-6) {
            return Math.max(maxDist, wallPos - bMin);
        }
        return maxDist;
    }

    @Override
    public DoubleList func_197757_a(Direction.Axis axis) {
        return new OffsetFractionalDoubleList(axis.func_196052_a(this.xSegments, this.ySegments, this.zSegments), axis.func_196051_a(this.xOffset, this.yOffset, this.zOffset));
    }

    @Override
    protected double func_197759_b(Direction.Axis axis, int index) {
        return axis.func_196051_a(this.xOffset, this.yOffset, this.zOffset) + (double)index / (double)axis.func_196052_a(this.xSegments, this.ySegments, this.zSegments);
    }

    @Override
    protected int func_197749_a(Direction.Axis axis, double coord) {
        int numSegments = axis.func_196052_a(this.xSegments, this.ySegments, this.zSegments);
        return MathHelper.func_76125_a((int)MathHelper.func_76128_c((double)((coord -= axis.func_196051_a(this.xOffset, this.yOffset, this.zOffset)) * (double)numSegments)), (int)-1, (int)numSegments);
    }
}

