/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.shapes.pairs;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import net.minecraft.util.math.shapes.IDoubleListMerger;

public final class LithiumDoublePairList
implements IDoubleListMerger {
    private final double[] merged;
    private final int[] indicesFirst;
    private final int[] indicesSecond;
    private final DoubleArrayList pairs;

    public LithiumDoublePairList(DoubleList aPoints, DoubleList bPoints, boolean flag1, boolean flag2) {
        int size = aPoints.size() + bPoints.size();
        this.merged = new double[size];
        this.indicesFirst = new int[size];
        this.indicesSecond = new int[size];
        this.pairs = DoubleArrayList.wrap((double[])this.merged);
        this.merge(LithiumDoublePairList.getArray(aPoints), LithiumDoublePairList.getArray(bPoints), aPoints.size(), bPoints.size(), flag1, flag2);
    }

    private void merge(double[] aPoints, double[] bPoints, int aSize, int bSize, boolean includeOutsideB, boolean includeOutsideA) {
        int aIdx = 0;
        int bIdx = 0;
        double prev = 0.0;
        int nextPairIndex = 0;
        int nextPointIndex = 0;
        while (true) {
            boolean bWithinBounds;
            boolean aWithinBounds = aIdx < aSize;
            boolean bl = bWithinBounds = bIdx < bSize;
            if (!aWithinBounds && !bWithinBounds) break;
            boolean flip = aWithinBounds && (!bWithinBounds || aPoints[aIdx] < bPoints[bIdx] + 1.0E-7);
            double value = flip ? aPoints[aIdx++] : bPoints[bIdx++];
            if ((aIdx == 0 || !aWithinBounds) && !flip && !includeOutsideA || (bIdx == 0 || !bWithinBounds) && flip && !includeOutsideB) continue;
            if (nextPointIndex == 0 || prev < value - 1.0E-7) {
                this.indicesFirst[nextPairIndex] = aIdx - 1;
                this.indicesSecond[nextPairIndex] = bIdx - 1;
                this.merged[nextPointIndex] = value;
                ++nextPairIndex;
                ++nextPointIndex;
                prev = value;
                continue;
            }
            if (nextPointIndex <= 0) continue;
            this.indicesFirst[nextPairIndex - 1] = aIdx - 1;
            this.indicesSecond[nextPairIndex - 1] = bIdx - 1;
        }
        if (nextPointIndex == 0) {
            this.merged[nextPointIndex++] = Math.min(aPoints[aSize - 1], bPoints[bSize - 1]);
        }
        this.pairs.size(nextPointIndex);
    }

    public boolean func_197855_a(IDoubleListMerger.IConsumer predicate) {
        int l = this.pairs.size() - 1;
        for (int i = 0; i < l; ++i) {
            if (predicate.merge(this.indicesFirst[i], this.indicesSecond[i], i)) continue;
            return false;
        }
        return true;
    }

    public DoubleList func_212435_a() {
        return this.pairs;
    }

    private static double[] getArray(DoubleList list) {
        if (list instanceof DoubleArrayList) {
            return ((DoubleArrayList)list).elements();
        }
        double[] points = new double[list.size()];
        for (int i = 0; i < points.length; ++i) {
            points[i] = list.getDouble(i);
        }
        return points;
    }
}

