/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.world.scheduler;

import it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import me.jellysquid.mods.lithium.common.world.scheduler.TickEntry;
import me.jellysquid.mods.lithium.common.world.scheduler.TickEntryQueue;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.TickPriority;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerTickList;
import net.minecraft.world.server.ServerWorld;

public class LithiumServerTickScheduler<T>
extends ServerTickList<T> {
    private final Long2ObjectSortedMap<TickEntryQueue<T>> scheduledTicksOrdered = new Long2ObjectAVLTreeMap();
    private final ObjectOpenHashSet<TickEntry<T>> scheduledTicks = new ObjectOpenHashSet();
    private final ArrayList<TickEntry<T>> executingTicks = new ArrayList();
    private final ObjectOpenHashSet<TickEntry<T>> executingTicksSet = new ObjectOpenHashSet();
    private final Predicate<T> invalidObjPredicate;
    private final ServerWorld world;
    private final Consumer<NextTickListEntry<T>> tickConsumer;

    public LithiumServerTickScheduler(ServerWorld world, Predicate<T> invalidPredicate, Function<T, ResourceLocation> idToName, Consumer<NextTickListEntry<T>> tickConsumer) {
        super(world, invalidPredicate, idToName, tickConsumer);
        this.invalidObjPredicate = invalidPredicate;
        this.world = world;
        this.tickConsumer = tickConsumer;
    }

    public void func_205365_a() {
        this.world.func_217381_Z().func_76320_a("cleaning");
        this.selectTicks(this.world.func_82737_E());
        this.world.func_217381_Z().func_219895_b("executing");
        this.executeTicks(this.tickConsumer);
        this.world.func_217381_Z().func_76319_b();
    }

    public boolean func_205361_b(BlockPos pos, T obj) {
        TickEntry entry = (TickEntry)((Object)this.executingTicksSet.get(new TickEntry<T>(pos, obj)));
        if (entry == null) {
            return false;
        }
        return !entry.consumed;
    }

    public boolean func_205359_a(BlockPos pos, T obj) {
        return this.scheduledTicks.contains(new TickEntry<T>(pos, obj));
    }

    public List<NextTickListEntry<T>> func_205366_a(MutableBoundingBox bounds, boolean remove, boolean getConsumedTicks) {
        ArrayList<NextTickListEntry<T>> collectedTicks = new ArrayList<NextTickListEntry<T>>();
        ObjectOpenHashSet<TickEntry<T>> scheduledTicks = this.scheduledTicks;
        for (TickEntryQueue tickEntryQueue : this.scheduledTicksOrdered.values()) {
            for (int i = 0; i < tickEntryQueue.size(); ++i) {
                BlockPos tickPos;
                TickEntry tick = tickEntryQueue.getTickAtIndex(i);
                if (tick == null || (tickPos = tick.field_180282_a).func_177958_n() < bounds.field_78897_a || tickPos.func_177958_n() >= bounds.field_78893_d || tickPos.func_177952_p() < bounds.field_78896_c || tickPos.func_177952_p() >= bounds.field_78892_f) continue;
                collectedTicks.add(new TickEntry<Object>(tick.field_180282_a, tick.func_151351_a(), tick.field_235017_b_, tick.field_82754_f));
                if (!remove) continue;
                tickEntryQueue.setTickAtIndex(i, null);
                scheduledTicks.remove(tick);
            }
        }
        if (!this.executingTicks.isEmpty()) {
            ArrayList consumedTicks = new ArrayList();
            ArrayList<TickEntry<T>> executingTicks = this.executingTicks;
            ObjectOpenHashSet<TickEntry<T>> executingTicksSet = this.executingTicksSet;
            int ticksSize = executingTicks.size();
            for (int i = 0; i < ticksSize; ++i) {
                BlockPos tickPos;
                TickEntry<T> tick = executingTicks.get(i);
                if (tick == null || !getConsumedTicks && tick.consumed || (tickPos = tick.field_180282_a).func_177958_n() < bounds.field_78897_a || tickPos.func_177958_n() >= bounds.field_78893_d || tickPos.func_177952_p() < bounds.field_78896_c || tickPos.func_177952_p() >= bounds.field_78892_f) continue;
                (tick.consumed ? consumedTicks : collectedTicks).add(new TickEntry<Object>(tick.field_180282_a, tick.func_151351_a(), tick.field_235017_b_, tick.field_82754_f));
                if (!remove) continue;
                executingTicks.set(i, null);
                executingTicksSet.remove(tick);
            }
            collectedTicks.addAll(consumedTicks);
        }
        return collectedTicks;
    }

    private static long getBucketKey(long time, TickPriority priority) {
        return time << 4 | (long)(priority.ordinal() & 0xF);
    }

    public void func_205368_a(MutableBoundingBox box, BlockPos pos) {
        List<NextTickListEntry<T>> list = this.func_205366_a(box, false, false);
        for (NextTickListEntry<T> tick : list) {
            this.scheduleTick(tick.field_180282_a.func_177971_a((Vector3i)pos), tick.func_151351_a(), tick.field_235017_b_, tick.field_82754_f);
        }
    }

    public int func_225420_a() {
        return this.scheduledTicks.size();
    }

    public void func_205362_a(BlockPos pos, T obj, int delay, TickPriority priority) {
        if (!this.invalidObjPredicate.test(obj)) {
            this.scheduleTick(pos, obj, (long)delay + this.world.func_82737_E(), priority);
        }
    }

    public void selectTicks(long time) {
        long headKey = LithiumServerTickScheduler.getBucketKey(time + 1L, TickPriority.EXTREMELY_HIGH) - 1L;
        int limit = 65536;
        boolean canTick = true;
        long prevChunk = Long.MIN_VALUE;
        ObjectIterator it = this.scheduledTicksOrdered.headMap(headKey).values().iterator();
        ServerChunkProvider chunkManager = this.world.func_72863_F();
        while (limit > 0 && it.hasNext()) {
            TickEntryQueue list = (TickEntryQueue)it.next();
            int w = 0;
            for (int i = 0; i < list.size(); ++i) {
                TickEntry tick = list.getTickAtIndex(i);
                if (tick == null) continue;
                if (limit > 0) {
                    long chunk = ChunkPos.func_77272_a((int)(tick.field_180282_a.func_177958_n() >> 4), (int)(tick.field_180282_a.func_177952_p() >> 4));
                    if (prevChunk != chunk) {
                        prevChunk = chunk;
                        canTick = chunkManager.func_222866_a(tick.field_180282_a);
                    }
                    if (canTick) {
                        this.scheduledTicks.remove(tick);
                        this.selectForExecution(tick);
                        --limit;
                        continue;
                    }
                }
                list.setTickAtIndex(w++, tick);
            }
            list.resize(w);
            if (!list.isEmpty()) continue;
            it.remove();
        }
    }

    public void executeTicks(Consumer<NextTickListEntry<T>> consumer) {
        TickEntry<T> tick = null;
        try {
            ArrayList<TickEntry<T>> ticks = this.executingTicks;
            int ticksSize = ticks.size();
            for (int i = 0; i < ticksSize; ++i) {
                tick = ticks.get(i);
                if (tick == null) continue;
                tick.consumed = true;
                consumer.accept(tick);
            }
        }
        catch (Throwable e) {
            CrashReport crash = CrashReport.func_85055_a((Throwable)e, (String)"Exception while ticking");
            CrashReportCategory section = crash.func_85058_a("Block being ticked");
            CrashReportCategory.func_175750_a((CrashReportCategory)section, (BlockPos)(tick == null ? BlockPos.field_177992_a : tick.field_180282_a), null);
            throw new ReportedException(crash);
        }
        this.executingTicks.clear();
        this.executingTicksSet.clear();
    }

    private void scheduleTick(BlockPos pos, T object, long time, TickPriority priority) {
        TickEntry<T> tick = new TickEntry<T>(pos, object, time, priority);
        boolean added = this.scheduledTicks.add(tick);
        if (added) {
            TickEntryQueue timeIdx = (TickEntryQueue)this.scheduledTicksOrdered.computeIfAbsent(LithiumServerTickScheduler.getBucketKey(tick.field_235017_b_, tick.field_82754_f), key -> new TickEntryQueue());
            timeIdx.push(tick);
        }
    }

    private void selectForExecution(TickEntry<T> tick) {
        this.executingTicks.add(tick);
        this.executingTicksSet.add(tick);
    }
}

