/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.ai.goal;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.profiler.IProfiler;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GoalSelector.class})
public abstract class GoalSelectorMixin {
    private static final Goal.Flag[] CONTROLS = Goal.Flag.values();
    @Shadow
    @Final
    private Supplier<IProfiler> field_75781_c;
    @Mutable
    @Shadow
    @Final
    private Set<PrioritizedGoal> field_220892_d;
    @Shadow
    @Final
    private EnumSet<Goal.Flag> field_220893_f;
    @Shadow
    @Final
    private Map<Goal.Flag, PrioritizedGoal> field_220891_c;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void reinit(Supplier<IProfiler> supplier, CallbackInfo ci) {
        this.field_220892_d = new ObjectLinkedOpenHashSet(this.field_220892_d);
    }

    @Overwrite
    public void func_75774_a() {
        this.updateGoalStates();
        this.tickGoals();
    }

    private void updateGoalStates() {
        this.field_75781_c.get().func_76320_a("goalUpdate");
        this.stopGoals();
        this.cleanupControls();
        this.startGoals();
        this.field_75781_c.get().func_76319_b();
    }

    private void stopGoals() {
        for (PrioritizedGoal goal : this.field_220892_d) {
            if (!goal.func_220773_g() || goal.func_75253_b() && !this.areControlsDisabled(goal)) continue;
            goal.func_75251_c();
        }
    }

    private void cleanupControls() {
        for (Goal.Flag control : CONTROLS) {
            PrioritizedGoal goal = this.field_220891_c.get(control);
            if (goal == null || goal.func_220773_g()) continue;
            this.field_220891_c.remove(control);
        }
    }

    private void startGoals() {
        for (PrioritizedGoal goal : this.field_220892_d) {
            if (goal.func_220773_g() || !goal.func_75250_a() || !this.areGoalControlsAvailable(goal)) continue;
            for (Goal.Flag control : goal.func_220686_i()) {
                PrioritizedGoal otherGoal = this.getGoalOccupyingControl(control);
                if (otherGoal != null) {
                    otherGoal.func_75251_c();
                }
                this.setGoalOccupyingControl(control, goal);
            }
            goal.func_75249_e();
        }
    }

    private void tickGoals() {
        this.field_75781_c.get().func_76320_a("goalTick");
        for (PrioritizedGoal goal : this.field_220892_d) {
            if (!goal.func_220773_g()) continue;
            goal.func_75246_d();
        }
        this.field_75781_c.get().func_76319_b();
    }

    private boolean areControlsDisabled(PrioritizedGoal goal) {
        for (Goal.Flag control : goal.func_220686_i()) {
            if (!this.isControlDisabled(control)) continue;
            return true;
        }
        return false;
    }

    private boolean areGoalControlsAvailable(PrioritizedGoal goal) {
        for (Goal.Flag control : goal.func_220686_i()) {
            if (this.isControlDisabled(control)) {
                return false;
            }
            PrioritizedGoal occupied = this.getGoalOccupyingControl(control);
            if (occupied == null || occupied.func_220771_a(goal)) continue;
            return false;
        }
        return true;
    }

    private boolean isControlDisabled(Goal.Flag control) {
        return this.field_220893_f.contains(control);
    }

    private PrioritizedGoal getGoalOccupyingControl(Goal.Flag control) {
        return this.field_220891_c.get(control);
    }

    private void setGoalOccupyingControl(Goal.Flag control, PrioritizedGoal goal) {
        this.field_220891_c.put(control, goal);
    }
}

