/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.ai.pathing;

import me.jellysquid.mods.lithium.common.ai.pathing.DetailedBlockPathingBehavior;
import me.jellysquid.mods.lithium.common.ai.pathing.PathNodeCache;
import me.jellysquid.mods.lithium.common.world.WorldHelper;
import net.minecraft.block.BlockState;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={WalkNodeProcessor.class})
public abstract class LandPathNodeMakerMixin {
    @Overwrite
    public static PathNodeType func_237238_b_(IBlockReader blockView, BlockPos blockPos) {
        PathNodeType type;
        BlockState blockState = blockView.func_180495_p(blockPos);
        if (((DetailedBlockPathingBehavior)blockState.func_177230_c()).needsDynamicNodeTypeCheck()) {
            type = blockState.getAiPathNodeType(blockView, blockPos);
            if (type == null) {
                type = PathNodeCache.getPathNodeType(blockState);
            }
        } else {
            type = PathNodeCache.getPathNodeType(blockState);
            if (type != PathNodeType.LAVA && type != PathNodeType.DANGER_FIRE && ((DetailedBlockPathingBehavior)blockState.func_177230_c()).needsDynamicBurningCheck() && blockState.isBurning(blockView, blockPos)) {
                type = PathNodeType.DANGER_FIRE;
            }
        }
        if (type == PathNodeType.OPEN) {
            if (!blockState.func_196957_g(blockView, blockPos, PathType.LAND)) {
                return PathNodeType.BLOCKED;
            }
            return PathNodeType.OPEN;
        }
        return type;
    }

    @Overwrite
    public static PathNodeType func_237232_a_(IBlockReader world, BlockPos.Mutable pos, PathNodeType type) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        ChunkSection section = null;
        if (world instanceof ICollisionReader && WorldHelper.areNeighborsWithinSameChunk((BlockPos)pos)) {
            IChunk chunk;
            if (!World.func_217405_b((int)y) && (chunk = (IChunk)((ICollisionReader)world).func_225522_c_(x >> 4, z >> 4)) != null) {
                section = chunk.func_76587_i()[y >> 4];
            }
            if (ChunkSection.func_222628_a(section) || PathNodeCache.isSectionSafeAsNeighbor(section)) {
                return type;
            }
        }
        int xStart = x - 1;
        int yStart = y - 1;
        int zStart = z - 1;
        int xEnd = x + 1;
        int yEnd = y + 1;
        int zEnd = z + 1;
        for (int adjX = xStart; adjX <= xEnd; ++adjX) {
            for (int adjY = yStart; adjY <= yEnd; ++adjY) {
                for (int adjZ = zStart; adjZ <= zEnd; ++adjZ) {
                    PathNodeType neighborType;
                    BlockState state;
                    if (adjX == x && adjZ == z || (state = section != null ? section.func_177485_a(adjX & 0xF, adjY & 0xF, adjZ & 0xF) : world.func_180495_p((BlockPos)pos.func_181079_c(adjX, adjY, adjZ))).func_196958_f() || (neighborType = PathNodeCache.getNeighborPathNodeType(state)) == PathNodeType.OPEN) continue;
                    return neighborType;
                }
            }
        }
        return type;
    }
}

