/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.block.moving_block_shapes;

import me.jellysquid.mods.lithium.common.shapes.OffsetVoxelShapeCache;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PistonBlock;
import net.minecraft.block.PistonHeadBlock;
import net.minecraft.state.Property;
import net.minecraft.tileentity.PistonTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={PistonTileEntity.class})
public abstract class PistonBlockEntityMixin {
    private static final VoxelShape[] PISTON_BASE_WITH_MOVING_HEAD_SHAPES = PistonBlockEntityMixin.precomputePistonBaseWithMovingHeadShapes();
    @Shadow
    private Direction field_174931_f;
    @Shadow
    private boolean field_145875_k;
    @Shadow
    private boolean field_145872_l;

    @Inject(method={"getCollisionShape"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/math/Direction;getOffsetX()I", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void skipVoxelShapeUnion(IBlockReader world, BlockPos pos, CallbackInfoReturnable<VoxelShape> cir, VoxelShape voxelShape2, Direction direction, BlockState blockState2, float f) {
        if (this.field_145875_k || !this.field_145872_l) {
            VoxelShape blockShape = blockState2.func_196952_d(world, pos);
            VoxelShape offsetAndSimplified = PistonBlockEntityMixin.getOffsetAndSimplified(blockShape, Math.abs(f), f < 0.0f ? this.field_174931_f.func_176734_d() : this.field_174931_f);
            cir.setReturnValue((Object)offsetAndSimplified);
        } else {
            int index = PistonBlockEntityMixin.getIndexForMergedShape(f, this.field_174931_f);
            cir.setReturnValue((Object)PISTON_BASE_WITH_MOVING_HEAD_SHAPES[index]);
        }
    }

    private static VoxelShape getOffsetAndSimplified(VoxelShape blockShape, float offset, Direction direction) {
        VoxelShape offsetSimplifiedShape = ((OffsetVoxelShapeCache)blockShape).getOffsetSimplifiedShape(offset, direction);
        if (offsetSimplifiedShape == null) {
            offsetSimplifiedShape = blockShape.func_197751_a((double)((float)direction.func_82601_c() * offset), (double)((float)direction.func_96559_d() * offset), (double)((float)direction.func_82599_e() * offset)).func_197753_c();
            ((OffsetVoxelShapeCache)blockShape).setShape(offset, direction, offsetSimplifiedShape);
        }
        return offsetSimplifiedShape;
    }

    private static VoxelShape[] precomputePistonBaseWithMovingHeadShapes() {
        float[] offsets = new float[]{0.0f, 0.5f, 1.0f};
        Direction[] directions = Direction.values();
        VoxelShape[] mergedShapes = new VoxelShape[offsets.length * directions.length];
        for (Direction facing : directions) {
            VoxelShape baseShape = ((BlockState)((BlockState)Blocks.field_150331_J.func_176223_P().func_206870_a((Property)PistonBlock.field_176320_b, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PistonBlock.field_176387_N, (Comparable)facing)).func_196952_d(null, null);
            for (float offset : offsets) {
                boolean isShort = offset < 0.25f;
                VoxelShape headShape = ((BlockState)((BlockState)Blocks.field_150332_K.func_176223_P().func_206870_a((Property)PistonHeadBlock.field_176387_N, (Comparable)facing)).func_206870_a((Property)PistonHeadBlock.field_176327_M, (Comparable)Boolean.valueOf(isShort))).func_196952_d(null, null);
                VoxelShape offsetHead = headShape.func_197751_a((double)((float)facing.func_82601_c() * offset), (double)((float)facing.func_96559_d() * offset), (double)((float)facing.func_82599_e() * offset));
                mergedShapes[PistonBlockEntityMixin.getIndexForMergedShape((float)offset, (Direction)facing)] = VoxelShapes.func_197872_a((VoxelShape)baseShape, (VoxelShape)offsetHead);
            }
        }
        return mergedShapes;
    }

    private static int getIndexForMergedShape(float offset, Direction direction) {
        if (offset != 0.0f && offset != 0.5f && offset != 1.0f) {
            return -1;
        }
        return (int)(2.0f * offset) + 3 * direction.func_176745_a();
    }
}

