/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.block.moving_block_shapes;

import me.jellysquid.mods.lithium.common.shapes.OffsetVoxelShapeCache;
import me.jellysquid.mods.lithium.common.util.tuples.FinalObject;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={VoxelShape.class})
public class VoxelShapeMixin
implements OffsetVoxelShapeCache {
    private FinalObject<VoxelShape>[] offsetAndSimplified;

    @Override
    public void setShape(float offset, Direction direction, VoxelShape offsetShape) {
        if (offsetShape == null) {
            throw new IllegalArgumentException("offsetShape must not be null!");
        }
        int index = VoxelShapeMixin.getIndexForOffsetSimplifiedShapes(offset, direction);
        FinalObject<VoxelShape>[] offsetAndSimplified = this.offsetAndSimplified;
        if (offsetAndSimplified == null) {
            this.offsetAndSimplified = offsetAndSimplified = new FinalObject[13];
        }
        offsetAndSimplified[index] = new FinalObject<VoxelShape>(offsetShape);
    }

    @Override
    public VoxelShape getOffsetSimplifiedShape(float offset, Direction direction) {
        FinalObject<VoxelShape>[] offsetAndSimplified = this.offsetAndSimplified;
        if (offsetAndSimplified == null) {
            return null;
        }
        int index = VoxelShapeMixin.getIndexForOffsetSimplifiedShapes(offset, direction);
        FinalObject<VoxelShape> wrappedShape = offsetAndSimplified[index];
        return wrappedShape == null ? null : wrappedShape.getValue();
    }

    private static int getIndexForOffsetSimplifiedShapes(float offset, Direction direction) {
        if (offset != 0.0f && offset != 0.5f && offset != 1.0f) {
            throw new IllegalArgumentException("offset must be one of {0f, 0.5f, 1f}");
        }
        if (offset == 0.0f) {
            return 0;
        }
        return (int)(2.0f * offset) + 2 * direction.func_176745_a();
    }
}

