/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.entity.data_tracker.use_arrays;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import me.jellysquid.mods.lithium.common.util.collections.CopyOnWriteI2OOpenHashMap;
import me.jellysquid.mods.lithium.common.util.lock.NullReadBasicWriteLock;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityDataManager.class})
public abstract class DataTrackerMixin {
    @Mutable
    @Shadow
    @Final
    private Map<Integer, EntityDataManager.DataEntry<?>> field_187234_c;
    @Shadow
    @Final
    @Mutable
    private ReadWriteLock field_187235_d;
    private volatile EntityDataManager.DataEntry<?>[] entriesArray = new EntityDataManager.DataEntry[0];

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void reinit(Entity trackedEntity, CallbackInfo ci) {
        this.field_187234_c = new CopyOnWriteI2OOpenHashMap(this.field_187234_c);
        this.field_187235_d = new NullReadBasicWriteLock();
    }

    @Redirect(method={"addTrackedData"}, at=@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"))
    private Object onAddTrackedDataInsertMap(Map<Class<? extends Entity>, Integer> map, Object keyRaw, Object valueRaw) {
        int k = (Integer)keyRaw;
        EntityDataManager.DataEntry v = (EntityDataManager.DataEntry)valueRaw;
        EntityDataManager.DataEntry<?>[] storage = Arrays.copyOf(this.entriesArray, Math.max(k + 1, this.entriesArray.length));
        storage[k] = v;
        EntityDataManager.DataEntry result = this.field_187234_c.put(k, v);
        this.entriesArray = storage;
        return result;
    }

    @Overwrite
    public <T> EntityDataManager.DataEntry<T> func_187219_c(DataParameter<T> data) {
        try {
            EntityDataManager.DataEntry<?>[] array = this.entriesArray;
            int id = data.func_187155_a();
            if (id < 0 || id >= array.length || array[id] == null) {
                return this.field_187234_c.get(data);
            }
            return array[id];
        }
        catch (Throwable cause) {
            throw DataTrackerMixin.onGetException(cause, data);
        }
    }

    private static <T> ReportedException onGetException(Throwable cause, DataParameter<T> data) {
        CrashReport report = CrashReport.func_85055_a((Throwable)cause, (String)"Getting synced entity data");
        CrashReportCategory section = report.func_85058_a("Synced entity data");
        section.func_71507_a("Data ID", data);
        return new ReportedException(report);
    }
}

