/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.gen.perlin_noise;

import java.util.Random;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.ImprovedNoiseGenerator;
import net.minecraft.world.gen.SimplexNoiseGenerator;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ImprovedNoiseGenerator.class})
public class PerlinNoiseSamplerMixin {
    private static final int GRADIENT_STRIDE = 4;
    private static final int GRADIENT_STRIDE_SH = 2;
    @Shadow
    @Final
    private byte[] field_76312_d;
    @Shadow
    @Final
    public double field_76315_a;
    @Shadow
    @Final
    public double field_76313_b;
    @Shadow
    @Final
    public double field_76314_c;
    private final byte[] gradientTable = new byte[1024];

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void reinit(Random random, CallbackInfo ci) {
        for (int i = 0; i < 256; ++i) {
            int hash = this.field_76312_d[i & 0xFF] & 0xF;
            for (int j = 0; j < 3; ++j) {
                this.gradientTable[i * 4 + j] = (byte)SimplexNoiseGenerator.field_215468_a[hash][j];
            }
        }
    }

    @Overwrite
    public double func_215456_a(double x, double y, double z, double d, double e) {
        double ox = x + this.field_76315_a;
        double oy = y + this.field_76313_b;
        double oz = z + this.field_76314_c;
        double fox = Math.floor(ox);
        double foy = Math.floor(oy);
        double foz = Math.floor(oz);
        double oox = ox - fox;
        double ooy = oy - foy;
        double ooz = oz - foz;
        double fx = MathHelper.func_219801_j((double)oox);
        double fy = MathHelper.func_219801_j((double)ooy);
        double fz = MathHelper.func_219801_j((double)ooz);
        if (d != 0.0) {
            ooy -= Math.floor(Math.min(e, ooy) / d) * d;
        }
        return this.func_215459_a((int)fox, (int)foy, (int)foz, oox, ooy, ooz, fx, fy, fz);
    }

    @Overwrite
    public double func_215459_a(int sectionX, int sectionY, int sectionZ, double localX1, double localY1, double localZ1, double fadeLocalX, double fadeLocalY, double fadeLocalZ) {
        byte[] perm = this.field_76312_d;
        int i = (perm[sectionX & 0xFF] & 0xFF) + sectionY;
        int l = (perm[sectionX + 1 & 0xFF] & 0xFF) + sectionY;
        int j = (perm[0xFF & i] & 0xFF) + sectionZ;
        int m = (perm[l & 0xFF] & 0xFF) + sectionZ;
        int k = (perm[i + 1 & 0xFF] & 0xFF) + sectionZ;
        int n = (perm[l + 1 & 0xFF] & 0xFF) + sectionZ;
        double localX2 = localX1 - 1.0;
        double localY2 = localY1 - 1.0;
        double localZ2 = localZ1 - 1.0;
        int d00 = (j & 0xFF) << 2;
        int d01 = (m & 0xFF) << 2;
        int d02 = (k & 0xFF) << 2;
        int d03 = (n & 0xFF) << 2;
        int d10 = (j + 1 & 0xFF) << 2;
        int d11 = (m + 1 & 0xFF) << 2;
        int d12 = (k + 1 & 0xFF) << 2;
        int d13 = (n + 1 & 0xFF) << 2;
        byte[] grad = this.gradientTable;
        double g00x = (double)grad[d00] * localX1;
        double g00y = (double)grad[d00 + 1] * localY1;
        double g00z = (double)grad[d00 + 2] * localZ1;
        double g01x = (double)grad[d01] * localX2;
        double g01y = (double)grad[d01 + 1] * localY1;
        double g01z = (double)grad[d01 + 2] * localZ1;
        double g02x = (double)grad[d02] * localX1;
        double g02y = (double)grad[d02 + 1] * localY2;
        double g02z = (double)grad[d02 + 2] * localZ1;
        double g03x = (double)grad[d03] * localX2;
        double g03y = (double)grad[d03 + 1] * localY2;
        double g03z = (double)grad[d03 + 2] * localZ1;
        double g10x = (double)grad[d10] * localX1;
        double g10y = (double)grad[d10 + 1] * localY1;
        double g10z = (double)grad[d10 + 2] * localZ2;
        double g11x = (double)grad[d11] * localX2;
        double g11y = (double)grad[d11 + 1] * localY1;
        double g11z = (double)grad[d11 + 2] * localZ2;
        double g12x = (double)grad[d12] * localX1;
        double g12y = (double)grad[d12 + 1] * localY2;
        double g12z = (double)grad[d12 + 2] * localZ2;
        double g13x = (double)grad[d13] * localX2;
        double g13y = (double)grad[d13 + 1] * localY2;
        double g13z = (double)grad[d13 + 2] * localZ2;
        double g00 = g00x + g00y + g00z;
        double g01 = g01x + g01y + g01z;
        double g02 = g02x + g02y + g02z;
        double g03 = g03x + g03y + g03z;
        double g10 = g10x + g10y + g10z;
        double g11 = g11x + g11y + g11z;
        double g12 = g12x + g12y + g12z;
        double g13 = g13x + g13y + g13z;
        double ba1 = g01 - g00;
        double ba2 = g11 - g10;
        double dc1 = g03 - g02;
        double dc2 = g13 - g12;
        double dba1 = fadeLocalX * ba1;
        double dba2 = fadeLocalX * ba2;
        double ddc1 = fadeLocalX * dc1;
        double ddc2 = fadeLocalX * dc2;
        double dd0 = g00 + dba1;
        double dd1 = g10 + dba2;
        double dd2 = g02 + ddc1;
        double dd3 = g12 + ddc2;
        double aa0 = dd2 - dd0;
        double aa1 = dd3 - dd1;
        double y20 = fadeLocalY * aa0;
        double y31 = fadeLocalY * aa1;
        double aa2 = dd0 + y20;
        double aa3 = dd1 + y31;
        return dd0 + y20 + fadeLocalZ * (aa3 - aa2);
    }
}

