/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.internal.proxy;

import it.zerono.mods.zerocore.internal.InternalCommand;
import it.zerono.mods.zerocore.internal.network.ErrorReportMessage;
import it.zerono.mods.zerocore.internal.network.Network;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;

public interface IProxy {
    public Optional<World> getClientWorld();

    public Optional<PlayerEntity> getClientPlayer();

    public void markBlockRangeForRenderUpdate(BlockPos var1, BlockPos var2);

    public void sendPlayerStatusMessage(PlayerEntity var1, ITextComponent var2);

    public void addResourceReloadListener(ISelectiveResourceReloadListener var1);

    default public long getLastRenderTime() {
        return 0L;
    }

    default public void reportErrorToPlayer(@Nullable PlayerEntity player, @Nullable BlockPos position, ITextComponent ... messages) {
        if (player instanceof ServerPlayerEntity) {
            Network.HANDLER.sendToPlayer(ErrorReportMessage.create(position, messages), (ServerPlayerEntity)player);
        }
    }

    default public void reportErrorToPlayer(@Nullable PlayerEntity player, @Nullable BlockPos position, List<ITextComponent> messages) {
        if (player instanceof ServerPlayerEntity) {
            Network.HANDLER.sendToPlayer(ErrorReportMessage.create(position, messages), (ServerPlayerEntity)player);
        }
    }

    default public void displayErrorToPlayer(@Nullable BlockPos position, ITextComponent ... messages) {
    }

    default public void displayErrorToPlayer(@Nullable BlockPos position, List<ITextComponent> messages) {
    }

    public void clearErrorReport();

    @Nullable
    public RecipeManager getRecipeManager();

    default public void handleInternalCommand(InternalCommand command, CompoundNBT data, NetworkDirection direction) {
    }

    public void debugUngrabMouse();
}

