/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.zerono.mods.zerocore.ZeroCore;
import it.zerono.mods.zerocore.internal.Lib;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.multiblock.validation.ValidationError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;

public final class CodeHelper {
    public static final Object[] EMPTY_GENERIC_ARRAY = new Object[0];
    public static final ITextComponent TEXT_EMPTY_LINE = new StringTextComponent("");
    public static final Direction[] DIRECTIONS = Direction.values();
    public static final Direction[] POSITIVE_DIRECTIONS;
    public static final Direction[] NEGATIVE_DIRECTIONS;
    public static final AxisAlignedBB EMPTY_BOUNDING_BOX;
    public static final BlockPos MIN_BLOCKPOS;
    public static final BlockPos MAX_BLOCKPOS;
    public static final AxisAlignedBB EMPTY_AABB;
    public static final BooleanSupplier TRUE_SUPPLIER;
    public static final BooleanSupplier FALSE_SUPPLIER;
    public static final IntConsumer VOID_INT_CONSUMER;
    public static final BooleanConsumer VOID_BOOL_CONSUMER;
    public static final Runnable VOID_RUNNABLE;
    public static final int MOUSE_BUTTON_LEFT = 0;
    public static final int MOUSE_BUTTON_RIGHT = 1;
    public static final int MOUSE_BUTTON_MIDDLE = 2;
    public static final int MOUSE_BUTTON_WHEEL_DOWN = -1;
    public static final int MOUSE_BUTTON_WHEEL_UP = -2;
    private static final long UNSIGNED_MASK = Long.MAX_VALUE;
    private static final Int2ObjectMap<String> s_siPrefixes;
    private static final Random s_fakeRandom;
    private static final Map<Direction, List<Direction>> s_perpendicularDirections;

    public static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static ModContainer getActiveMod() {
        return ModLoadingContext.get().getActiveContainer();
    }

    public static String getModIdFromActiveModContainer() {
        String modId = CodeHelper.getActiveMod().getModId();
        if (null == modId || modId.isEmpty()) {
            throw new RuntimeException("Cannot retrieve the MOD ID from FML");
        }
        return modId;
    }

    public static boolean isDevEnv() {
        String target = System.getenv("target");
        return !Strings.isNullOrEmpty((String)target) && target.startsWith("fmluserdev");
    }

    public static long getSystemTime() {
        return Util.func_211178_c();
    }

    public static Random fakeRandom() {
        s_fakeRandom.setSeed(42L);
        return s_fakeRandom;
    }

    public static String neutralLowercase(String input) {
        return input.toLowerCase(Locale.ROOT);
    }

    @Nullable
    public static RecipeManager getRecipeManager() {
        return ZeroCore.getProxy().getRecipeManager();
    }

    public static RecipeManager getRecipeManager(World world) {
        return world.func_199532_z();
    }

    public static boolean shouldInvalidateResourceCache() {
        return Lib.shouldInvalidateResourceCache();
    }

    public static Stream<Direction> directionStream() {
        return Arrays.stream(DIRECTIONS);
    }

    public static Direction.Plane perpendicularPlane(Direction direction) {
        return CodeHelper.perpendicularPlane(direction.func_176740_k().func_176716_d());
    }

    public static Direction.Plane perpendicularPlane(Direction.Axis axis) {
        return CodeHelper.perpendicularPlane(axis.func_176716_d());
    }

    public static Direction.Plane perpendicularPlane(Direction.Plane plane) {
        return Direction.Plane.HORIZONTAL == plane ? Direction.Plane.VERTICAL : Direction.Plane.HORIZONTAL;
    }

    public static List<Direction> perpendicularDirections(Direction direction) {
        return s_perpendicularDirections.get(direction);
    }

    public static Direction directionRotateAround(Direction direction, Direction.Axis axis) {
        switch (axis) {
            case X: {
                if (direction != Direction.WEST && direction != Direction.EAST) {
                    return CodeHelper.directionRotateX(direction);
                }
                return direction;
            }
            case Y: {
                if (direction != Direction.UP && direction != Direction.DOWN) {
                    return CodeHelper.directionRotateY(direction);
                }
                return direction;
            }
            case Z: {
                if (direction != Direction.NORTH && direction != Direction.SOUTH) {
                    return CodeHelper.directionRotateZ(direction);
                }
                return direction;
            }
        }
        throw new IllegalStateException("Unable to get CW facing for axis " + axis);
    }

    public static Direction directionRotateY(Direction direction) {
        switch (direction) {
            case NORTH: {
                return Direction.EAST;
            }
            case EAST: {
                return Direction.SOUTH;
            }
            case SOUTH: {
                return Direction.WEST;
            }
            case WEST: {
                return Direction.NORTH;
            }
        }
        throw new IllegalStateException("Unable to get Y-rotated facing of " + direction);
    }

    public static Direction directionRotateX(Direction direction) {
        switch (direction) {
            case NORTH: {
                return Direction.DOWN;
            }
            default: {
                throw new IllegalStateException("Unable to get X-rotated facing of " + direction);
            }
            case SOUTH: {
                return Direction.UP;
            }
            case UP: {
                return Direction.NORTH;
            }
            case DOWN: 
        }
        return Direction.SOUTH;
    }

    public static Direction directionRotateZ(Direction direction) {
        switch (direction) {
            case EAST: {
                return Direction.DOWN;
            }
            default: {
                throw new IllegalStateException("Unable to get Z-rotated facing of " + direction);
            }
            case WEST: {
                return Direction.UP;
            }
            case UP: {
                return Direction.EAST;
            }
            case DOWN: 
        }
        return Direction.WEST;
    }

    public static Direction directionRotateYCCW(Direction direction) {
        switch (direction) {
            case NORTH: {
                return Direction.WEST;
            }
            case EAST: {
                return Direction.NORTH;
            }
            case SOUTH: {
                return Direction.EAST;
            }
            case WEST: {
                return Direction.SOUTH;
            }
        }
        throw new IllegalStateException("Unable to get CCW facing of " + direction);
    }

    public static boolean calledByLogicalServer(World world) {
        return !world.field_72995_K;
    }

    public static boolean calledByLogicalClient(World world) {
        return world.field_72995_K;
    }

    public static void callOnLogicalSide(World world, Runnable serverCode, Runnable clientCode) {
        if (CodeHelper.calledByLogicalServer(world)) {
            serverCode.run();
        } else {
            clientCode.run();
        }
    }

    public static <T> T callOnLogicalSide(World world, Supplier<T> serverCode, Supplier<T> clientCode) {
        if (CodeHelper.calledByLogicalServer(world)) {
            return serverCode.get();
        }
        return clientCode.get();
    }

    public static boolean callOnLogicalSide(World world, BooleanSupplier serverCode, BooleanSupplier clientCode) {
        if (CodeHelper.calledByLogicalServer(world)) {
            return serverCode.getAsBoolean();
        }
        return clientCode.getAsBoolean();
    }

    public static int callOnLogicalSide(World world, IntSupplier serverCode, IntSupplier clientCode) {
        if (CodeHelper.calledByLogicalServer(world)) {
            return serverCode.getAsInt();
        }
        return clientCode.getAsInt();
    }

    public static long callOnLogicalSide(World world, LongSupplier serverCode, LongSupplier clientCode) {
        if (CodeHelper.calledByLogicalServer(world)) {
            return serverCode.getAsLong();
        }
        return clientCode.getAsLong();
    }

    public static double callOnLogicalSide(World world, DoubleSupplier serverCode, DoubleSupplier clientCode) {
        if (CodeHelper.calledByLogicalServer(world)) {
            return serverCode.getAsDouble();
        }
        return clientCode.getAsDouble();
    }

    public static void callOnLogicalServer(World world, Runnable code) {
        if (CodeHelper.calledByLogicalServer(world)) {
            code.run();
        }
    }

    public static <T> T callOnLogicalServer(World world, Supplier<T> code, Supplier<T> invalidSideReturnValue) {
        return CodeHelper.calledByLogicalServer(world) ? code.get() : invalidSideReturnValue.get();
    }

    public static boolean callOnLogicalServer(World world, BooleanSupplier code) {
        return CodeHelper.calledByLogicalServer(world) && code.getAsBoolean();
    }

    public static int callOnLogicalServer(World world, IntSupplier code, int invalidSideReturnValue) {
        return CodeHelper.calledByLogicalServer(world) ? code.getAsInt() : invalidSideReturnValue;
    }

    public static long callOnLogicalServer(World world, LongSupplier code, long invalidSideReturnValue) {
        return CodeHelper.calledByLogicalServer(world) ? code.getAsLong() : invalidSideReturnValue;
    }

    public static double callOnLogicalServer(World world, DoubleSupplier code, double invalidSideReturnValue) {
        return CodeHelper.calledByLogicalServer(world) ? code.getAsDouble() : invalidSideReturnValue;
    }

    public static void callOnLogicalClient(World world, Runnable code) {
        if (CodeHelper.calledByLogicalClient(world)) {
            code.run();
        }
    }

    public static <T> T callOnLogicalClient(World world, Supplier<T> code, Supplier<T> invalidSideReturnValue) {
        return CodeHelper.calledByLogicalClient(world) ? code.get() : invalidSideReturnValue.get();
    }

    public static boolean callOnLogicalClient(World world, BooleanSupplier code) {
        return CodeHelper.calledByLogicalClient(world) && code.getAsBoolean();
    }

    public static int callOnLogicalClient(World world, IntSupplier code, int invalidSideReturnValue) {
        return CodeHelper.calledByLogicalClient(world) ? code.getAsInt() : invalidSideReturnValue;
    }

    public static long callOnLogicalClient(World world, LongSupplier code, long invalidSideReturnValue) {
        return CodeHelper.calledByLogicalClient(world) ? code.getAsLong() : invalidSideReturnValue;
    }

    public static double callOnLogicalClient(World world, DoubleSupplier code, double invalidSideReturnValue) {
        return CodeHelper.calledByLogicalClient(world) ? code.getAsDouble() : invalidSideReturnValue;
    }

    public static LogicalSide getWorldLogicalSide(World world) {
        return CodeHelper.calledByLogicalClient(world) ? LogicalSide.CLIENT : LogicalSide.SERVER;
    }

    public static String getWorldSideName(World world) {
        return CodeHelper.calledByLogicalClient(world) ? "CLIENT" : "SERVER";
    }

    public static ThreadTaskExecutor<?> getThreadTaskExecutor(LogicalSide side) {
        return (ThreadTaskExecutor)LogicalSidedProvider.WORKQUEUE.get(side);
    }

    public static ThreadTaskExecutor<?> getClientThreadTaskExecutor() {
        return CodeHelper.getThreadTaskExecutor(LogicalSide.CLIENT);
    }

    public static ThreadTaskExecutor<?> getServerThreadTaskExecutor() {
        return CodeHelper.getThreadTaskExecutor(LogicalSide.SERVER);
    }

    public static CompletableFuture<Void> enqueueTask(LogicalSide side, Runnable runnable) {
        ThreadTaskExecutor<?> executor = CodeHelper.getThreadTaskExecutor(side);
        if (!executor.func_213162_bc()) {
            return executor.func_213165_a(runnable);
        }
        runnable.run();
        return CompletableFuture.completedFuture(null);
    }

    public static Optional<MinecraftServer> getMinecraftServer() {
        return Optional.ofNullable(LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER));
    }

    public static void addResourceReloadListener(ISelectiveResourceReloadListener listener) {
        ZeroCore.getProxy().addResourceReloadListener(Objects.requireNonNull(listener));
    }

    public static Runnable delayedRunnable(final Runnable code, final int tickDelay) {
        return new Runnable(){
            private final Runnable _code;
            private final int _delay;
            private int _ticks;
            {
                this._code = code;
                this._delay = tickDelay;
                this._ticks = 0;
            }

            @Override
            public void run() {
                ++this._ticks;
                if (this._ticks >= this._delay) {
                    this._ticks = 0;
                    this._code.run();
                }
            }
        };
    }

    public static BooleanSupplier tickCountdown(final int tickCountdown) {
        return new BooleanSupplier(){
            private int _countdown;
            {
                this._countdown = tickCountdown;
            }

            @Override
            public boolean getAsBoolean() {
                --this._countdown;
                if (this._countdown <= 0) {
                    this._countdown = tickCountdown;
                    return true;
                }
                return false;
            }
        };
    }

    public static void reportErrorToPlayer(PlayerEntity player, ValidationError error) {
        CodeHelper.reportErrorToPlayer(player, error.getPosition(), error.getChatMessage());
    }

    public static void reportErrorToPlayer(PlayerEntity player, @Nullable BlockPos position, ITextComponent ... errors) {
        ZeroCore.getProxy().reportErrorToPlayer(player, position, errors);
    }

    public static void reportErrorToPlayer(PlayerEntity player, @Nullable BlockPos position, List<ITextComponent> errors) {
        ZeroCore.getProxy().reportErrorToPlayer(player, position, errors);
    }

    public static void clearErrorReport() {
        ZeroCore.getProxy().clearErrorReport();
    }

    public static boolean ioDirectoryExist(Path path) {
        try {
            return Files.exists(path, LinkOption.NOFOLLOW_LINKS) && Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS);
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    public static boolean ioCreateDirectory(Path parent, String subDirectoryName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)subDirectoryName) ? 1 : 0) != 0);
        Path subDirectory = Paths.get(parent.toAbsolutePath().toString(), subDirectoryName);
        if (CodeHelper.ioDirectoryExist(subDirectory)) {
            return true;
        }
        try {
            Files.createDirectory(subDirectory, new FileAttribute[0]);
            return true;
        }
        catch (IOException ex) {
            Log.LOGGER.error("Failed to create directory {} : {}", (Object)subDirectory, (Object)ex);
            return false;
        }
    }

    public static boolean ioCreateModConfigDirectory(String name) {
        return CodeHelper.ioCreateDirectory(FMLPaths.CONFIGDIR.get(), name);
    }

    public static <T> NonNullSupplier<T> asNonNull(Supplier<T> supplier, NonNullSupplier<T> fallbackValue) {
        return () -> {
            Object current = supplier.get();
            return null != current ? current : fallbackValue.get();
        };
    }

    public static <T, R> NonNullFunction<T, R> asNonNull(Function<T, R> function, NonNullFunction<T, R> fallbackValue) {
        return v -> {
            Object current = function.apply(v);
            return null != current ? current : fallbackValue.apply(v);
        };
    }

    public static <T> void optionalIfPresentOrElse(Optional<T> opt, Consumer<? super T> action, Runnable emptyAction) {
        if (opt.isPresent()) {
            action.accept(opt.get());
        } else {
            emptyAction.run();
        }
    }

    public static <T> void optionalIfPresentOrThrow(Optional<T> opt, Consumer<? super T> action) {
        if (!opt.isPresent()) {
            throw new NoSuchElementException();
        }
        action.accept(opt.get());
    }

    public static <T> Optional<T> optionalOr(Optional<T> opt, NonNullSupplier<? extends Optional<? extends T>> supplier) {
        Objects.requireNonNull(supplier);
        if (opt.isPresent()) {
            return opt;
        }
        Optional r = (Optional)supplier.get();
        return Objects.requireNonNull(r);
    }

    public static <T> T optionalGetOr(Optional<T> opt1, Optional<T> opt2) {
        return opt1.orElse(opt2.get());
    }

    public static <T, U> void optionalIfPresent(Optional<T> opt1, Optional<U> opt2, BiConsumer<? super T, ? super U> consumer) {
        Objects.requireNonNull(consumer);
        if (opt1.isPresent() && opt2.isPresent()) {
            consumer.accept(opt1.get(), opt2.get());
        }
    }

    public static <T, U, R> Optional<R> optionalMap(Optional<T> opt1, Optional<U> opt2, BiFunction<? super T, ? super U, ? extends R> mapper) {
        Objects.requireNonNull(mapper);
        if (opt1.isPresent() && opt2.isPresent()) {
            return Optional.ofNullable(mapper.apply(opt1.get(), opt2.get()));
        }
        return Optional.empty();
    }

    public static <T, U, R> Optional<R> optionalFlatMap(Optional<T> opt1, Optional<U> opt2, BiFunction<? super T, ? super U, Optional<R>> mapper) {
        Objects.requireNonNull(mapper);
        if (opt1.isPresent() && opt2.isPresent()) {
            return Objects.requireNonNull(mapper.apply(opt1.get(), opt2.get()));
        }
        return Optional.empty();
    }

    public static <T> Stream<T> optionalStream(Optional<T> opt) {
        return opt.map(Stream::of).orElseGet(Stream::empty);
    }

    public static <T> boolean optionalIsEmpty(Optional<T> opt) {
        return !opt.isPresent();
    }

    public static <X, Y> Optional<Y> optionalCast(Optional<X> opt) {
        return opt;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ITextComponent i18nFormatComponent(String translateKey, Object ... parameters) {
        return new StringTextComponent(I18n.func_135052_a((String)translateKey, (Object[])parameters));
    }

    public static void sendChatMessage(PlayerEntity sender, ITextComponent component) {
        sender.func_145747_a(component, sender.func_110124_au());
    }

    public static void sendStatusMessage(PlayerEntity player, ITextComponent message) {
        ZeroCore.getProxy().sendPlayerStatusMessage(player, message);
    }

    public static int positiveModulo(int numerator, int denominator) {
        return (numerator % denominator + denominator) % denominator;
    }

    public static float mathLerp(float from, float to, float modifier) {
        modifier = Math.min(1.0f, Math.max(0.0f, modifier));
        return from + modifier * (to - from);
    }

    public static int mathVolume(BlockPos minimum, BlockPos maximum) {
        return CodeHelper.mathVolume(minimum.func_177958_n(), minimum.func_177956_o(), minimum.func_177952_p(), maximum.func_177958_n(), maximum.func_177956_o(), maximum.func_177952_p());
    }

    public static int mathVolume(int x1, int y1, int z1, int x2, int y2, int z2) {
        int cx = Math.abs(x2 - x1) + 1;
        int cy = Math.abs(y2 - y1) + 1;
        int cz = Math.abs(z2 - z1) + 1;
        return cx * cy * cz;
    }

    public static int mathTruncateToInt(long value) {
        return Ints.saturatedCast((long)value);
    }

    public static int mathClampUnsignedToInt(long value) {
        return value < 0L || value > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)value;
    }

    public static long mathClampUnsignedToLong(long value) {
        return value < 0L ? Long.MAX_VALUE : value;
    }

    public static float mathUnsignedLongToFloat(long value) {
        float fValue = value & Long.MAX_VALUE;
        if (value < 0L) {
            fValue += 9.223372E18f;
        }
        return fValue;
    }

    public static double mathUnsignedLongToDouble(long value) {
        double dValue = value & Long.MAX_VALUE;
        if (value < 0L) {
            dValue += 9.223372036854776E18;
        }
        return dValue;
    }

    public static boolean mathUnsignedLongMultiplicationWillOverFlow(long a, long b) {
        return a != 0L && b != 0L && Long.compareUnsigned(b, Long.divideUnsigned(-1L, a)) > 0;
    }

    public static int commonVertices(Vector3i a, Vector3i b) {
        return (a.func_177958_n() == b.func_177958_n() ? 1 : 0) + (a.func_177956_o() == b.func_177956_o() ? 1 : 0) + (a.func_177952_p() == b.func_177952_p() ? 1 : 0);
    }

    public static String formatAsHumanReadableNumber(double value, String unit) {
        int order = 0;
        if (0.0 != value) {
            while (value > 1000.0) {
                value /= 1000.0;
                order += 3;
            }
            while (value < 1.0) {
                value *= 1000.0;
                order -= 3;
            }
        }
        int decimals = 2;
        String format = String.format("%%.%1$df %%2$s%%3$s", decimals);
        return String.format(format, value, s_siPrefixes.get(order), unit);
    }

    public static String formatAsHumanReadableNumber(long value, String unit) {
        int order = 0;
        if (0L != value) {
            while (value > 1000L) {
                value /= 1000L;
                order += 3;
            }
            while (value < 1L) {
                value *= 1000L;
                order -= 3;
            }
        }
        return value + " " + (String)s_siPrefixes.get(order) + unit;
    }

    public static String formatAsMillibuckets(float value) {
        String format;
        if (value <= 1.0E-5f) {
            return "0.000 mB";
        }
        int power = (int)Math.floor(Math.log10(value));
        if (power < 1) {
            format = "%.3f mB";
        } else if (power < 2) {
            format = "%.2f mB";
        } else if (power < 3) {
            format = "%.1f mB";
        } else if (power < 4) {
            format = "%.0f mB";
        } else {
            value /= 1000.0f;
            format = power < 5 ? "%.2f B" : (power < 6 ? "%.1f B" : "%.0f B");
        }
        return String.format(format, Float.valueOf(value));
    }

    public static String zeroFilled(int count) {
        char[] zeros = new char[count];
        Arrays.fill(zeros, '0');
        return new String(zeros);
    }

    public static String toString(Vector3i value) {
        return String.format("(%d, %d, %d)", value.func_177958_n(), value.func_177956_o(), value.func_177952_p());
    }

    static {
        EMPTY_BOUNDING_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        MIN_BLOCKPOS = new BlockPos(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        MAX_BLOCKPOS = new BlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        EMPTY_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TRUE_SUPPLIER = () -> true;
        FALSE_SUPPLIER = () -> false;
        VOID_INT_CONSUMER = v -> {};
        VOID_BOOL_CONSUMER = v -> {};
        VOID_RUNNABLE = () -> {};
        s_fakeRandom = new Random();
        HashMap prefixes = Maps.newHashMap();
        prefixes.put(24, "Y");
        prefixes.put(21, "Z");
        prefixes.put(18, "E");
        prefixes.put(15, "P");
        prefixes.put(12, "T");
        prefixes.put(9, "G");
        prefixes.put(6, "M");
        prefixes.put(3, "k");
        prefixes.put(0, "");
        prefixes.put(-3, "m");
        prefixes.put(-6, "\u00ce\u00bc");
        prefixes.put(-9, "n");
        prefixes.put(-12, "p");
        prefixes.put(-15, "f");
        prefixes.put(-18, "a");
        prefixes.put(-21, "z");
        prefixes.put(-24, "y");
        s_siPrefixes = Int2ObjectMaps.unmodifiable((Int2ObjectMap)new Int2ObjectArrayMap((Map)prefixes));
        ObjectArrayList xPerpendicularsDirections = new ObjectArrayList((Object[])new Direction[]{Direction.NORTH, Direction.DOWN, Direction.SOUTH, Direction.UP});
        ObjectArrayList yPerpendicularsDirections = new ObjectArrayList((Object[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST});
        ObjectArrayList zPerpendicularsDirections = new ObjectArrayList((Object[])new Direction[]{Direction.EAST, Direction.DOWN, Direction.WEST, Direction.UP});
        s_perpendicularDirections = new Object2ObjectArrayMap(DIRECTIONS.length);
        s_perpendicularDirections.put(Direction.UP, (List<Direction>)yPerpendicularsDirections);
        s_perpendicularDirections.put(Direction.DOWN, (List<Direction>)yPerpendicularsDirections);
        s_perpendicularDirections.put(Direction.NORTH, (List<Direction>)zPerpendicularsDirections);
        s_perpendicularDirections.put(Direction.SOUTH, (List<Direction>)zPerpendicularsDirections);
        s_perpendicularDirections.put(Direction.EAST, (List<Direction>)xPerpendicularsDirections);
        s_perpendicularDirections.put(Direction.WEST, (List<Direction>)xPerpendicularsDirections);
        POSITIVE_DIRECTIONS = (Direction[])Arrays.stream(DIRECTIONS).filter(d -> d.func_176743_c() == Direction.AxisDirection.POSITIVE).toArray(Direction[]::new);
        NEGATIVE_DIRECTIONS = (Direction[])Arrays.stream(DIRECTIONS).filter(d -> d.func_176743_c() == Direction.AxisDirection.NEGATIVE).toArray(Direction[]::new);
    }
}

