/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.zerono.mods.zerocore.lib.client.gui.IRichText;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import it.zerono.mods.zerocore.lib.data.geometry.Point;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraftforge.common.util.NonNullSupplier;

public class RichText
implements IRichText {
    public static final RichText EMPTY = new RichText();
    public static final int NO_MAX_WIDTH = -1;
    final List<TextLine> _lines;
    final NonNullSupplier<FontRenderer> _fontSupplier;
    private Colour _textColour;
    private int _interline;
    private Rectangle _bounds;
    private final boolean _dynamic;

    public static Builder builder() {
        return new Builder(Integer.MAX_VALUE);
    }

    public static Builder builder(int maxWidth) {
        return maxWidth < 1 ? new Builder(Integer.MAX_VALUE) : new Builder(maxWidth);
    }

    @Override
    public void paint(MatrixStack matrix, int x, int y, int zLevel) {
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.0, 0.0, (double)zLevel);
        for (TextLine line : this._lines) {
            line.paint(this, matrix, x, y);
            y += line.getHeight() + this._interline;
        }
        matrix.func_227865_b_();
    }

    @Override
    public Rectangle bounds() {
        if (null == this._bounds || this._dynamic) {
            this._bounds = new Rectangle(0, 0, this._lines.stream().mapToInt(TextLine::getWidth).max().orElse(0), (this._lines.size() - 1) * this._interline + this._lines.stream().mapToInt(TextLine::getHeight).sum());
        }
        return this._bounds;
    }

    @Override
    public boolean isEmpty() {
        return this._lines.isEmpty();
    }

    @Override
    public boolean isNotEmpty() {
        return !this._lines.isEmpty();
    }

    private RichText() {
        this(ModRenderHelper.DEFAULT_FONT_RENDERER, Collections.emptyList());
    }

    private RichText(NonNullSupplier<FontRenderer> font, List<TextLine> lines) {
        this._lines = lines;
        this._fontSupplier = font;
        this._textColour = Colour.BLACK;
        this._interline = 0;
        this._bounds = null;
        this._dynamic = this._lines.stream().anyMatch(TextLine::isDynamic);
    }

    private static void paintString(RichText richText, String chunk, MatrixStack matrix, int x, int y) {
        ((FontRenderer)richText._fontSupplier.get()).func_238405_a_(matrix, chunk, (float)x, (float)y, richText._textColour.toARGB());
    }

    private static void paintString(RichText richText, ITextProperties chunk, MatrixStack matrix, int x, int y) {
        ((FontRenderer)richText._fontSupplier.get()).func_238407_a_(matrix, LanguageMap.func_74808_a().func_241870_a(chunk), (float)x, (float)y, richText._textColour.toARGB());
    }

    private static void paintItemStack(RichText richText, ItemStack chunk, MatrixStack matrix, int x, int y) {
        ModRenderHelper.paintItemStackWithCount(matrix, chunk, x, y, false);
    }

    private static void paintItemStackNoCount(RichText richText, ItemStack chunk, MatrixStack matrix, int x, int y) {
        ModRenderHelper.paintItemStack(matrix, chunk, x, y, "", false);
    }

    private static void paintSprite(RichText richText, ISprite chunk, MatrixStack matrix, int x, int y) {
        ModRenderHelper.paintSprite(matrix, chunk, new Point(x, y), 0, 16, 16);
    }

    public static class Builder {
        private static final ITextChunk EMPTY = new TextChunk<String>("", 5, 5, (richText, chunk, matrix, x, y) -> {});
        private static final List<TextLine> EMPTY_LINE = ObjectLists.unmodifiable((ObjectList)ObjectLists.singleton((Object)TextLine.from(EMPTY)));
        private final int _maxWidth;
        protected List<ITextComponent> _lines;
        protected List<Object> _objects;
        protected NonNullSupplier<FontRenderer> _fontSupplier;
        protected Colour _textColour;
        protected int _interline;

        public RichText build() {
            RichText rich = new RichText(this._fontSupplier, this.buildLines());
            rich._textColour = this._textColour;
            rich._interline = this._interline;
            return rich;
        }

        public Builder textLines(List<ITextComponent> lines) {
            Preconditions.checkArgument((!lines.isEmpty() ? 1 : 0) != 0);
            this._lines = lines;
            return this;
        }

        public Builder textLines(ITextComponent line) {
            return this.textLines((List<ITextComponent>)ImmutableList.of((Object)line));
        }

        public Builder textLines(ITextComponent ... lines) {
            return this.textLines((List<ITextComponent>)ImmutableList.copyOf((Object[])lines));
        }

        public Builder objects(List<Object> objects) {
            this._objects = objects;
            return this;
        }

        public Builder font(NonNullSupplier<FontRenderer> font) {
            this._fontSupplier = Objects.requireNonNull(font);
            return this;
        }

        public Builder defaultColour(Colour colour) {
            this._textColour = Objects.requireNonNull(colour);
            return this;
        }

        public Builder interline(int interline) {
            this._interline = interline;
            return this;
        }

        protected Builder(int maxWidth) {
            this._maxWidth = maxWidth;
            this._lines = Collections.emptyList();
            this._objects = Collections.emptyList();
            this._fontSupplier = ModRenderHelper.DEFAULT_FONT_RENDERER;
            this._textColour = Colour.BLACK;
            this._interline = 0;
        }

        protected List<TextLine> buildLines() {
            return (List)this._lines.stream().map(this._objects.isEmpty() ? this::splitPlainText : this::splitFormattedText).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
        }

        protected List<TextLine> splitPlainText(ITextComponent component) {
            List<ITextProperties> textProperties = this.split(component);
            if (textProperties.isEmpty()) {
                return EMPTY_LINE;
            }
            return (List)textProperties.stream().map(this::line).collect(ImmutableList.toImmutableList());
        }

        protected List<TextLine> splitFormattedText(ITextComponent component) {
            List<ITextProperties> textProperties = this.split(component);
            if (textProperties.isEmpty()) {
                return EMPTY_LINE;
            }
            int objectsCount = this._objects.size();
            LinkedList textLines = Lists.newLinkedList();
            StringBuilder sb = new StringBuilder();
            for (ITextProperties tp : textProperties) {
                String text = tp.getString();
                if (!text.contains("@")) {
                    textLines.add(this.line(tp));
                    continue;
                }
                ArrayList chunks = Lists.newArrayList();
                for (int index = 0; index < text.length(); ++index) {
                    String currentChar = text.substring(index, index + 1);
                    if ("@".equals(currentChar)) {
                        int objectIndex;
                        if (16 == (objectIndex = text.charAt(++index) - 48)) {
                            sb.append('@');
                            continue;
                        }
                        if (objectIndex < 0 || objectIndex > 9 || objectIndex >= objectsCount) {
                            throw new IllegalArgumentException(text);
                        }
                        if (sb.length() > 0) {
                            chunks.add(this.chunk(sb, component.func_150256_b()));
                            sb = new StringBuilder();
                        }
                        chunks.add(this.genericChunk(this._objects.get(objectIndex)));
                        continue;
                    }
                    sb.append(currentChar);
                }
                if (sb.length() > 0) {
                    chunks.add(this.chunk(sb, component.func_150256_b()));
                }
                textLines.add(TextLine.from(chunks));
            }
            return textLines;
        }

        protected List<ITextProperties> split(ITextComponent component) {
            return ModRenderHelper.splitLines((FontRenderer)this._fontSupplier.get(), (ITextProperties)component, this._maxWidth, component.func_150256_b());
        }

        protected TextLine line(ITextProperties tp) {
            return TextLine.from(this.chunk(tp));
        }

        protected ITextChunk chunk(ITextProperties text) {
            int n = ((FontRenderer)this._fontSupplier.get()).func_238414_a_(text);
            ((FontRenderer)this._fontSupplier.get()).getClass();
            return new TextChunk<ITextProperties>(text, n, 9, (x$0, x$1, x$2, x$3, x$4) -> RichText.paintString(x$0, x$1, x$2, x$3, x$4));
        }

        protected ITextChunk chunk(StringBuilder builder, Style style) {
            return this.chunk((ITextProperties)new StringTextComponent(builder.toString()).func_230530_a_(style));
        }

        protected ITextChunk chunk(String text) {
            int n = ((FontRenderer)this._fontSupplier.get()).func_78256_a(text);
            ((FontRenderer)this._fontSupplier.get()).getClass();
            return new TextChunk<String>(text, n, 9, (x$0, x$1, x$2, x$3, x$4) -> RichText.paintString(x$0, x$1, x$2, x$3, x$4));
        }

        private ITextChunk chunk(Supplier<String> text) {
            return new DynamicTextChunk(text, this._fontSupplier);
        }

        private ITextChunk chunk(NonNullSupplier<ITextComponent> text) {
            return new TranslationTextChunk(text, this._fontSupplier);
        }

        private ITextChunk chunk(ItemStack stack) {
            return new TextChunk<ItemStack>(stack, 16, 16, (x$0, x$1, x$2, x$3, x$4) -> RichText.paintItemStack(x$0, x$1, x$2, x$3, x$4));
        }

        private ITextChunk chunk(IItemProvider item) {
            return new TextChunk<ItemStack>(new ItemStack(item), 16, 16, (x$0, x$1, x$2, x$3, x$4) -> RichText.paintItemStackNoCount(x$0, x$1, x$2, x$3, x$4));
        }

        private ITextChunk chunk(ISprite sprite) {
            return new TextChunk<ISprite>(sprite, 16, 16, (x$0, x$1, x$2, x$3, x$4) -> RichText.paintSprite(x$0, x$1, x$2, x$3, x$4));
        }

        private ITextChunk genericChunk(Object thing) {
            if (thing instanceof String) {
                return this.chunk((String)thing);
            }
            if (thing instanceof Supplier) {
                return this.chunk((Supplier)thing);
            }
            if (thing instanceof NonNullSupplier) {
                return this.chunk((NonNullSupplier<ITextComponent>)((NonNullSupplier)thing));
            }
            if (thing instanceof ITextComponent) {
                return this.chunk((ITextProperties)((ITextComponent)thing));
            }
            if (thing instanceof ItemStack) {
                return this.chunk((ItemStack)thing);
            }
            if (thing instanceof Item) {
                return this.chunk((IItemProvider)((Item)thing));
            }
            if (thing instanceof Block) {
                return this.chunk((IItemProvider)((Block)thing));
            }
            if (thing instanceof ISprite) {
                return this.chunk((ISprite)thing);
            }
            return EMPTY;
        }
    }

    private static class TranslationTextChunk
    extends TextChunk<NonNullSupplier<ITextComponent>> {
        private final NonNullSupplier<FontRenderer> _fontSupplier;

        public TranslationTextChunk(NonNullSupplier<ITextComponent> thing, NonNullSupplier<FontRenderer> fontSupplier) {
            ((FontRenderer)fontSupplier.get()).getClass();
            super(thing, 0, 9, TranslationTextChunk::paintString);
            this._fontSupplier = fontSupplier;
        }

        @Override
        public int getWidth() {
            return ((FontRenderer)this._fontSupplier.get()).func_238414_a_((ITextProperties)((NonNullSupplier)this.get()).get());
        }

        private static void paintString(RichText richText, NonNullSupplier<ITextComponent> chunk, MatrixStack matrix, int x, int y) {
            RichText.paintString(richText, (ITextProperties)chunk.get(), matrix, x, y);
        }
    }

    private static class DynamicTextChunk
    extends TextChunk<Supplier<String>> {
        private final NonNullSupplier<FontRenderer> _fontSupplier;

        public DynamicTextChunk(Supplier<String> thing, NonNullSupplier<FontRenderer> fontSupplier) {
            ((FontRenderer)fontSupplier.get()).getClass();
            super(thing, 0, 9, DynamicTextChunk::paintString);
            this._fontSupplier = fontSupplier;
        }

        @Override
        public int getWidth() {
            return ((FontRenderer)this._fontSupplier.get()).func_78256_a((String)((Supplier)this.get()).get());
        }

        private static void paintString(RichText richText, Supplier<String> chunk, MatrixStack matrix, int x, int y) {
            RichText.paintString(richText, chunk.get(), matrix, x, y);
        }
    }

    private static class TextChunk<T>
    implements ITextChunk,
    NonNullSupplier<T> {
        private final T _thing;
        private final int _width;
        private final int _height;
        private final IChunkPainter<T> _painter;

        public TextChunk(T thing, int width, int height, IChunkPainter<T> painter) {
            this._thing = Objects.requireNonNull(thing);
            this._width = width;
            this._height = height;
            this._painter = Objects.requireNonNull(painter);
        }

        @Override
        public int getWidth() {
            return this._width;
        }

        @Override
        public int getHeight() {
            return this._height;
        }

        @Override
        public void paint(RichText richText, MatrixStack matrix, int x, int y) {
            this._painter.paint(richText, this._thing, matrix, x, y);
        }

        public T get() {
            return this._thing;
        }

        @FunctionalInterface
        public static interface IChunkPainter<T> {
            public void paint(RichText var1, T var2, MatrixStack var3, int var4, int var5);
        }
    }

    private static class TextLine
    implements ITextChunk {
        final ObjectList<ITextChunk> _chunks;
        final int _maxWidth;
        final int _maxHeight;
        final boolean _dynamic;

        public static TextLine from(ITextChunk chunk) {
            return new TextLine(chunk);
        }

        public static TextLine from(List<ITextChunk> chunks) {
            return 1 == chunks.size() ? new TextLine(chunks.get(0)) : new TextLine(chunks);
        }

        private TextLine(ITextChunk chunk) {
            Preconditions.checkNotNull((Object)chunk);
            this._chunks = ObjectLists.unmodifiable((ObjectList)ObjectLists.singleton((Object)chunk));
            this._dynamic = false;
            this._maxWidth = chunk.getWidth();
            this._maxHeight = chunk.getHeight();
        }

        private TextLine(List<ITextChunk> chunks) {
            Preconditions.checkArgument((!chunks.isEmpty() ? 1 : 0) != 0);
            this._chunks = ObjectLists.unmodifiable((ObjectList)new ObjectArrayList(chunks));
            this._dynamic = this._chunks.stream().anyMatch(c -> c instanceof DynamicTextChunk);
            this._maxWidth = this._dynamic ? -1 : this.computeMaxWidth();
            this._maxHeight = this._chunks.stream().mapToInt(ITextChunk::getHeight).max().orElse(0);
        }

        public boolean isDynamic() {
            return this._dynamic;
        }

        @Override
        public int getWidth() {
            return this._dynamic ? this.computeMaxWidth() : this._maxWidth;
        }

        @Override
        public int getHeight() {
            return this._maxHeight;
        }

        @Override
        public void paint(RichText richText, MatrixStack matrix, int x, int y) {
            for (ITextChunk chunk : this._chunks) {
                chunk.paint(richText, matrix, x, y + (this._maxHeight - chunk.getHeight()) / 2);
                x += chunk.getWidth();
            }
        }

        private int computeMaxWidth() {
            return this._chunks.stream().mapToInt(ITextChunk::getWidth).sum();
        }
    }

    private static interface ITextChunk {
        public int getWidth();

        public int getHeight();

        public void paint(RichText var1, MatrixStack var2, int var3, int var4);
    }
}

