/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.nbt;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.zerono.mods.zerocore.lib.item.inventory.ItemStackHolder;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.items.ItemStackHandler;

public interface ISyncableEntity {
    default public void syncDataFrom(CompoundNBT data, SyncReason syncReason) {
    }

    default public CompoundNBT syncDataTo(CompoundNBT data, SyncReason syncReason) {
        return data;
    }

    default public boolean syncChildDataEntityFrom(ISyncableEntity childEntity, String dataKey, CompoundNBT parentData, SyncReason syncReason) {
        if (parentData.func_74764_b(dataKey)) {
            childEntity.syncDataFrom(parentData.func_74775_l(dataKey), syncReason);
            return true;
        }
        return false;
    }

    default public void syncChildDataEntityTo(ISyncableEntity childEntity, String dataKey, CompoundNBT parentData, SyncReason syncReason) {
        parentData.func_218657_a(dataKey, (INBT)childEntity.syncDataTo(new CompoundNBT(), syncReason));
    }

    default public void syncDataElementFrom(String dataKey, CompoundNBT parentData, NonNullConsumer<CompoundNBT> consumer) {
        if (parentData.func_74764_b(dataKey)) {
            consumer.accept((Object)parentData.func_74775_l(dataKey));
        }
    }

    default public void syncDataElementTo(String dataKey, CompoundNBT parentData, CompoundNBT value) {
        parentData.func_218657_a(dataKey, (INBT)value);
    }

    default public void syncDataElementFrom(String dataKey, CompoundNBT parentData, ItemStackHandler value) {
        if (parentData.func_74764_b(dataKey)) {
            value.deserializeNBT(parentData.func_74775_l(dataKey));
        }
    }

    default public void syncDataElementTo(String dataKey, CompoundNBT parentData, ItemStackHandler value) {
        parentData.func_218657_a(dataKey, (INBT)value.serializeNBT());
    }

    default public void syncDataElementFrom(String dataKey, CompoundNBT parentData, ItemStackHolder value) {
        if (parentData.func_74764_b(dataKey)) {
            value.deserializeNBT(parentData.func_74775_l(dataKey));
        }
    }

    default public void syncDataElementTo(String dataKey, CompoundNBT parentData, ItemStackHolder value) {
        parentData.func_218657_a(dataKey, (INBT)value.serializeNBT());
    }

    default public void syncBooleanElementFrom(String dataKey, CompoundNBT parentData, BooleanConsumer consumer) {
        if (parentData.func_74764_b(dataKey)) {
            consumer.accept(parentData.func_74767_n(dataKey));
        }
    }

    default public void syncBooleanElementTo(String dataKey, CompoundNBT parentData, boolean value) {
        parentData.func_74757_a(dataKey, value);
    }

    public static enum SyncReason {
        FullSync,
        NetworkUpdate;


        public boolean isFullSync() {
            return this == FullSync;
        }

        public boolean isNetworkUpdate() {
            return this == NetworkUpdate;
        }
    }
}

