/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.stack;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import net.minecraft.nbt.CompoundNBT;

public interface IStackAdapter<StackType, ContentType> {
    public Optional<ContentType> getContent(StackType var1);

    public int getAmount(StackType var1);

    public StackType setAmount(StackType var1, int var2);

    public StackType modifyAmount(StackType var1, int var2);

    public StackType getEmptyStack();

    public boolean isEmpty(StackType var1);

    public boolean isStackContentEqual(StackType var1, StackType var2);

    public boolean isContentEqual(ContentType var1, ContentType var2);

    public boolean areIdentical(StackType var1, StackType var2);

    public StackType create(ContentType var1, int var2);

    public StackType create(StackType var1);

    public StackType[] createArray(int var1);

    public List<StackType> createList();

    public Set<StackType> createSet();

    public StackType readFrom(CompoundNBT var1);

    public CompoundNBT writeTo(StackType var1, CompoundNBT var2);

    public String toString(StackType var1);

    public <T> T map(StackType var1, Function<ContentType, T> var2, T var3);

    public <T> T map(StackType var1, IntFunction<T> var2, T var3);

    public <T> T map(StackType var1, BiFunction<ContentType, Integer, T> var2, T var3);

    public void accept(StackType var1, Consumer<ContentType> var2);

    public void accept(StackType var1, IntConsumer var2);

    public void accept(StackType var1, BiConsumer<ContentType, Integer> var2);
}

