/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider;

import it.zerono.mods.zerocore.lib.datagen.LootTableType;
import it.zerono.mods.zerocore.lib.datagen.provider.BaseLootTableProvider;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.loot.AlternativesLootEntry;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.MatchTool;
import net.minecraft.loot.conditions.SurvivesExplosion;
import net.minecraft.loot.functions.ApplyBonus;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class BaseBlockLootTableProvider
extends BaseLootTableProvider {
    protected BaseBlockLootTableProvider(DataGenerator dataGenerator) {
        super(LootTableType.Block, dataGenerator);
    }

    protected void addDrop(Supplier<? extends Block> block) {
        this.addDrop(block, block, 1);
    }

    @SafeVarargs
    protected final void addDrop(Supplier<? extends Block> ... blocks) {
        for (Supplier<? extends Block> block : blocks) {
            this.addDrop(block, block, 1);
        }
    }

    protected void addDrop(Supplier<? extends Block> block, Supplier<? extends IItemProvider> drop, int count) {
        this.addDrop(block.get(), (LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)drop.get()).func_212840_b_(SurvivesExplosion.func_215968_b())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)count))));
    }

    protected void addSilkDrop(Supplier<? extends Block> block, Supplier<? extends IItemProvider> standardDrop, int count, Supplier<? extends IItemProvider> silkDrop) {
        this.addDrop(block.get(), (LootEntry.Builder<?>)AlternativesLootEntry.func_216149_a((LootEntry.Builder[])new LootEntry.Builder[]{ItemLootEntry.func_216168_a((IItemProvider)silkDrop.get()).func_212840_b_(MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1))))), ((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)standardDrop.get()).func_212840_b_(SurvivesExplosion.func_215968_b())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)count)))}));
    }

    protected void addDrop(Supplier<? extends Block> block, Supplier<? extends IItemProvider> drop, int min, int max) {
        this.addDrop(block.get(), (LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)drop.get()).func_212840_b_(SurvivesExplosion.func_215968_b())).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215865_a((Enchantment)Enchantments.field_185308_t, (int)1)).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)min, (float)max))));
    }

    protected void addSilkDrop(Supplier<? extends Block> block, Supplier<? extends IItemProvider> standardDrop, int min, int max, Supplier<? extends IItemProvider> silkDrop) {
        this.addDrop(block.get(), (LootEntry.Builder<?>)AlternativesLootEntry.func_216149_a((LootEntry.Builder[])new LootEntry.Builder[]{ItemLootEntry.func_216168_a((IItemProvider)silkDrop.get()).func_212840_b_(MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1))))), ((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)standardDrop.get()).func_212840_b_(SurvivesExplosion.func_215968_b())).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215865_a((Enchantment)Enchantments.field_185308_t, (int)1)).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange((float)min, (float)max)))}));
    }

    private void addDrop(Block block, LootEntry.Builder<?> entry) {
        ResourceLocation id = Objects.requireNonNull(block.getRegistryName());
        this.add(id, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name(id.func_110623_a()).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(entry)));
    }
}

