/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.recipe;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.AndCondition;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.OrCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.minecraftforge.common.util.NonNullFunction;

public abstract class BaseRecipeProvider
extends RecipeProvider {
    protected BaseRecipeProvider(DataGenerator generator) {
        super(generator);
    }

    protected void blastingAndSmelting(Consumer<IFinishedRecipe> consumer, String name, NonNullFunction<String, ResourceLocation> nameToIdConverter, Supplier<? extends IItemProvider> result, Supplier<? extends IItemProvider> source) {
        this.blastingAndSmelting(consumer, name, nameToIdConverter, result, source, 1.0f, 200);
    }

    protected void blastingAndSmelting(Consumer<IFinishedRecipe> consumer, String name, NonNullFunction<String, ResourceLocation> nameToIdConverter, Supplier<? extends IItemProvider> result, Supplier<? extends IItemProvider> source, float xp, int smeltingTime) {
        this.blasting(consumer, name, nameToIdConverter, result, source, xp, smeltingTime / 2);
        this.smelting(consumer, name, nameToIdConverter, result, source, xp, smeltingTime);
    }

    protected void blasting(Consumer<IFinishedRecipe> consumer, String name, NonNullFunction<String, ResourceLocation> nameToIdConverter, Supplier<? extends IItemProvider> result, Supplier<? extends IItemProvider> source) {
        this.blasting(consumer, name, nameToIdConverter, result, source, 1.0f, 100);
    }

    protected void blasting(Consumer<IFinishedRecipe> consumer, String name, NonNullFunction<String, ResourceLocation> nameToIdConverter, Supplier<? extends IItemProvider> result, Supplier<? extends IItemProvider> source, ICondition ... conditions) {
        this.blasting(consumer, name, nameToIdConverter, result, source, 1.0f, 100, conditions);
    }

    protected void blasting(Consumer<IFinishedRecipe> consumer, String name, NonNullFunction<String, ResourceLocation> nameToIdConverter, Supplier<? extends IItemProvider> result, Supplier<? extends IItemProvider> source, float xp, int time) {
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{source.get()}), (IItemProvider)result.get(), (float)xp, (int)time).func_218628_a("has_item", (ICriterionInstance)BaseRecipeProvider.func_200403_a((IItemProvider)source.get())).func_218635_a(consumer, (ResourceLocation)nameToIdConverter.apply((Object)("blasting/" + name)));
    }

    protected void blasting(Consumer<IFinishedRecipe> consumer, String name, NonNullFunction<String, ResourceLocation> nameToIdConverter, Supplier<? extends IItemProvider> result, Supplier<? extends IItemProvider> source, float xp, int time, ICondition ... conditions) {
        BaseRecipeProvider.conditionalBuilder(conditions).addRecipe(arg_0 -> ((CookingRecipeBuilder)CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{source.get()}), (IItemProvider)result.get(), (float)xp, (int)time).func_218628_a("has_item", (ICriterionInstance)BaseRecipeProvider.func_200403_a((IItemProvider)source.get()))).func_218630_a(arg_0)).build(consumer, (ResourceLocation)nameToIdConverter.apply((Object)("blasting/" + name)));
    }

    protected void smelting(Consumer<IFinishedRecipe> consumer, String name, NonNullFunction<String, ResourceLocation> nameToIdConverter, Supplier<? extends IItemProvider> result, Supplier<? extends IItemProvider> source) {
        this.smelting(consumer, name, nameToIdConverter, result, source, 1.0f, 200);
    }

    protected void smelting(Consumer<IFinishedRecipe> consumer, String name, NonNullFunction<String, ResourceLocation> nameToIdConverter, Supplier<? extends IItemProvider> result, Supplier<? extends IItemProvider> source, ICondition ... conditions) {
        this.smelting(consumer, name, nameToIdConverter, result, source, 1.0f, 200, conditions);
    }

    protected void smelting(Consumer<IFinishedRecipe> consumer, String name, NonNullFunction<String, ResourceLocation> nameToIdConverter, Supplier<? extends IItemProvider> result, Supplier<? extends IItemProvider> source, float xp, int time) {
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{source.get()}), (IItemProvider)result.get(), (float)xp, (int)time).func_218628_a("has_item", (ICriterionInstance)BaseRecipeProvider.func_200403_a((IItemProvider)source.get())).func_218635_a(consumer, (ResourceLocation)nameToIdConverter.apply((Object)("smelting/" + name)));
    }

    protected void smelting(Consumer<IFinishedRecipe> consumer, String name, NonNullFunction<String, ResourceLocation> nameToIdConverter, Supplier<? extends IItemProvider> result, Supplier<? extends IItemProvider> source, float xp, int time, ICondition ... conditions) {
        BaseRecipeProvider.conditionalBuilder(conditions).addRecipe(arg_0 -> ((CookingRecipeBuilder)CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{source.get()}), (IItemProvider)result.get(), (float)xp, (int)time).func_218628_a("has_item", (ICriterionInstance)BaseRecipeProvider.func_200403_a((IItemProvider)source.get()))).func_218630_a(arg_0)).build(consumer, (ResourceLocation)nameToIdConverter.apply((Object)("smelting/" + name)));
    }

    protected void storageBlock3x3(Consumer<IFinishedRecipe> consumer, String name, NonNullFunction<String, ResourceLocation> nameToIdConverter, String group, Supplier<? extends IItemProvider> component, Supplier<? extends IItemProvider> storage) {
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)storage.get()).func_200491_b(component.get(), 9).func_200490_a(group).func_200483_a(name + "_has_storage", (ICriterionInstance)BaseRecipeProvider.func_200403_a((IItemProvider)component.get())).func_200485_a(consumer, (ResourceLocation)nameToIdConverter.apply((Object)(name + "_component_to_storage")));
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)component.get(), (int)9).func_200487_b(storage.get()).func_200490_a(group).func_200483_a("has_item", (ICriterionInstance)BaseRecipeProvider.func_200403_a((IItemProvider)storage.get())).func_200485_a(consumer, (ResourceLocation)nameToIdConverter.apply((Object)("crafting/" + name + "_storage_to_component")));
    }

    protected void storageBlock2x2(Consumer<IFinishedRecipe> consumer, String name, NonNullFunction<String, ResourceLocation> nameToIdConverter, String group, Supplier<? extends IItemProvider> component, Supplier<? extends IItemProvider> storage) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)storage.get()).func_200462_a(Character.valueOf('X'), component.get()).func_200472_a("XX").func_200472_a("XX").func_200473_b(group).func_200465_a(name + "_has_storage", (ICriterionInstance)BaseRecipeProvider.func_200403_a((IItemProvider)component.get())).func_200467_a(consumer, (ResourceLocation)nameToIdConverter.apply((Object)(name + "_component_to_storage2x2")));
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)component.get(), (int)4).func_200487_b(storage.get()).func_200490_a(group).func_200483_a("has_item", (ICriterionInstance)BaseRecipeProvider.func_200403_a((IItemProvider)storage.get())).func_200485_a(consumer, (ResourceLocation)nameToIdConverter.apply((Object)("crafting/" + name + "_storage2x2_to_component")));
    }

    protected static void recipeWithAlternativeTag(Consumer<IFinishedRecipe> c, ResourceLocation name, @Nullable ResourceLocation alternativeName, ITag.INamedTag<Item> tag, @Nullable ITag.INamedTag<Item> alternativeTag, Function<ITag.INamedTag<Item>, ShapedRecipeBuilder> recipe) {
        if (null == alternativeTag || null == alternativeName) {
            recipe.apply(tag).func_200467_a(c, name);
        } else {
            BaseRecipeProvider.conditionalBuilder(BaseRecipeProvider.not((ICondition)new TagEmptyCondition(tag.func_230234_a_()))).addRecipe(arg_0 -> ((ShapedRecipeBuilder)recipe.apply(tag)).func_200464_a(arg_0)).build(c, name);
            BaseRecipeProvider.conditionalBuilder(new ICondition[]{new TagEmptyCondition(tag.func_230234_a_())}).addRecipe(arg_0 -> ((ShapedRecipeBuilder)recipe.apply(alternativeTag)).func_200464_a(arg_0)).build(c, alternativeName);
        }
    }

    protected static ICondition not(ICondition condition) {
        return new NotCondition(condition);
    }

    protected static ICondition and(ICondition ... conditions) {
        return new AndCondition(conditions);
    }

    protected static ICondition or(ICondition ... conditions) {
        return new OrCondition(conditions);
    }

    protected static ICondition modLoaded(String modId) {
        return new ModLoadedCondition(modId);
    }

    protected static ConditionalRecipe.Builder conditionalBuilder(ICondition ... conditions) {
        if (0 == conditions.length) {
            throw new IllegalArgumentException("No conditions were provided");
        }
        ConditionalRecipe.Builder builder = ConditionalRecipe.builder();
        for (ICondition condition : conditions) {
            builder.addCondition(condition);
        }
        return builder;
    }
}

