/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.fluid.handler;

import it.zerono.mods.zerocore.lib.fluid.handler.FluidHandlerForwarder;
import java.util.function.Predicate;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public final class FluidHandlerPolicyWrapper {
    public static IFluidHandler twoWay(IFluidHandler original, Predicate<FluidStack> inputValidator) {
        return new InputWrapper(original, inputValidator);
    }

    public static IFluidHandler inputOnly(IFluidHandler original, Predicate<FluidStack> inputValidator) {
        return new InputWrapper(original, (Predicate)inputValidator){

            @Override
            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                return FluidStack.EMPTY;
            }

            @Override
            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                return FluidStack.EMPTY;
            }
        };
    }

    public static IFluidHandler outputOnly(IFluidHandler original) {
        return new FluidHandlerForwarder(original){

            @Override
            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                return 0;
            }

            @Override
            public boolean isFluidValid(int tank, FluidStack stack) {
                return false;
            }
        };
    }

    private FluidHandlerPolicyWrapper() {
    }

    private static class InputWrapper
    extends FluidHandlerForwarder {
        private final Predicate<FluidStack> _inputValidator;

        public InputWrapper(IFluidHandler handler, Predicate<FluidStack> inputValidator) {
            super(handler);
            this._inputValidator = inputValidator;
        }

        @Override
        public int fill(FluidStack stack, IFluidHandler.FluidAction action) {
            return this._inputValidator.test(stack) ? super.fill(stack, action) : 0;
        }

        @Override
        public boolean isFluidValid(int tank, FluidStack stack) {
            return this._inputValidator.test(stack);
        }
    }
}

