/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.fluid.handler;

import it.zerono.mods.zerocore.lib.data.stack.AllowedHandlerAction;
import it.zerono.mods.zerocore.lib.data.stack.IndexedStackContainer;
import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class IndexedFluidHandlerForwarder<Index extends Enum<Index>>
implements IFluidHandler {
    private final IndexedStackContainer<Index, Fluid, FluidStack> _container;
    private final Index _index;
    private final AllowedHandlerAction _allowedActions;

    public IndexedFluidHandlerForwarder(IndexedStackContainer<Index, Fluid, FluidStack> container, Index index) {
        this(container, index, AllowedHandlerAction.InsertExtract);
    }

    public IndexedFluidHandlerForwarder(IndexedStackContainer<Index, Fluid, FluidStack> container, Index index, AllowedHandlerAction allowedAction) {
        this._container = container;
        this._index = index;
        this._allowedActions = allowedAction;
    }

    public IndexedStackContainer<Index, Fluid, FluidStack> getContainer() {
        return this._container;
    }

    public Index getIndex() {
        return this._index;
    }

    public AllowedHandlerAction getAllowedActions() {
        return this._allowedActions;
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.getContainer().getStackCopy(this.getIndex());
    }

    public int getTankCapacity(int tank) {
        return this.getContainer().getCapacity();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.getContainer().isStackValidForIndex(this.getIndex(), stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.getAllowedActions().canInsert()) {
            return this.getContainer().insert(this.getIndex(), resource, OperationMode.from(action));
        }
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.getAllowedActions().canExtract()) {
            return this.getContainer().extract(this.getIndex(), resource, OperationMode.from(action));
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.getAllowedActions().canExtract()) {
            return this.getContainer().extract(this.getIndex(), maxDrain, OperationMode.from(action));
        }
        return FluidStack.EMPTY;
    }
}

