/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.util.NonNullConsumer;

public class BooleanData
implements IContainerData {
    private final BooleanSupplier _getter;
    private final BooleanConsumer _setter;
    private boolean _lastValue;

    public BooleanData(BooleanSupplier getter, BooleanConsumer setter) {
        this._getter = getter;
        this._setter = setter;
        this._lastValue = false;
    }

    public static BooleanData wrap(boolean[] array, int index) {
        return new BooleanData(() -> array[index], v -> {
            array[index] = v;
        });
    }

    @Override
    @Nullable
    public NonNullConsumer<PacketBuffer> getContainerDataWriter() {
        boolean current = this._getter.getAsBoolean();
        if (this._lastValue != current) {
            this._lastValue = current;
            return buffer -> buffer.writeBoolean(this._getter.getAsBoolean());
        }
        return null;
    }

    @Override
    public void readContainerData(PacketBuffer dataSource) {
        this._setter.accept(dataSource.readBoolean());
    }
}

