/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.multiblock.rectangular;

import it.zerono.mods.zerocore.lib.multiblock.AbstractMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.rectangular.AbstractRectangularMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.rectangular.PartPosition;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.multiblock.validation.ValidationError;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class AbstractRectangularMultiblockController<Controller extends AbstractRectangularMultiblockController<Controller>>
extends AbstractMultiblockController<Controller> {
    protected boolean containPosition(BlockPos position) {
        return this.mapBoundingBoxCoordinates((minPos, maxPos) -> minPos.compareTo((Vector3i)position) < 0 && maxPos.compareTo((Vector3i)position) > 0, false);
    }

    @Override
    protected boolean isMachineWhole(IMultiblockValidator validatorCallback) {
        int partsCount = this.getPartsCount();
        if (partsCount < this.getMinimumNumberOfPartsForAssembledMachine() || this.getBoundingBox().isEmpty()) {
            validatorCallback.setLastError(ValidationError.VALIDATION_ERROR_TOO_FEW_PARTS);
            return false;
        }
        return this.mapBoundingBoxCoordinates((min, max) -> this.isMachineWhole(validatorCallback, partsCount, (BlockPos)min, (BlockPos)max), false);
    }

    private boolean isMachineWhole(IMultiblockValidator validatorCallback, int partsCount, BlockPos minimumCoord, BlockPos maximumCoord) {
        BiFunction<Integer, Integer, BlockPos> positionFactory;
        int vMax;
        int vMin;
        int uMax;
        int uMin;
        int perimeter;
        BlockPos translation = maximumCoord.func_177973_b((Vector3i)minimumCoord);
        Direction.Axis sizeOneAxis = AbstractRectangularMultiblockController.getZeroAxis((Vector3i)translation);
        if (null == sizeOneAxis) {
            validatorCallback.setLastError("ONLY ONE AXIS CAN BE 1!!!", new Object[0]);
            return false;
        }
        int xLength = translation.func_177958_n() + 1;
        int yLength = translation.func_177956_o() + 1;
        int zLength = translation.func_177952_p() + 1;
        if (AbstractRectangularMultiblockController.isSizeWrong(validatorCallback, Direction.Axis.X, this.getMinimumXSize(), this.getMaximumXSize(), xLength) || AbstractRectangularMultiblockController.isSizeWrong(validatorCallback, Direction.Axis.Y, this.getMinimumYSize(), this.getMaximumYSize(), yLength) || AbstractRectangularMultiblockController.isSizeWrong(validatorCallback, Direction.Axis.Z, this.getMinimumZSize(), this.getMaximumZSize(), zLength)) {
            return false;
        }
        switch (sizeOneAxis) {
            case X: {
                perimeter = 2 * (yLength + zLength - 2);
                uMin = minimumCoord.func_177952_p();
                uMax = maximumCoord.func_177952_p();
                vMin = minimumCoord.func_177956_o();
                vMax = maximumCoord.func_177956_o();
                positionFactory = (u, v) -> new BlockPos(minimumCoord.func_177958_n(), v.intValue(), u.intValue());
                break;
            }
            case Y: {
                perimeter = 2 * (xLength + zLength - 2);
                uMin = minimumCoord.func_177958_n();
                uMax = maximumCoord.func_177958_n();
                vMin = minimumCoord.func_177952_p();
                vMax = maximumCoord.func_177952_p();
                positionFactory = (u, v) -> new BlockPos(u.intValue(), minimumCoord.func_177956_o(), v.intValue());
                break;
            }
            case Z: {
                perimeter = 2 * (xLength + yLength - 2);
                uMin = minimumCoord.func_177958_n();
                uMax = maximumCoord.func_177958_n();
                vMin = minimumCoord.func_177956_o();
                vMax = maximumCoord.func_177956_o();
                positionFactory = (u, v) -> new BlockPos(u.intValue(), v.intValue(), minimumCoord.func_177952_p());
                break;
            }
            default: {
                throw new IllegalStateException("Illegal fourth axis");
            }
        }
        if (perimeter != partsCount) {
            validatorCallback.setLastError("the number of blocks does not match the number of required parts!!!", new Object[0]);
            return false;
        }
        for (int u2 = uMin; u2 <= uMax; ++u2) {
            if (this.validateBlock(positionFactory.apply(u2, vMin), validatorCallback) && this.validateBlock(positionFactory.apply(u2, vMax), validatorCallback)) continue;
            return false;
        }
        for (int v2 = vMin + 1; v2 <= vMax - 1; ++v2) {
            if (this.validateBlock(positionFactory.apply(uMin, v2), validatorCallback) && this.validateBlock(positionFactory.apply(uMax, v2), validatorCallback)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void forceStructureUpdate(World world) {
        this.forBoundingBoxCoordinates((min, max) -> AbstractRectangularMultiblockController.forceStructureUpdate(world, min, max));
    }

    protected AbstractRectangularMultiblockController(World world) {
        super(world);
    }

    @Nullable
    private static Direction.Axis getZeroAxis(Vector3i vector) {
        boolean z;
        boolean y;
        boolean x = 0 == vector.func_177958_n();
        int count = (x ? 1 : 0) + ((y = 0 == vector.func_177956_o()) ? 1 : 0) + ((z = 0 == vector.func_177952_p()) ? 1 : 0);
        if (1 != count) {
            return null;
        }
        return x ? Direction.Axis.X : (y ? Direction.Axis.Y : Direction.Axis.Z);
    }

    private boolean validateBlock(BlockPos blockPosition, IMultiblockValidator validatorCallback) {
        TileEntity te = WorldHelper.getLoadedTile((IWorldReader)this.getWorld(), blockPosition);
        AbstractRectangularMultiblockPart part = te instanceof AbstractRectangularMultiblockPart ? (AbstractRectangularMultiblockPart)te : null;
        return null != part ? this.validatePart(part, blockPosition, validatorCallback) : this.validateGenericBlock(blockPosition, validatorCallback);
    }

    private boolean validatePart(AbstractRectangularMultiblockPart<Controller> part, BlockPos blockPosition, IMultiblockValidator validatorCallback) {
        if (!part.getMultiblockController().map(this::isControllerCompatible).orElse(false).booleanValue()) {
            validatorCallback.setLastError(blockPosition, "zerocore:api.multiblock.validation.invalid_part", new Object[0]);
            return false;
        }
        if (!this.containsPart(part)) {
            validatorCallback.setLastError(blockPosition, "zerocore:api.multiblock.validation.invalid_foreign_part", new Object[0]);
            return false;
        }
        PartPosition position = PartPosition.positionIn((AbstractRectangularMultiblockController)this.castSelf(), blockPosition);
        if (!part.isGoodForPosition(position, validatorCallback)) {
            if (!validatorCallback.hasLastError()) {
                validatorCallback.setLastError(blockPosition, "zerocore:api.multiblock.validation.invalid_part_for_frame", new Object[0]);
            }
            return false;
        }
        return true;
    }

    private boolean validateGenericBlock(BlockPos blockPosition, IMultiblockValidator validatorCallback) {
        if (!this.isBlockGoodForFrame(this.getWorld(), blockPosition.func_177958_n(), blockPosition.func_177956_o(), blockPosition.func_177952_p(), validatorCallback)) {
            if (!validatorCallback.hasLastError()) {
                validatorCallback.setLastError(blockPosition, "zerocore:api.multiblock.validation.invalid_part_for_frame", new Object[0]);
            }
            return false;
        }
        return true;
    }

    private static boolean isValueNot(int value, int min, int max) {
        return value != min && value != max;
    }

    private static boolean isOnCorner(int a, int b, int aTarget, int bTarget) {
        return a == aTarget && b == bTarget;
    }

    private static boolean isOnCorner(int a, int b, int minA, int minB, int maxA, int maxB) {
        return AbstractRectangularMultiblockController.isOnCorner(a, b, minA, minB) || AbstractRectangularMultiblockController.isOnCorner(a, b, minA, maxB) || AbstractRectangularMultiblockController.isOnCorner(a, b, maxA, maxB) || AbstractRectangularMultiblockController.isOnCorner(a, b, maxA, minB);
    }

    private static boolean isOnCornerX(BlockPos pos, BlockPos minPos, BlockPos maxPos) {
        return AbstractRectangularMultiblockController.isOnCorner(pos.func_177956_o(), pos.func_177952_p(), minPos.func_177956_o(), minPos.func_177952_p(), maxPos.func_177956_o(), maxPos.func_177952_p());
    }

    private static boolean isOnCornerY(BlockPos pos, BlockPos minPos, BlockPos maxPos) {
        return AbstractRectangularMultiblockController.isOnCorner(pos.func_177958_n(), pos.func_177952_p(), minPos.func_177958_n(), minPos.func_177952_p(), maxPos.func_177958_n(), maxPos.func_177952_p());
    }

    private static boolean isOnCornerZ(BlockPos pos, BlockPos minPos, BlockPos maxPos) {
        return AbstractRectangularMultiblockController.isOnCorner(pos.func_177958_n(), pos.func_177956_o(), minPos.func_177958_n(), minPos.func_177956_o(), maxPos.func_177958_n(), maxPos.func_177956_o());
    }

    private static boolean isSizeWrong(IMultiblockValidator validatorCallback, Direction.Axis axis, int minSize, int maxSize, int size) {
        if (maxSize > 0 && size > maxSize) {
            validatorCallback.setLastError("zerocore:api.multiblock.validation.machine_too_large", maxSize, axis.func_176610_l());
            return true;
        }
        if (size < minSize) {
            validatorCallback.setLastError("zerocore:api.multiblock.validation.machine_too_small", minSize, axis.func_176610_l());
            return true;
        }
        return false;
    }

    @Nullable
    private AbstractRectangularMultiblockPart<Controller> getPartFromWorld(BlockPos position) {
        TileEntity te = WorldHelper.getLoadedTile((IWorldReader)this.getWorld(), position);
        return te instanceof AbstractRectangularMultiblockPart ? (AbstractRectangularMultiblockPart)te : null;
    }

    private static void forceStructureUpdate(World world, BlockPos minCoord, BlockPos maxCoord) {
        int minX = minCoord.func_177958_n();
        int minY = minCoord.func_177956_o();
        int minZ = minCoord.func_177952_p();
        int maxX = maxCoord.func_177958_n();
        int maxY = maxCoord.func_177956_o();
        int maxZ = maxCoord.func_177952_p();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = world.func_180495_p(pos);
                    world.func_184138_a(pos, state, state, 3);
                }
            }
        }
    }
}

