/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.multiblock.registry;

import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.storage.IPartStorage;
import it.zerono.mods.zerocore.lib.multiblock.storage.PartStorage;
import it.zerono.mods.zerocore.lib.world.NeighboringPositions;
import java.util.Collections;
import java.util.Set;
import java.util.function.BooleanSupplier;
import net.minecraft.profiler.IProfiler;
import net.minecraft.world.World;

final class MultiblockWorldRegistry<Controller extends IMultiblockController<Controller>> {
    private World _world;
    private final Set<Controller> _controllers;
    private final Set<Controller> _dirtyControllers;
    private final Set<Controller> _deadControllers;
    private IPartStorage<Controller> _orphanedParts;
    private IPartStorage<Controller> _detachedParts;
    private final NeighboringPositions _neighborsIterator;
    private final BooleanSupplier _multiblockChangesDelay;

    public Set<Controller> getControllers() {
        return Collections.unmodifiableSet(this._controllers);
    }

    MultiblockWorldRegistry(World world) {
        this._world = world;
        this._controllers = new ReferenceOpenHashSet(64);
        this._deadControllers = new ReferenceOpenHashSet(64);
        this._dirtyControllers = new ReferenceOpenHashSet(64);
        this._orphanedParts = this.createPartStorage();
        this._detachedParts = this.createPartStorage();
        this._neighborsIterator = new NeighboringPositions();
        this._multiblockChangesDelay = CodeHelper.tickCountdown(20);
        if (CodeHelper.isDevEnv()) {
            Log.LOGGER.info(Log.MULTIBLOCK, "MultiblockWorldRegistry created at {}", (Object)System.nanoTime());
        }
    }

    void tickStart() {
        IProfiler profiler = this._world.func_217381_Z();
        profiler.func_76320_a("Zero CORE|Multiblock|World|Tick");
        for (IMultiblockController controller : this._controllers) {
            if (controller.isEmpty()) {
                this._deadControllers.add(controller);
                continue;
            }
            controller.updateMultiblockEntity();
        }
        profiler.func_76319_b();
    }

    void processMultiblockChanges() {
        boolean process = this._multiblockChangesDelay.getAsBoolean();
        if (this._orphanedParts.isEmpty() && this._dirtyControllers.isEmpty() && this._deadControllers.isEmpty() && this._detachedParts.isEmpty() || !process) {
            return;
        }
        IProfiler profiler = this._world.func_217381_Z();
        profiler.func_76320_a("Zero CORE|Multiblock|World|Merge");
        if (!this._orphanedParts.isEmpty()) {
            IPartStorage<Controller> orphansToProcess = this._orphanedParts;
            ReferenceArrayList mergePools = null;
            this._orphanedParts = this.createPartStorage();
            block4: for (IMultiblockPart iMultiblockPart : orphansToProcess) {
                if (iMultiblockPart.isPartInvalid()) continue;
                Set compatibleControllers = iMultiblockPart.attachToNeighbors(this::findControllersFor);
                int compatibleControllersSize = compatibleControllers.size();
                switch (compatibleControllersSize) {
                    case 1: {
                        continue block4;
                    }
                    case 0: {
                        Object newController = iMultiblockPart.createController();
                        newController.attachPart(iMultiblockPart);
                        this._controllers.add(newController);
                        continue block4;
                    }
                }
                if (null == mergePools) {
                    mergePools = new ReferenceArrayList(16);
                    mergePools.add(compatibleControllers);
                    continue;
                }
                if (1 == mergePools.size()) {
                    Set pool = (Set)mergePools.get(0);
                    for (IMultiblockController controller : compatibleControllers) {
                        if (!pool.contains(controller)) continue;
                        pool.addAll(compatibleControllers);
                        continue block4;
                    }
                    mergePools.add(compatibleControllers);
                    continue;
                }
                ReferenceArrayList candidatePools = new ReferenceArrayList(16);
                block6: for (Set pool : mergePools) {
                    for (IMultiblockController controller : compatibleControllers) {
                        if (!pool.contains(controller)) continue;
                        candidatePools.add(pool);
                        continue block6;
                    }
                }
                if (candidatePools.isEmpty()) {
                    mergePools.add(compatibleControllers);
                    continue;
                }
                if (1 == candidatePools.size()) {
                    ((Set)candidatePools.get(0)).addAll(compatibleControllers);
                    continue;
                }
                Set masterPool = (Set)candidatePools.get(0);
                for (int i = 1; i < candidatePools.size(); ++i) {
                    Set consumedPool = (Set)candidatePools.get(i);
                    masterPool.addAll(consumedPool);
                    mergePools.remove(consumedPool);
                }
                masterPool.addAll(compatibleControllers);
            }
            if (null != mergePools && !mergePools.isEmpty()) {
                for (Set set : mergePools) {
                    IMultiblockController newMaster = null;
                    for (IMultiblockController controller : set) {
                        if (null != newMaster && !controller.shouldConsumeController(newMaster)) continue;
                        newMaster = controller;
                    }
                    if (null == newMaster) {
                        Log.LOGGER.error(Log.MULTIBLOCK, "[Multiblock Registry] Checked a merge pool of size {}, found no master candidates. This should never happen.", (Object)set.size());
                        continue;
                    }
                    this._dirtyControllers.add(newMaster);
                    for (IMultiblockController controller : set) {
                        if (controller == newMaster) continue;
                        newMaster.assimilateController(controller);
                        this._deadControllers.add(controller);
                    }
                }
            }
        }
        profiler.func_219895_b("Zero CORE|Multiblock|World|Split&Assembly");
        if (!this._dirtyControllers.isEmpty()) {
            for (IMultiblockController controller : this._dirtyControllers) {
                if (controller.isEmpty()) {
                    this._deadControllers.add(controller);
                    continue;
                }
                IPartStorage newlyDetachedParts = controller.checkForDisconnections();
                if (!controller.isEmpty()) {
                    controller.recalculateCoords();
                    controller.checkIfMachineIsWhole();
                } else {
                    this._deadControllers.add(controller);
                }
                if (newlyDetachedParts.isEmpty()) continue;
                this._detachedParts.addAll(newlyDetachedParts);
            }
            this._dirtyControllers.clear();
        }
        profiler.func_219895_b("Zero CORE|Multiblock|World|DeadControllers");
        if (!this._deadControllers.isEmpty()) {
            for (IMultiblockController controller : this._deadControllers) {
                if (!controller.isEmpty()) {
                    Log.LOGGER.error(Log.MULTIBLOCK, "[Multiblock Registry] Found a non-empty controller. Forcing it to shed its blocks and die. This should never happen!");
                    this._detachedParts.addAll(controller.detachAll());
                }
                this._controllers.remove(controller);
            }
            this._deadControllers.clear();
        }
        profiler.func_219895_b("Zero CORE|Multiblock|World|DetachedParts");
        if (!this._detachedParts.isEmpty()) {
            this._detachedParts.forEach(p -> {
                p.assertDetached();
                this._orphanedParts.addOrReplace((IMultiblockPart<Controller>)p);
            });
            this._detachedParts = this.createPartStorage();
        }
        profiler.func_76319_b();
    }

    void onPartAdded(IMultiblockPart<Controller> part) {
        IProfiler profiler = this._world.func_217381_Z();
        profiler.func_76320_a("Zero CORE|Multiblock|World|PartAdded");
        this._orphanedParts.addOrReplace(part);
        profiler.func_76319_b();
    }

    void onPartRemovedFromWorld(IMultiblockPart<Controller> part) {
        IProfiler profiler = this._world.func_217381_Z();
        profiler.func_76320_a("Zero CORE|Multiblock|World|PartRemoved");
        this._detachedParts.remove(part);
        if (this._orphanedParts.contains(part)) {
            this._orphanedParts.remove(part);
        }
        part.assertDetached();
        profiler.func_76319_b();
    }

    void onWorldUnloaded() {
        IProfiler profiler = this._world.func_217381_Z();
        profiler.func_76320_a("Zero CORE|Multiblock|World|WorldUnloaded");
        this._controllers.clear();
        this._deadControllers.clear();
        this._dirtyControllers.clear();
        this._orphanedParts = null;
        this._detachedParts = null;
        this._world = null;
        profiler.func_76319_b();
    }

    void addDeadController(Controller deadController) {
        this._deadControllers.add(deadController);
    }

    void addDirtyController(Controller dirtyController) {
        this._dirtyControllers.add(dirtyController);
    }

    private Set<Controller> findControllersFor(IMultiblockPart<Controller> orphan) {
        Class<Controller> targetControllerType = orphan.getControllerType();
        ReferenceArraySet controllers = new ReferenceArraySet(6);
        this._neighborsIterator.setTo(orphan.getWorldPosition());
        for (IMultiblockController controller : this._controllers) {
            if (!targetControllerType.equals(controller.getClass()) || !controller.isPartCompatible(orphan) || !controller.containsPartsAt(this._neighborsIterator)) continue;
            controllers.add(controller);
        }
        return controllers;
    }

    private IPartStorage<Controller> createPartStorage() {
        return new PartStorage();
    }
}

