/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.zerono.mods.zerocore.lib.recipe.ISerializableRecipe;
import it.zerono.mods.zerocore.lib.recipe.ModRecipe;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import java.util.function.Predicate;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public abstract class AbstractOneToOneRecipe<Ingredient, Result, RecipeIngredient extends IRecipeIngredient<Ingredient>, RecipeResult extends IRecipeResult<Result>>
extends ModRecipe
implements Predicate<Ingredient>,
ISerializableRecipe {
    private final RecipeIngredient _ingredient;
    private final RecipeResult _result;

    protected AbstractOneToOneRecipe(ResourceLocation id, RecipeIngredient ingredient, RecipeResult result) {
        super(id);
        this._ingredient = ingredient;
        this._result = result;
    }

    public RecipeIngredient getIngredient() {
        return this._ingredient;
    }

    public RecipeResult getResult() {
        return this._result;
    }

    @Override
    public boolean test(Ingredient stack) {
        return this.getIngredient().test(stack);
    }

    public NonNullList<Ingredient> func_192400_c() {
        return AbstractOneToOneRecipe.buildVanillaIngredientsList(this.getIngredient().asVanillaIngredients());
    }

    @Override
    public void serializeTo(PacketBuffer buffer) {
        this._ingredient.serializeTo(buffer);
        this._result.serializeTo(buffer);
    }

    @Override
    public JsonElement serializeTo() {
        JsonObject json = new JsonObject();
        json.add("ingredient", this._ingredient.serializeTo());
        json.add("result", this._result.serializeTo());
        return json;
    }

    @FunctionalInterface
    public static interface IRecipeFactory<Ingredient, Result, RecipeIngredient extends IRecipeIngredient<Ingredient>, RecipeResult extends IRecipeResult<Result>, Recipe extends AbstractOneToOneRecipe<Ingredient, Result, RecipeIngredient, RecipeResult>> {
        public Recipe create(ResourceLocation var1, RecipeIngredient var2, RecipeResult var3);
    }
}

