/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.tag;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.zerono.mods.zerocore.lib.tag.TagSource;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.common.util.NonNullSupplier;

public class TagList<T>
extends TagSource<T> {
    private final List<ResourceLocation> _ids = Lists.newArrayList();
    private final Map<ResourceLocation, ITag<T>> _tags = Maps.newHashMap();

    public TagList(NonNullSupplier<ITagCollection<T>> provider) {
        super(provider);
    }

    @Override
    public Optional<ITag<T>> getTag(ResourceLocation id) {
        return Optional.ofNullable(this._tags.get(id));
    }

    public <R> R mapTag(ResourceLocation id, NonNullFunction<ITag<T>, R> mapper, R defaultValue) {
        ITag<T> tag = this._tags.get(id);
        return (R)(null != tag ? mapper.apply(tag) : defaultValue);
    }

    public void forTag(ResourceLocation id, NonNullConsumer<ITag<T>> consumer) {
        ITag<T> tag = this._tags.get(id);
        if (null != tag) {
            consumer.accept(tag);
        }
    }

    public void addTag(ITag.INamedTag<T> namedTag) {
        this._ids.add(namedTag.func_230234_a_());
        this._tags.put(namedTag.func_230234_a_(), (ITag<T>)namedTag);
    }

    public void removeTag(ResourceLocation id) {
        this._ids.remove(id);
        this._tags.remove(id);
    }

    public void removeTag(ITag.INamedTag<T> tag) {
        this.removeTag(tag.func_230234_a_());
    }

    public void clear() {
        this._ids.clear();
        this._tags.clear();
    }

    public void reloadTags() {
        ITagCollection collection = this.getCollection();
        this._tags.clear();
        for (ResourceLocation id : this._ids) {
            ITag tag = collection.func_199910_a(id);
            if (null == tag) continue;
            this._tags.put(id, tag);
        }
    }

    public boolean contains(ITag.INamedTag<T> tag) {
        return this.contains(tag.func_230234_a_());
    }

    public boolean contains(ResourceLocation id) {
        return this._ids.contains(id);
    }

    public Optional<ITag<T>> find(Predicate<ITag<T>> predicate) {
        return this._tags.values().stream().filter(predicate).findFirst();
    }

    public Stream<ResourceLocation> idStream() {
        return this._ids.stream();
    }

    public Stream<ITag<T>> tagStream() {
        return this._tags.values().stream();
    }
}

