/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.world;

import it.zerono.mods.zerocore.internal.gamecontent.Content;
import it.zerono.mods.zerocore.lib.block.ModBlock;
import it.zerono.mods.zerocore.lib.world.AbstractWorldGenFeaturesMap;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

public class WorldGenManager
extends AbstractWorldGenFeaturesMap<BiomeLoadingEvent> {
    public static final WorldGenManager INSTANCE = new WorldGenManager();

    public static Predicate<BiomeLoadingEvent> matchAll() {
        return id -> true;
    }

    public static Predicate<BiomeLoadingEvent> matchOnly(ResourceLocation biomeId) {
        return event -> event.getName().equals((Object)biomeId);
    }

    public static Predicate<BiomeLoadingEvent> anyExcept(ResourceLocation biomeId) {
        return event -> !event.getName().equals((Object)biomeId);
    }

    public static Predicate<BiomeLoadingEvent> onlyNether() {
        return event -> Biome.Category.NETHER == event.getCategory();
    }

    public static Predicate<BiomeLoadingEvent> exceptNether() {
        return event -> Biome.Category.NETHER != event.getCategory();
    }

    public static Predicate<BiomeLoadingEvent> onlyTheEnd() {
        return event -> Biome.Category.THEEND == event.getCategory();
    }

    public static Predicate<BiomeLoadingEvent> exceptTheEnd() {
        return event -> Biome.Category.THEEND != event.getCategory();
    }

    public static ConfiguredFeature<?, ?> oreFeature(Supplier<ModBlock> oreBlock, RuleTest matchRule, int clustersAmount, int oresPerCluster, int placementBottomOffset, int placementTopOffset, int placementMaximum) {
        return WorldGenManager.oreFeature(Content.FEATURE_ORE, oreBlock, matchRule, clustersAmount, oresPerCluster, placementBottomOffset, placementTopOffset, placementMaximum);
    }

    private WorldGenManager() {
        MinecraftForge.EVENT_BUS.addListener(this::onBiomesLoaded);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBiomesLoaded(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder builder = event.getGeneration();
        for (GenerationStage.Decoration stage : this._entries.keySet()) {
            List biomeFeatures = builder.getFeatures(stage);
            this._entries.getOrDefault(stage, Collections.emptyList()).stream().filter(p -> ((Predicate)p.getKey()).test(event)).forEach(p -> biomeFeatures.add(() -> ((Pair)p).getValue()));
        }
    }
}

