/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.world;

import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

@Deprecated
public abstract class Zone
implements Comparable<Zone> {
    public static Zone rectangular(BlockPos minCoords, BlockPos maxCoords) {
        return new RectangularCuboidZone(minCoords, maxCoords);
    }

    public static Zone sphere(BlockPos center, int radius) {
        return new SphereZone(center, radius);
    }

    public abstract boolean contains(BlockPos var1);

    public abstract AxisAlignedBB getBoundingBox();

    @Override
    public int compareTo(Zone zone) {
        AxisAlignedBB myBB = this.getBoundingBox();
        AxisAlignedBB hisBB = zone.getBoundingBox();
        return 0;
    }

    private static class SphereZone
    extends Zone {
        private final BlockPos _center;
        private final int _radius;

        SphereZone(BlockPos center, int radius) {
            this._center = center;
            this._radius = radius;
        }

        @Override
        public boolean contains(BlockPos position) {
            return (position.func_177958_n() - this._center.func_177958_n()) * (position.func_177958_n() - this._center.func_177958_n()) + (position.func_177956_o() - this._center.func_177956_o()) * (position.func_177956_o() - this._center.func_177956_o()) + (position.func_177952_p() - this._center.func_177952_p()) * (position.func_177952_p() - this._center.func_177952_p()) <= this._radius * this._radius;
        }

        @Override
        public AxisAlignedBB getBoundingBox() {
            int centerX = this._center.func_177958_n();
            int centerY = this._center.func_177956_o();
            int centerZ = this._center.func_177952_p();
            return new AxisAlignedBB((double)(centerX - this._radius), (double)(centerY - this._radius), (double)(centerZ - this._radius), (double)(centerX + this._radius - 1), (double)(centerY + this._radius - 1), (double)(centerZ + this._radius - 1));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SphereZone)) {
                return false;
            }
            SphereZone other = (SphereZone)o;
            return this._radius == other._radius && this._center.equals((Object)other._center);
        }
    }

    private static class RectangularCuboidZone
    extends Zone {
        private final BlockPos _minCoords;
        private final BlockPos _maxCoords;

        RectangularCuboidZone(BlockPos minCoords, BlockPos maxCoords) {
            this._minCoords = minCoords;
            this._maxCoords = maxCoords;
        }

        @Override
        public boolean contains(BlockPos position) {
            return this._minCoords.func_177958_n() <= position.func_177958_n() && position.func_177958_n() <= this._maxCoords.func_177958_n() && this._minCoords.func_177956_o() <= position.func_177956_o() && position.func_177956_o() <= this._maxCoords.func_177956_o() && this._minCoords.func_177952_p() <= position.func_177952_p() && position.func_177952_p() <= this._maxCoords.func_177952_p();
        }

        @Override
        public AxisAlignedBB getBoundingBox() {
            return new AxisAlignedBB(this._minCoords, this._maxCoords);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RectangularCuboidZone)) {
                return false;
            }
            RectangularCuboidZone other = (RectangularCuboidZone)o;
            return this._minCoords.equals((Object)other._minCoords) && this._maxCoords.equals((Object)other._maxCoords);
        }
    }
}

