/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.api;

import com.seibel.lod.core.api.ApiShared;
import com.seibel.lod.core.api.EventApi;
import com.seibel.lod.core.builders.lodBuilding.LodBuilder;
import com.seibel.lod.core.builders.lodBuilding.bufferBuilding.LodBufferBuilderFactory;
import com.seibel.lod.core.enums.config.DistanceGenerationMode;
import com.seibel.lod.core.enums.rendering.RendererType;
import com.seibel.lod.core.handlers.LodDimensionFinder;
import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.logging.ConfigBasedLogger;
import com.seibel.lod.core.logging.ConfigBasedSpamLogger;
import com.seibel.lod.core.logging.SpamReducedLogger;
import com.seibel.lod.core.objects.lod.LodDimension;
import com.seibel.lod.core.objects.math.Mat4f;
import com.seibel.lod.core.render.GLProxy;
import com.seibel.lod.core.render.LodRenderer;
import com.seibel.lod.core.render.RenderSystemTest;
import com.seibel.lod.core.util.DetailDistanceUtil;
import com.seibel.lod.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.lod.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.lod.core.wrapperInterfaces.config.ILodConfigWrapperSingleton;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.lod.core.wrapperInterfaces.world.IWorldWrapper;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;

public class ClientApi {
    public static boolean prefLoggerEnabled = false;
    public static final ClientApi INSTANCE = new ClientApi();
    public static final LodBufferBuilderFactory lodBufferBuilderFactory = new LodBufferBuilderFactory();
    public static LodRenderer renderer = new LodRenderer(lodBufferBuilderFactory);
    public static RenderSystemTest testRenderer = new RenderSystemTest();
    private static final IMinecraftClientWrapper MC = SingletonHandler.get(IMinecraftClientWrapper.class);
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonHandler.get(IMinecraftRenderWrapper.class);
    private static final ILodConfigWrapperSingleton CONFIG = SingletonHandler.get(ILodConfigWrapperSingleton.class);
    private static final IWrapperFactory FACTORY = SingletonHandler.get(IWrapperFactory.class);
    private static final EventApi EVENT_API = EventApi.INSTANCE;
    public static final boolean ENABLE_LAG_SPIKE_LOGGING = false;
    public static final long LAG_SPIKE_THRESOLD_NS = TimeUnit.NANOSECONDS.convert(16L, TimeUnit.MILLISECONDS);
    public static final long SPAM_LOGGER_FLUSH_NS = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS);
    public static LodDimensionFinder DIMENSION_FINDER = new LodDimensionFinder();
    private boolean firstTimeSetupComplete = false;
    private boolean configOverrideReminderPrinted = false;
    public boolean rendererDisabledBecauseOfExceptions = false;
    private final ConcurrentHashMap.KeySetView<Long, Boolean> generating = ConcurrentHashMap.newKeySet();
    public final ConcurrentHashMap.KeySetView<Long, Boolean> toBeLoaded = ConcurrentHashMap.newKeySet();
    private long lastFlush = 0L;

    private ClientApi() {
    }

    public static void logToChat(Level logLevel, String str) {
        String prefix = "[Distant Horizons] ";
        prefix = logLevel == Level.ERROR ? prefix + "\u00a74" : (logLevel == Level.WARN ? prefix + "\u00a76" : (logLevel == Level.INFO ? prefix + "\u00a7f" : (logLevel == Level.DEBUG ? prefix + "\u00a77" : (logLevel == Level.TRACE ? prefix + "\u00a78" : prefix + "\u00a7f"))));
        prefix = prefix + "\u00a7l\u00a7u";
        prefix = prefix + logLevel.name();
        prefix = prefix + ":\u00a7r ";
        if (MC != null) {
            MC.sendChatMessage(prefix + str);
        }
    }

    public void clientChunkLoadEvent(IChunkWrapper chunk, IWorldWrapper world) {
        LagSpikeCatcher clientChunkLoad = new LagSpikeCatcher();
        this.toBeLoaded.add(chunk.getLongChunkPos());
        clientChunkLoad.end("clientChunkLoad");
    }

    public void renderLods(Mat4f mcModelViewMatrix, Mat4f mcProjectionMatrix, float partialTicks) {
        MC.clearFrameObjectCache();
        try {
            IProfilerWrapper profiler;
            boolean doFlush;
            boolean bl = doFlush = System.nanoTime() - this.lastFlush >= SPAM_LOGGER_FLUSH_NS;
            if (doFlush) {
                this.lastFlush = System.nanoTime();
                SpamReducedLogger.flushAll();
            }
            ConfigBasedLogger.updateAll();
            ConfigBasedSpamLogger.updateAll(doFlush);
            if (ApiShared.previousVertQual != CONFIG.client().graphics().quality().getVerticalQuality()) {
                ApiShared.previousVertQual = CONFIG.client().graphics().quality().getVerticalQuality();
                EventApi.INSTANCE.worldUnloadEvent(MC.getWrappedServerWorld());
                EventApi.INSTANCE.worldLoadEvent(MC.getWrappedClientWorld());
                return;
            }
            if (!this.firstTimeSetupComplete) {
                this.firstFrameSetup();
            }
            if (!MC.playerExists() || ApiShared.lodWorld.getIsWorldNotLoaded()) {
                return;
            }
            IWorldWrapper world = MC.getWrappedClientWorld();
            if (world == null) {
                return;
            }
            LodDimension lodDim = ApiShared.lodWorld.getLodDimension(world.getDimensionType());
            DIMENSION_FINDER.updatePlayerData();
            if (lodDim == null) {
                if (DIMENSION_FINDER.isDone()) {
                    lodDim = DIMENSION_FINDER.getAndClearFoundLodDimension();
                    ApiShared.lodWorld.addLodDimension(lodDim);
                } else {
                    DIMENSION_FINDER.AttemptToDetermineSubDimensionAsync(MC.getCurrentDimension());
                    return;
                }
            }
            if (prefLoggerEnabled) {
                lodDim.dumpRamUsage();
                lodBufferBuilderFactory.dumpBufferMemoryUsage();
            }
            LagSpikeCatcher updateToBeLoadedChunk = new LagSpikeCatcher();
            for (long pos : this.toBeLoaded) {
                if (this.generating.size() >= 1) break;
                IChunkWrapper chunk = world.tryGetChunk(FACTORY.createChunkPos(pos));
                if (chunk == null) {
                    this.toBeLoaded.remove(pos);
                    LodBuilder.EVENT_LOGGER.debug("Manual Chunk: {} not ready. Remaining queue: {}", FACTORY.createChunkPos(pos), this.toBeLoaded.size());
                    continue;
                }
                if (!chunk.isLightCorrect() || !chunk.doesNearbyChunksExist()) continue;
                this.toBeLoaded.remove(pos);
                this.generating.add(pos);
                ApiShared.lodBuilder.generateLodNodeAsync(chunk, ApiShared.lodWorld, world.getDimensionType(), DistanceGenerationMode.FULL, true, true, () -> {
                    this.generating.remove(pos);
                    LodBuilder.EVENT_LOGGER.debug("Manual Chunk: {} done. Remaining queue: {}", FACTORY.createChunkPos(pos), this.toBeLoaded.size());
                }, () -> {
                    this.generating.remove(pos);
                    this.toBeLoaded.add(pos);
                    LodBuilder.EVENT_LOGGER.debug("Manual Chunk: {} not ready. Remaining queue: {}", FACTORY.createChunkPos(pos), this.toBeLoaded.size());
                });
            }
            updateToBeLoadedChunk.end("updateToBeLoadedChunk");
            LagSpikeCatcher updateSettings = new LagSpikeCatcher();
            DetailDistanceUtil.updateSettings();
            EVENT_API.viewDistanceChangedEvent();
            updateSettings.end("updateSettings");
            LagSpikeCatcher updatePlayerMove = new LagSpikeCatcher();
            EVENT_API.playerMoveEvent(lodDim);
            updatePlayerMove.end("updatePlayerMove");
            LagSpikeCatcher cutAndExpendAsync = new LagSpikeCatcher();
            lodDim.cutRegionNodesAsync(MC.getPlayerBlockPos().getX(), MC.getPlayerBlockPos().getZ());
            lodDim.expandOrLoadRegionsAsync(MC.getPlayerBlockPos().getX(), MC.getPlayerBlockPos().getZ());
            cutAndExpendAsync.end("cutAndExpendAsync");
            if (CONFIG.client().advanced().debugging().getRendererType() == RendererType.DEFAULT) {
                profiler = MC.getProfiler();
                profiler.pop();
                profiler.push("LOD");
                if (!this.rendererDisabledBecauseOfExceptions) {
                    try {
                        renderer.drawLODs(lodDim, mcModelViewMatrix, mcProjectionMatrix, partialTicks, MC.getProfiler());
                    }
                    catch (RuntimeException e) {
                        this.rendererDisabledBecauseOfExceptions = true;
                        ApiShared.LOGGER.error("Renderer thrown an uncaught exception: ", (Throwable)e);
                        try {
                            MC.sendChatMessage("\u00a74\u00a7l\u00a7uERROR: Distant Horizons renderer has encountered an exception!");
                            MC.sendChatMessage("\u00a74Renderer is now disabled to prevent futher issues.");
                            MC.sendChatMessage("\u00a74Exception detail: " + e.toString());
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                    }
                }
                profiler.pop();
                profiler.push("terrain");
            } else if (CONFIG.client().advanced().debugging().getRendererType() == RendererType.DEBUG) {
                profiler = MC.getProfiler();
                profiler.pop();
                profiler.push("LODTestRendering");
                testRenderer.render();
                profiler.pop();
                profiler.push("terrain");
            }
            ApiShared.previousChunkRenderDistance = MC_RENDER.getRenderDistance();
            ApiShared.previousLodRenderDistance = CONFIG.client().graphics().quality().getLodChunkRenderDistance();
        }
        catch (Exception e) {
            ApiShared.LOGGER.error("client proxy uncaught exception: ", (Throwable)e);
        }
    }

    private void applyConfigOverrides() {
        if (!this.configOverrideReminderPrinted) {
            MC.sendChatMessage("Distant Horizons experimental build 1.6.4a");
            MC.sendChatMessage("You are running an unsupported version of the mod!");
            MC.sendChatMessage("Here be dragons!");
            this.configOverrideReminderPrinted = true;
        }
    }

    public void keyPressedEvent(int glfwKey) {
        if (!CONFIG.client().advanced().debugging().getDebugKeybindingsEnabled()) {
            return;
        }
        if (glfwKey == 297) {
            CONFIG.client().advanced().debugging().setDebugMode(CONFIG.client().advanced().debugging().getDebugMode().getNext());
            MC.sendChatMessage("F8: Set debug mode to " + (Object)((Object)CONFIG.client().advanced().debugging().getDebugMode()));
        }
        if (glfwKey == 295) {
            CONFIG.client().advanced().debugging().setRendererType(RendererType.next(CONFIG.client().advanced().debugging().getRendererType()));
            MC.sendChatMessage("F6: Set rendering to " + (Object)((Object)CONFIG.client().advanced().debugging().getRendererType()));
        }
        if (glfwKey == 80) {
            prefLoggerEnabled = !prefLoggerEnabled;
            MC.sendChatMessage("P: Debug Pref Logger is " + (prefLoggerEnabled ? "enabled" : "disabled"));
        }
    }

    public void firstFrameSetup() {
        GLProxy.getInstance();
        this.firstTimeSetupComplete = true;
    }

    public static class LagSpikeCatcher {
        long timer = System.nanoTime();

        public void end(String source) {
        }
    }
}

