/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.dataFormat;

public class PositionDataFormat {
    public static final byte LOD_COUNT_SHIFT = 6;
    public static final byte CORRECT_LIGHT_SHIFT = 5;
    public static final byte GEN_TYPE_SHIFT = 2;
    public static final byte VOID_SHIFT = 1;
    public static final byte EXISTENCE_SHIFT = 0;
    public static final short LOD_COUNT_MASK = 63;
    public static final short CORRECT_LIGHT_MASK = 1;
    public static final short GEN_TYPE_MASK = 7;
    public static final short VOID_MASK = 1;
    public static final short EXISTENCE_MASK = 1;
    public static final int EMPTY_DATA = 0;
    public static final int VOID_DATA = 4;

    public static short createVoidPositionData(byte generationMode) {
        short positionData = 0;
        positionData = (short)(positionData | (generationMode & 7) << 2);
        positionData = (short)(positionData | 2);
        positionData = (short)(positionData | 1);
        return positionData;
    }

    public static short createPositionData(int lodCount, boolean correctLight, byte generationMode) {
        short positionData = 0;
        positionData = (short)(positionData | (lodCount & 0x3F) << 6);
        positionData = (short)(positionData | (generationMode & 7) << 2);
        if (correctLight) {
            positionData = (short)(positionData | 0x20);
        }
        positionData = (short)(positionData | 1);
        return positionData;
    }

    public static byte getLodCount(short dataPoint) {
        return (byte)(dataPoint >>> 6 & 0x3F);
    }

    public static boolean getFlag(short dataPoint) {
        return (dataPoint >>> 5 & 1) == 1;
    }

    public static byte getGenerationMode(short dataPoint) {
        return (byte)(dataPoint >>> 2 & 7);
    }

    public static boolean isVoid(short dataPoint) {
        return (dataPoint >>> 1 & 1) == 1;
    }

    public static boolean doesItExist(short dataPoint) {
        return (dataPoint >>> 0 & 1) == 1;
    }

    public static short setLodCount(short dataPoint, short lodCount) {
        return (short)(dataPoint | (lodCount & 0x3F) << 6);
    }

    public static short setFlag(short dataPoint) {
        return (short)(dataPoint | 0x20);
    }

    public static short setGenerationMode(short dataPoint, byte generationMode) {
        return (short)(dataPoint | (generationMode & 7) << 2);
    }

    public static short setVoid(short dataPoint) {
        return (short)(dataPoint | 2);
    }

    public static short setExistence(short dataPoint) {
        return (short)(dataPoint | 1);
    }
}

