/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.handlers;

import com.seibel.lod.core.api.ClientApi;
import com.seibel.lod.core.enums.config.DistanceGenerationMode;
import com.seibel.lod.core.enums.config.VerticalQuality;
import com.seibel.lod.core.handlers.LodDimensionOldFileStructureHandler;
import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.logging.ConfigBasedLogger;
import com.seibel.lod.core.logging.SpamReducedLogger;
import com.seibel.lod.core.objects.lod.LevelContainer;
import com.seibel.lod.core.objects.lod.LodDimension;
import com.seibel.lod.core.objects.lod.LodRegion;
import com.seibel.lod.core.objects.lod.RegionPos;
import com.seibel.lod.core.objects.lod.VerticalLevelContainer;
import com.seibel.lod.core.util.LodThreadFactory;
import com.seibel.lod.core.util.UnitBytes;
import com.seibel.lod.core.wrapperInterfaces.config.ILodConfigWrapperSingleton;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import shaded.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import shaded.apache.commons.compress.compressors.xz.XZCompressorOutputStream;

public class LodDimensionFileHandler {
    private static final ILodConfigWrapperSingleton config = SingletonHandler.get(ILodConfigWrapperSingleton.class);
    public static final ConfigBasedLogger LOGGER = new ConfigBasedLogger(LogManager.getLogger(LodDimensionFileHandler.class), () -> config.client().advanced().debugging().debugSwitch().getLogFileReadWriteEvent());
    public static final boolean ENABLE_SAVE_THREAD_LOGGING = true;
    public static final boolean ENABLE_SAVE_REGION_LOGGING = false;
    private final LodDimension lodDimension;
    public final File dimensionDataSaveFolder;
    private static final String FILE_NAME_PREFIX = "lod";
    private static final String FILE_EXTENSION = ".xz";
    private static final String DETAIL_FOLDER_NAME_PREFIX = "detail-";
    public static final String MULTIPLAYER_FOLDER_NAME = "Distant_Horizons_server_data";
    private static final String TMP_FILE_EXTENSION = ".tmp";
    private static final int COMPRESSION_LEVEL = 1;
    public static final int LOD_SAVE_FILE_VERSION = 9;
    private final AtomicBoolean isFileWritingThreadRunning = new AtomicBoolean(false);
    private ExecutorService fileWritingThreadPool = Executors.newSingleThreadExecutor(new LodThreadFactory(this.getClass().getSimpleName(), 6));
    private final ConcurrentHashMap<RegionPos, LodRegion> regionToSave = new ConcurrentHashMap();
    private ReentrantLock mergeOldFileLock = new ReentrantLock();
    private final SpamReducedLogger ramLogger = new SpamReducedLogger(1);

    public LodDimensionFileHandler(File newSaveFolder, LodDimension newLodDimension) {
        if (newSaveFolder == null) {
            throw new IllegalArgumentException("LodDimensionFileHandler requires a valid File location to read and write to.");
        }
        this.dimensionDataSaveFolder = newSaveFolder;
        this.lodDimension = newLodDimension;
        this.checkForOldSaveStructure();
    }

    private void checkForOldSaveStructure() {
        File[] vertQualFiles;
        File file = new File(this.getFileBasePath());
        if (!file.exists()) {
            return;
        }
        for (File vertQualFile : vertQualFiles = file.listFiles()) {
            File[] subFiles;
            if (!vertQualFile.isDirectory() || !vertQualFile.getName().equals(VerticalQuality.HIGH.toString()) && !vertQualFile.getName().equals(VerticalQuality.MEDIUM.toString()) && !vertQualFile.getName().equals(VerticalQuality.LOW.toString())) continue;
            for (File subFile : subFiles = vertQualFile.listFiles()) {
                if (!subFile.isDirectory() || !subFile.getName().equals(DistanceGenerationMode.FULL.toString()) && !subFile.getName().equals(DistanceGenerationMode.FEATURES.toString()) && !subFile.getName().equals(DistanceGenerationMode.SURFACE.toString()) && !subFile.getName().equals(DistanceGenerationMode.BIOME_ONLY_SIMULATE_HEIGHT.toString()) && !subFile.getName().equals(DistanceGenerationMode.BIOME_ONLY.toString()) && !subFile.getName().equals(DistanceGenerationMode.NONE.toString())) continue;
                LOGGER.info("Noticed old save structure files. Starting merge process...", new Object[0]);
                LodDimensionOldFileStructureHandler oldFileStructHandler = new LodDimensionOldFileStructureHandler(this);
                if (this.mergeOldFileLock.tryLock()) {
                    LOGGER.info("Updating VerticalQuality LOW...", new Object[0]);
                    oldFileStructHandler.mergeOldFileStructureForVertQuality(VerticalQuality.LOW);
                    LOGGER.info("Updating VerticalQuality MEDIUM...", new Object[0]);
                    oldFileStructHandler.mergeOldFileStructureForVertQuality(VerticalQuality.MEDIUM);
                    LOGGER.info("Updating VerticalQuality HIGH...", new Object[0]);
                    oldFileStructHandler.mergeOldFileStructureForVertQuality(VerticalQuality.HIGH);
                    LOGGER.info("Update completed.", new Object[0]);
                } else {
                    this.mergeOldFileLock.lock();
                    this.mergeOldFileLock.unlock();
                }
                LOGGER.info("Merge process completed.", new Object[0]);
                return;
            }
        }
    }

    public LodRegion loadRegionFromFile(byte detailLevel, RegionPos regionPos, VerticalQuality verticalQuality) {
        LodRegion region = this.regionToSave.get(regionPos);
        if (region != null && region.getMinDetailLevel() <= detailLevel && region.getVerticalQuality().compareTo(verticalQuality) >= 0) {
            return region;
        }
        region = new LodRegion(10, regionPos, verticalQuality);
        return this.loadRegionFromFile(detailLevel, region, verticalQuality);
    }

    public LodRegion loadRegionFromFile(byte detailLevel, LodRegion region, VerticalQuality verticalQuality) {
        if (region.getVerticalQuality().compareTo(verticalQuality) < 0) {
            this.regionToSave.put(region.getRegionPos(), region);
            region = new LodRegion(10, region.getRegionPos(), verticalQuality);
        }
        int regionX = region.regionPosX;
        int regionZ = region.regionPosZ;
        for (byte tempDetailLevel = (byte)(region.getMinDetailLevel() - 1); tempDetailLevel >= detailLevel; tempDetailLevel = (byte)(tempDetailLevel - 1)) {
            File file = this.getBestMatchingRegionFile(tempDetailLevel, regionX, regionZ, verticalQuality);
            if (file == null) {
                region.addLevelContainer(new VerticalLevelContainer(tempDetailLevel));
                continue;
            }
            long fileSize = file.length();
            if (fileSize == 0L) {
                region.addLevelContainer(new VerticalLevelContainer(tempDetailLevel));
                continue;
            }
            try (FileInputStream fileInStream = new FileInputStream(file);){
                DataInputStream dataStream;
                XZCompressorInputStream inputStream = new XZCompressorInputStream(fileInStream);
                int fileVersion = inputStream.read();
                if (fileVersion < 6) {
                    inputStream.close();
                    file.delete();
                    LOGGER.info("Outdated LOD region file for region: (" + regionX + "," + regionZ + ")[" + tempDetailLevel + "] version found: " + fileVersion + ", version requested: " + 9 + ". File has been deleted.", new Object[0]);
                    region.addLevelContainer(new VerticalLevelContainer(tempDetailLevel));
                    continue;
                }
                if (fileVersion > 9) {
                    inputStream.close();
                    LOGGER.info("Newer LOD region file for region: (" + regionX + "," + regionZ + ")[" + tempDetailLevel + "] version found: " + fileVersion + ", version requested: " + 9 + " this region will not be written to in order to protect the newer file.", new Object[0]);
                    region.addLevelContainer(new VerticalLevelContainer(tempDetailLevel));
                    continue;
                }
                if (fileVersion < 9) {
                    LOGGER.info("Old LOD region file for region: (" + regionX + "," + regionZ + ")[" + tempDetailLevel + "] version found: " + fileVersion + ", version requested: " + 9 + ". File will be loaded and updated to new format in next save.", new Object[0]);
                    dataStream = new DataInputStream(inputStream);
                    region.addLevelContainer(new VerticalLevelContainer(dataStream, fileVersion, tempDetailLevel));
                    dataStream.close();
                    inputStream.close();
                    continue;
                }
                LOGGER.debug("Loading LOD region file for region: (" + regionX + "," + regionZ + ")[" + tempDetailLevel + "]", new Object[0]);
                dataStream = new DataInputStream(inputStream);
                region.addLevelContainer(new VerticalLevelContainer(dataStream, 9, tempDetailLevel));
                dataStream.close();
                inputStream.close();
                continue;
            }
            catch (IOException ioEx) {
                LOGGER.error("LOD file read error. Unable to read xz compressed file [" + file + "]: ", ioEx);
                region.addLevelContainer(new VerticalLevelContainer(tempDetailLevel));
            }
        }
        return region;
    }

    public void saveDirect(int posX, int posZ, VerticalQuality vertQual, VerticalLevelContainer dataContainer) {
        File file = new File(this.getFileBasePath() + (Object)((Object)vertQual) + File.separatorChar + DETAIL_FOLDER_NAME_PREFIX + dataContainer.detailLevel + File.separatorChar + FILE_NAME_PREFIX + "." + posX + "." + posZ + FILE_EXTENSION);
        if (file.exists()) {
            LOGGER.warn("LOD file write warn. Unable to write [" + file + "] because the newer version file already exist! Skipping this position...", new Object[0]);
            return;
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            LOGGER.error("LOD file write error. Unable to create parent directory for [" + file + "]: ", e);
            return;
        }
        try (FileOutputStream fileOutStream = new FileOutputStream(file);){
            XZCompressorOutputStream outputStream = new XZCompressorOutputStream(fileOutStream, 1);
            outputStream.write(9);
            DataOutputStream dataStream = new DataOutputStream(outputStream);
            dataContainer.writeData(dataStream);
            dataStream.close();
            outputStream.close();
        }
        catch (IOException e) {
            LOGGER.error("LOD file write error. Unable to write to temp file [" + file + "]: ", e);
        }
    }

    public void addRegionsToSave(LodRegion r) {
        this.regionToSave.put(r.getRegionPos(), r);
    }

    public void dumpBufferMemoryUsage() {
        if (!this.ramLogger.canMaybeLog()) {
            return;
        }
        ArrayList<LodRegion> regions = new ArrayList<LodRegion>(this.regionToSave.values());
        this.ramLogger.info("Dumping Ram Usage for file writer for {} with {} regions...", this.lodDimension.dimension.getDimensionName(), regions.size());
        int nonNullRegionCount = 0;
        int nonDirtiedRegionCount = 0;
        int writingRegionCount = 0;
        long totalUsage = 0L;
        int[] detailCount = new int[10];
        long[] detailUsage = new long[10];
        for (LodRegion r : regions) {
            LevelContainer[] container;
            if (r == null) continue;
            ++nonNullRegionCount;
            if (!r.needSaving) {
                ++nonDirtiedRegionCount;
            }
            if (r.isWriting.get() != 0) {
                ++writingRegionCount;
            }
            if ((container = (LevelContainer[])r.debugGetDataContainers().clone()) == null || container.length != 10) {
                LOGGER.error("DumpRamUsage encountered an invalid region!", new Object[0]);
                continue;
            }
            for (int i = 0; i < 10; ++i) {
                if (container[i] == null) continue;
                int n = i;
                detailCount[n] = detailCount[n] + 1;
                long byteUsage = container[i].getRoughRamUsage();
                int n2 = i;
                detailUsage[n2] = detailUsage[n2] + byteUsage;
                totalUsage += byteUsage;
            }
        }
        this.ramLogger.info("================================================", new Object[0]);
        this.ramLogger.info("Non Null Regions: [{}], Non-Dirtied Regions: [{}], Writing Regions: [{}], Bytes: [{}]", nonNullRegionCount, nonDirtiedRegionCount, writingRegionCount, new UnitBytes(totalUsage));
        this.ramLogger.info("------------------------------------------------", new Object[0]);
        for (int i = 0; i < 10; ++i) {
            this.ramLogger.info("DETAIL {}: Containers: [{}], Bytes: [{}]", i, detailCount[i], new UnitBytes(detailUsage[i]));
        }
        this.ramLogger.info("================================================", new Object[0]);
        this.ramLogger.incLogTries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDirtyRegionsToFile(boolean blockUntilFinished) {
        for (int i = 0; i < this.lodDimension.getWidth(); ++i) {
            for (int j = 0; j < this.lodDimension.getWidth(); ++j) {
                LodRegion r = this.lodDimension.getRegionByArrayIndex(i, j);
                if (r == null || !r.needSaving) continue;
                this.regionToSave.put(r.getRegionPos(), r);
            }
        }
        ClientApi.DIMENSION_FINDER.saveDimensionPlayerData(this.dimensionDataSaveFolder);
        this.trySaveRegionsToBeSaved();
        if (blockUntilFinished) {
            LOGGER.info("Blocking until lod file save finishes!", new Object[0]);
            try {
                this.fileWritingThreadPool.shutdown();
                boolean worked = this.fileWritingThreadPool.awaitTermination(30L, TimeUnit.SECONDS);
                if (!worked) {
                    LOGGER.error("File writing timed out! File data may not be saved correctly and may cause corruptions!!!", new Object[0]);
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("File writing wait is interrupted! File data may not be saved correctly and may cause corruptions!!!: ", e);
            }
            finally {
                this.fileWritingThreadPool = Executors.newSingleThreadExecutor(new LodThreadFactory(this.getClass().getSimpleName(), 6));
            }
        }
    }

    public void trySaveRegionsToBeSaved() {
        if (this.regionToSave.isEmpty()) {
            return;
        }
        boolean haventStarted = this.isFileWritingThreadRunning.compareAndSet(false, true);
        if (haventStarted) {
            this.fileWritingThreadPool.execute(this::writerMain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writerMain() {
        boolean isStarted = this.isFileWritingThreadRunning.get();
        if (!isStarted) {
            throw new ConcurrentModificationException("WriterMain Triggered but the thead state is not started!?");
        }
        LOGGER.info("Lod File Writer started. To-be-written-regions: " + this.regionToSave.size(), new Object[0]);
        Instant start = Instant.now();
        while (!this.regionToSave.isEmpty()) {
            for (LodRegion r : this.regionToSave.values()) {
                try {
                    if (r.isWriting.getAndIncrement() > 0 || !this.regionToSave.remove(r.getRegionPos(), r)) continue;
                    r.needSaving = false;
                    Instant i = Instant.now();
                    this.saveRegionToFile(r);
                    Instant j = Instant.now();
                    Duration duration = Duration.between(i, j);
                }
                catch (Exception e) {
                    LOGGER.error("Lod: UNCAUGHT exception when saving region " + r.getRegionPos() + ": ", e);
                }
                finally {
                    r.isWriting.decrementAndGet();
                }
            }
        }
        Instant end = Instant.now();
        LOGGER.info("Lod File Writer completed. Took " + Duration.between(start, end), new Object[0]);
        this.isFileWritingThreadRunning.set(false);
    }

    private void saveRegionToFile(LodRegion region) {
        for (byte detailLevel = region.getMinDetailLevel(); detailLevel <= 9; detailLevel = (byte)(detailLevel + 1)) {
            boolean isFileFullyGened;
            File oldFile;
            block24: {
                oldFile = this.getRegionFile(region.regionPosX, region.regionPosZ, detailLevel, region.getVerticalQuality());
                isFileFullyGened = false;
                if (!oldFile.exists()) {
                    if (!oldFile.getParentFile().exists()) {
                        oldFile.getParentFile().mkdirs();
                    }
                    try {
                        oldFile.createNewFile();
                        break block24;
                    }
                    catch (IOException e) {
                        LOGGER.error("LOD file write error. Unable to create parent directory for [" + oldFile + "] error [" + e.getMessage() + "]: ", new Object[0]);
                        e.printStackTrace();
                        continue;
                    }
                }
                int fileVersion = 9;
                try (FileInputStream fileInStream = new FileInputStream(oldFile);){
                    XZCompressorInputStream inputStream = new XZCompressorInputStream(fileInStream);
                    fileVersion = inputStream.read();
                    inputStream.skip(1L);
                    isFileFullyGened = (inputStream.read() & 0x80) != 0;
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.warn("LOD file write warning. Unable to read existing file [" + oldFile + "] version. Treating it as latest version. [" + e.getMessage() + "]: ", new Object[0]);
                    e.printStackTrace();
                }
                if (fileVersion > 9) continue;
            }
            File tempFile = new File(oldFile.getPath() + TMP_FILE_EXTENSION);
            try (FileOutputStream fileOutStream = new FileOutputStream(tempFile);){
                XZCompressorOutputStream outputStream = new XZCompressorOutputStream(fileOutStream, 3);
                outputStream.write(9);
                DataOutputStream dataStream = new DataOutputStream(outputStream);
                boolean isNewDataFullyGened = region.getLevel(detailLevel).writeData(dataStream);
                dataStream.close();
                outputStream.close();
                if (!isNewDataFullyGened && isFileFullyGened) {
                    LOGGER.error("LOD file write error. Attempted to overwrite complete region with incomplete one [" + oldFile + "]", new Object[0]);
                    try {
                        tempFile.delete();
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            catch (IOException e) {
                LOGGER.error("LOD file write error. Unable to write to temp file [" + tempFile + "]: ", e);
                continue;
            }
            try {
                Files.move(tempFile.toPath(), oldFile.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                continue;
            }
            catch (IOException e) {
                LOGGER.error("LOD file write error. Unable to update file [" + oldFile + "]: ", e);
            }
        }
    }

    private String getFileBasePath() throws RuntimeException {
        try {
            return this.dimensionDataSaveFolder.getCanonicalPath() + File.separatorChar;
        }
        catch (IOException e) {
            LOGGER.warn("Unable to get the base save file path. Error: " + e.getMessage(), e);
            throw new RuntimeException("DistantHorizons Get Save File Path Failure");
        }
    }

    private File getRegionFile(int regionX, int regionZ, byte detail, VerticalQuality vertQuality) {
        return new File(this.getFileBasePath() + (Object)((Object)vertQuality) + File.separatorChar + DETAIL_FOLDER_NAME_PREFIX + detail + File.separatorChar + FILE_NAME_PREFIX + "." + regionX + "." + regionZ + FILE_EXTENSION);
    }

    private File getBestMatchingRegionFile(byte detailLevel, int regionX, int regionZ, VerticalQuality targetVertQuality) {
        do {
            File file;
            if (!(file = this.getRegionFile(regionX, regionZ, detailLevel, targetVertQuality)).exists()) continue;
            return file;
        } while ((targetVertQuality = VerticalQuality.next(targetVertQuality)) != null);
        return null;
    }
}

