/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.handlers.dependencyInjection;

import com.seibel.lod.core.handlers.dependencyInjection.IBindable;
import java.util.HashMap;
import java.util.Map;

public class DependencyHandler {
    private final Map<Class<?>, Object> dependencies = new HashMap();
    private boolean bindingFinished = false;

    public void bind(Class<?> depenencyInterface, Object dependencyImplementation) throws IllegalStateException {
        if (this.bindingFinished) {
            throw new IllegalStateException("The dependency [" + depenencyInterface.getSimpleName() + "] cannot be bound, Binding is finished for [" + this.getClass().getSimpleName() + "]. Make sure your bindings are happening before the [bindingFinished] method is being called.");
        }
        if (this.dependencies.containsKey(depenencyInterface)) {
            throw new IllegalStateException("The dependency [" + depenencyInterface.getSimpleName() + "] has already been bound.");
        }
        boolean implementsInterface = this.checkIfClassImplements(dependencyImplementation.getClass(), depenencyInterface);
        boolean implementsBindable = this.checkIfClassImplements(dependencyImplementation.getClass(), IBindable.class);
        if (!implementsInterface) {
            throw new IllegalStateException("The dependency [" + dependencyImplementation.getClass().getSimpleName() + "] doesn't implement the interface [" + depenencyInterface.getSimpleName() + "].");
        }
        if (!implementsBindable) {
            throw new IllegalStateException("The dependency [" + dependencyImplementation.getClass().getSimpleName() + "] doesn't implement the interface [" + IBindable.class.getSimpleName() + "].");
        }
        this.dependencies.put(depenencyInterface, dependencyImplementation);
    }

    private boolean checkIfClassImplements(Class<?> classToTest, Class<?> interfaceToLookFor) {
        if (classToTest.getSuperclass() != Object.class && classToTest.getSuperclass() != null && this.checkIfClassImplements(classToTest.getSuperclass(), interfaceToLookFor)) {
            return true;
        }
        for (Class<?> implementationInterface : classToTest.getInterfaces()) {
            if (implementationInterface.getInterfaces().length != 0 && this.checkIfClassImplements(implementationInterface, interfaceToLookFor)) {
                return true;
            }
            if (!implementationInterface.equals(interfaceToLookFor)) continue;
            return true;
        }
        return false;
    }

    public <T extends IBindable> T get(Class<?> interfaceClass) throws ClassCastException {
        if (!this.bindingFinished) {
            throw new IllegalStateException("Binding hasn't been finished for [" + this.getClass().getSimpleName() + "]. Make sure you are calling the [bindingFinished] method before calling [get].");
        }
        return (T)((IBindable)this.dependencies.get(interfaceClass));
    }

    public void finishBinding() {
        this.bindingFinished = true;
        for (Class<?> interfaceKey : this.dependencies.keySet()) {
            Object concreteObject = this.get(interfaceKey);
            concreteObject.finishDelayedSetup();
        }
    }

    public boolean getBindingFinished() {
        return this.bindingFinished;
    }
}

