/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.objects.lod;

import com.seibel.lod.core.api.ApiShared;
import com.seibel.lod.core.api.ClientApi;
import com.seibel.lod.core.enums.config.DistanceGenerationMode;
import com.seibel.lod.core.enums.config.DropoffQuality;
import com.seibel.lod.core.enums.config.GenerationPriority;
import com.seibel.lod.core.enums.config.VerticalQuality;
import com.seibel.lod.core.handlers.LodDimensionFileHandler;
import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.logging.SpamReducedLogger;
import com.seibel.lod.core.objects.Pos2D;
import com.seibel.lod.core.objects.PosToGenerateContainer;
import com.seibel.lod.core.objects.lod.LevelContainer;
import com.seibel.lod.core.objects.lod.LodRegion;
import com.seibel.lod.core.objects.lod.RegionPos;
import com.seibel.lod.core.util.DetailDistanceUtil;
import com.seibel.lod.core.util.LevelPosUtil;
import com.seibel.lod.core.util.LodThreadFactory;
import com.seibel.lod.core.util.LodUtil;
import com.seibel.lod.core.util.UnitBytes;
import com.seibel.lod.core.util.gridList.MovableGridRingList;
import com.seibel.lod.core.wrapperInterfaces.config.ILodConfigWrapperSingleton;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.lod.core.wrapperInterfaces.world.IDimensionTypeWrapper;
import java.io.File;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class LodDimension {
    private static final ILodConfigWrapperSingleton CONFIG = SingletonHandler.get(ILodConfigWrapperSingleton.class);
    private static final IMinecraftClientWrapper MC = SingletonHandler.get(IMinecraftClientWrapper.class);
    public final IDimensionTypeWrapper dimension;
    private volatile int width;
    private volatile int halfWidth;
    public MovableGridRingList<LodRegion> regions;
    private volatile RegionPos[] iteratorList = null;
    private LodDimensionFileHandler fileHandler = null;
    public volatile int dirtiedRegionsRoughCount = 0;
    private boolean isCutting = false;
    private boolean isExpanding = false;
    private final ExecutorService cutAndExpandThread = Executors.newSingleThreadExecutor(new LodThreadFactory(this.getClass().getSimpleName() + " - Cut and Expand", 4));
    private boolean logEvents = true;
    private int totalDirtiedRegions = 0;
    private boolean expandOrLoadPaused = false;
    private final SpamReducedLogger ramLogger = new SpamReducedLogger(1);

    public boolean isFileHandlerNull() {
        return this.fileHandler == null;
    }

    public LodDimension(IDimensionTypeWrapper newDimension, int newWidth) {
        this(newDimension, newWidth, null, true);
    }

    public LodDimension(IDimensionTypeWrapper newDimension, int newWidth, File saveDir) {
        this(newDimension, newWidth, saveDir, true);
    }

    public LodDimension(IDimensionTypeWrapper newDimension, int newWidth, File saveDir, boolean newLogEvents) {
        this.dimension = newDimension;
        this.width = newWidth;
        this.halfWidth = this.width / 2;
        this.logEvents = newLogEvents;
        if (saveDir != null) {
            this.fileHandler = new LodDimensionFileHandler(saveDir, this);
        }
        this.regions = new MovableGridRingList(this.halfWidth, 0, 0);
        this.generateIteratorList();
    }

    private void generateIteratorList() {
        this.iteratorList = null;
        RegionPos[] list = new RegionPos[this.width * this.width];
        int i = 0;
        for (int ix = -this.halfWidth; ix <= this.halfWidth; ++ix) {
            for (int iz = -this.halfWidth; iz <= this.halfWidth; ++iz) {
                list[i] = new RegionPos(ix, iz);
                ++i;
            }
        }
        Arrays.sort(list, (a, b) -> {
            double disSqrA = a.x * a.x + a.z * a.z;
            double disSqrB = b.x * b.x + b.z * b.z;
            return Double.compare(disSqrA, disSqrB);
        });
        this.iteratorList = list;
    }

    public synchronized void move(RegionPos regionOffset) {
        if (this.logEvents) {
            ApiShared.LOGGER.info("LodDim MOVE. Offset: " + regionOffset);
        }
        this.saveDirtyRegionsToFile(false);
        Pos2D p = this.regions.getCenter();
        this.regions.move(p.x + regionOffset.x, p.y + regionOffset.z);
        if (this.logEvents) {
            ApiShared.LOGGER.info("LodDim MOVE complete. Offset: " + regionOffset);
        }
    }

    public LodRegion getRegion(byte detailLevel, int levelPosX, int levelPosZ) {
        int zRegion;
        int xRegion = LevelPosUtil.getRegion(detailLevel, levelPosX);
        LodRegion region = this.regions.get(xRegion, zRegion = LevelPosUtil.getRegion(detailLevel, levelPosZ));
        if (region != null && region.getMinDetailLevel() > detailLevel) {
            return null;
        }
        return region;
    }

    public LodRegion getRegion(int regionPosX, int regionPosZ) {
        return this.regions.get(regionPosX, regionPosZ);
    }

    @Deprecated
    public LodRegion getRegionByArrayIndex(int xIndex, int zIndex) {
        Pos2D p = this.regions.getMinInRange();
        return this.regions.get(p.x + xIndex, p.y + zIndex);
    }

    public void iterateWithSpiral(PosComsumer r) {
        int dx = 0;
        int oy = 0;
        int ox = 0;
        int dy = -1;
        int len = this.regions.getSize();
        int maxI = len * len;
        int halfLen = len / 2;
        for (int i = 0; i < maxI; ++i) {
            if (-halfLen <= ox && ox <= halfLen && -halfLen <= oy && oy <= halfLen) {
                int x = ox + halfLen;
                int z = oy + halfLen;
                r.run(x, z);
            }
            if (ox == oy || ox < 0 && ox == -oy || ox > 0 && ox == 1 - oy) {
                int temp = dx;
                dx = -dy;
                dy = temp;
            }
            ox += dx;
            oy += dy;
        }
    }

    public void iterateByDistance(PosComsumer r) {
        if (this.iteratorList == null) {
            return;
        }
        for (RegionPos relativePos : this.iteratorList) {
            r.run(relativePos.x + this.halfWidth, relativePos.z + this.halfWidth);
        }
    }

    public void cutRegionNodesAsync(int playerPosX, int playerPosZ) {
        if (this.isCutting) {
            return;
        }
        this.isCutting = true;
        Runnable thread = () -> {
            this.totalDirtiedRegions = 0;
            Pos2D minPos = this.regions.getMinInRange();
            this.iterateWithSpiral((x, z) -> {
                LodRegion region = this.regions.get(x + minPos.x, z + minPos.y);
                if (region != null && region.needSaving) {
                    ++this.totalDirtiedRegions;
                }
                if (region != null && !region.needSaving && region.isWriting.get() == 0) {
                    double minDistance = LevelPosUtil.minDistance((byte)9, x + minPos.x, z + minPos.y, playerPosX, playerPosZ);
                    byte detail = DetailDistanceUtil.getDetailLevelFromDistance(minDistance);
                    if (region.getMinDetailLevel() < detail) {
                        if (region.needSaving) {
                            return;
                        }
                        if (region.isWriting.get() != 0) {
                            return;
                        }
                        region.cutTree(detail);
                        region.needSignalToRegenBuffer = true;
                    }
                }
                if (region != null && region.needSignalToRegenBuffer) {
                    region.needSignalToRegenBuffer = false;
                    ClientApi.lodBufferBuilderFactory.setRegionNeedRegen(x + minPos.x, z + minPos.y);
                }
            });
            if (this.totalDirtiedRegions > 8) {
                this.saveDirtyRegionsToFile(false);
            }
            this.dirtiedRegionsRoughCount = this.totalDirtiedRegions;
            this.isCutting = false;
        };
        this.cutAndExpandThread.execute(thread);
    }

    public void expandOrLoadRegionsAsync(int playerPosX, int playerPosZ) {
        if (this.isExpanding) {
            return;
        }
        if (this.expandOrLoadPaused && LodUtil.checkRamUsage(0.2, 128)) {
            if (this.logEvents) {
                ApiShared.LOGGER.info("Enough ram for expandOrLoadThread. Restarting...");
            }
            this.expandOrLoadPaused = false;
        }
        this.isExpanding = true;
        VerticalQuality verticalQuality = CONFIG.client().graphics().quality().getVerticalQuality();
        DropoffQuality dropoffQuality = CONFIG.client().graphics().quality().getDropoffQuality();
        if (dropoffQuality == DropoffQuality.AUTO) {
            dropoffQuality = CONFIG.client().graphics().quality().getLodChunkRenderDistance() < 128 ? DropoffQuality.SMOOTH_DROPOFF : DropoffQuality.PERFORMANCE_FOCUSED;
        }
        int dropoffSwitch = dropoffQuality.fastModeSwitch;
        Runnable thread = () -> {
            Pos2D minPos = this.regions.getMinInRange();
            this.iterateWithSpiral((x, z) -> {
                double debugRPosZ;
                double deltaRPosZ;
                if (!this.expandOrLoadPaused && !LodUtil.checkRamUsage(0.02, 64)) {
                    Runtime.getRuntime().gc();
                    if (!LodUtil.checkRamUsage(0.2, 128)) {
                        if (this.logEvents) {
                            ApiShared.LOGGER.warn("Not enough ram for expandOrLoadThread. Pausing until Ram is freed...");
                        }
                        this.expandOrLoadPaused = true;
                        this.saveDirtyRegionsToFile(false);
                    }
                }
                int regionX = x + minPos.x;
                int regionZ = z + minPos.y;
                RegionPos regionPos = new RegionPos(regionX, regionZ);
                LodRegion region = this.regions.get(regionX, regionZ);
                if (region != null && region.isWriting.get() != 0) {
                    return;
                }
                double minDistance = LevelPosUtil.minDistance((byte)9, regionX, regionZ, playerPosX, playerPosZ);
                double maxDistance = LevelPosUtil.maxDistance((byte)9, regionX, regionZ, playerPosX, playerPosZ);
                double debugRPosX = LevelPosUtil.convert((byte)9, regionX, (byte)0) + 256;
                double deltaRPosX = debugRPosX - (double)playerPosX;
                double debugDistance = Math.sqrt(deltaRPosX * deltaRPosX + (deltaRPosZ = (debugRPosZ = (double)(LevelPosUtil.convert((byte)9, regionZ, (byte)0) + 256)) - (double)playerPosZ) * deltaRPosZ);
                if (minDistance > debugDistance || maxDistance < debugDistance || minDistance > maxDistance) {
                    if (this.logEvents) {
                        ApiShared.LOGGER.error("MinDistance/MaxDistance is WRONG!!! minDist: [{}], maxDist: [{}], centerDist: [{}]\nAt center block pos: {} {}, region pos: {}", (Object)minDistance, (Object)maxDistance, (Object)debugDistance, (Object)debugRPosX, (Object)debugRPosZ, (Object)regionPos);
                    }
                    return;
                }
                byte minDetail = DetailDistanceUtil.getDetailLevelFromDistance(minDistance);
                byte maxDetail = DetailDistanceUtil.getDetailLevelFromDistance(maxDistance);
                boolean updated = false;
                if (region == null) {
                    if (!this.expandOrLoadPaused) {
                        region = this.getRegionFromFile(regionPos, minDetail, verticalQuality);
                        this.regions.set(regionX, regionZ, region);
                        updated = true;
                    }
                } else if (region.getVerticalQuality() != verticalQuality || region.getMinDetailLevel() > minDetail) {
                    if (!this.expandOrLoadPaused) {
                        region = this.getRegionFromFile(region, minDetail, verticalQuality);
                        this.regions.set(regionX, regionZ, region);
                        updated = true;
                    }
                } else if (minDetail <= dropoffSwitch && region.lastMaxDetailLevel != maxDetail) {
                    region.lastMaxDetailLevel = maxDetail;
                    updated = true;
                } else if (minDetail <= dropoffSwitch && region.lastMaxDetailLevel != region.getMinDetailLevel()) {
                    updated = true;
                }
                if (updated) {
                    region.needSignalToRegenBuffer = true;
                    region.needRecheckGenPoint = true;
                }
                if (region != null && region.needSignalToRegenBuffer) {
                    region.needSignalToRegenBuffer = false;
                    ClientApi.lodBufferBuilderFactory.setRegionNeedRegen(x + minPos.x, z + minPos.y);
                }
            });
            this.isExpanding = false;
        };
        this.cutAndExpandThread.execute(thread);
    }

    public Boolean addVerticalData(byte detailLevel, int posX, int posZ, long[] data, boolean override) {
        int regionPosZ;
        int regionPosX = LevelPosUtil.getRegion(detailLevel, posX);
        LodRegion region = this.getRegion(regionPosX, regionPosZ = LevelPosUtil.getRegion(detailLevel, posZ));
        if (region == null) {
            return false;
        }
        boolean nodeAdded = region.addVerticalData(detailLevel, posX, posZ, data, override);
        return nodeAdded;
    }

    public PosToGenerateContainer getPosToGenerate(int maxDataToGenerate, int playerBlockPosX, int playerBlockPosZ, GenerationPriority priority, DistanceGenerationMode genMode) {
        PosToGenerateContainer posToGenerate = new PosToGenerateContainer(maxDataToGenerate, playerBlockPosX, playerBlockPosZ);
        GenerationPriority allowedPriority = this.dirtiedRegionsRoughCount > 12 ? GenerationPriority.NEAR_FIRST : priority;
        Pos2D minPos = this.regions.getMinInRange();
        this.iterateByDistance((x, z) -> {
            boolean isCloseRange = Math.abs(x - this.halfWidth) + Math.abs(z - this.halfWidth) <= 2;
            LodRegion lodRegion = this.regions.get(minPos.x + x, minPos.y + z);
            if (lodRegion != null && lodRegion.needRecheckGenPoint) {
                boolean checkForFlag;
                int nearCount = posToGenerate.getNumberOfNearPos();
                int farCount = posToGenerate.getNumberOfFarPos();
                boolean bl = checkForFlag = nearCount < posToGenerate.getMaxNumberOfNearPos() && farCount < posToGenerate.getMaxNumberOfFarPos();
                if (checkForFlag) {
                    lodRegion.needRecheckGenPoint = false;
                }
                lodRegion.getPosToGenerate(posToGenerate, playerBlockPosX, playerBlockPosZ, allowedPriority, genMode, isCloseRange);
                if (checkForFlag && (nearCount != posToGenerate.getNumberOfNearPos() || farCount != posToGenerate.getNumberOfFarPos())) {
                    lodRegion.needRecheckGenPoint = true;
                }
            }
        });
        return posToGenerate;
    }

    public int getMaxVerticalData(byte detailLevel, int posX, int posZ) {
        if (detailLevel > 9) {
            throw new IllegalArgumentException("getMaxVerticalData given a level of [" + detailLevel + "] when [" + 9 + "] is the max.");
        }
        LodRegion region = this.getRegion(detailLevel, posX, posZ);
        if (region == null) {
            return 0;
        }
        return region.getMaxVerticalData(detailLevel);
    }

    public long getData(byte detailLevel, int posX, int posZ, int verticalIndex) {
        if (detailLevel > 9) {
            throw new IllegalArgumentException("getLodFromCoordinates given a level of \"" + detailLevel + "\" when \"" + 9 + "\" is the max.");
        }
        LodRegion region = this.getRegion(detailLevel, posX, posZ);
        if (region == null) {
            return 0L;
        }
        return region.getData(detailLevel, posX, posZ, verticalIndex);
    }

    public long[] getAllData(byte detailLevel, int posX, int posZ) {
        if (detailLevel > 9) {
            throw new IllegalArgumentException("getLodFromCoordinates given a level of \"" + detailLevel + "\" when \"" + 9 + "\" is the max.");
        }
        LodRegion region = this.getRegion(detailLevel, posX, posZ);
        if (region == null) {
            return null;
        }
        return region.getAllData(detailLevel, posX, posZ);
    }

    public long getSingleData(byte detailLevel, int posX, int posZ) {
        if (detailLevel > 9) {
            throw new IllegalArgumentException("getLodFromCoordinates given a level of \"" + detailLevel + "\" when \"" + 9 + "\" is the max.");
        }
        LodRegion region = this.getRegion(detailLevel, posX, posZ);
        if (region == null) {
            return 0L;
        }
        return region.getSingleData(detailLevel, posX, posZ);
    }

    public void updateData(byte detailLevel, int posX, int posZ) {
        int zRegion;
        if (detailLevel > 9) {
            throw new IllegalArgumentException("getLodFromCoordinates given a level of \"" + detailLevel + "\" when \"" + 9 + "\" is the max.");
        }
        int xRegion = LevelPosUtil.getRegion(detailLevel, posX);
        LodRegion region = this.getRegion(xRegion, zRegion = LevelPosUtil.getRegion(detailLevel, posZ));
        if (region == null) {
            return;
        }
        region.updateArea(detailLevel, posX, posZ);
    }

    public boolean doesDataExist(byte detailLevel, int posX, int posZ, DistanceGenerationMode requiredMode) {
        LodRegion region = this.getRegion(detailLevel, posX, posZ);
        return region != null && region.doesDataExist(detailLevel, posX, posZ, requiredMode);
    }

    public LodRegion getRegionFromFile(RegionPos regionPos, byte detailLevel, VerticalQuality verticalQuality) {
        return this.fileHandler != null ? this.fileHandler.loadRegionFromFile(detailLevel, regionPos, verticalQuality) : new LodRegion(detailLevel, regionPos, verticalQuality);
    }

    public LodRegion getRegionFromFile(LodRegion existingRegion, byte detailLevel, VerticalQuality verticalQuality) {
        return this.fileHandler != null ? this.fileHandler.loadRegionFromFile(detailLevel, existingRegion, verticalQuality) : new LodRegion(detailLevel, existingRegion.getRegionPos(), verticalQuality);
    }

    public void saveDirtyRegionsToFile(boolean blockUntilFinished) {
        if (this.fileHandler == null) {
            return;
        }
        this.fileHandler.saveDirtyRegionsToFile(blockUntilFinished);
    }

    public boolean regionIsInRange(int regionX, int regionZ) {
        return this.regions.inRange(regionX, regionZ);
    }

    @Deprecated
    public int getCenterRegionPosX() {
        return this.regions.getCenter().x;
    }

    @Deprecated
    public int getCenterRegionPosZ() {
        return this.regions.getCenter().y;
    }

    public RegionPos getCenterRegionPos() {
        Pos2D p = this.regions.getCenter();
        return new RegionPos(p.x, p.y);
    }

    public int getWidth() {
        return this.regions != null ? this.regions.getSize() : this.width;
    }

    public void setRegionWidth(int newWidth) {
        this.width = newWidth;
        this.halfWidth = this.width / 2;
        Pos2D p = this.regions.getCenter();
        this.regions = new MovableGridRingList(this.halfWidth, p.x, p.y);
        this.generateIteratorList();
    }

    public void dumpRamUsage() {
        if (!this.ramLogger.canMaybeLog()) {
            return;
        }
        int regionCount = this.width * this.width;
        this.ramLogger.info("Dumping Ram Usage for LodDim in {} with {} regions...", this.dimension.getDimensionName(), regionCount);
        int nonNullRegionCount = 0;
        int dirtiedRegionCount = 0;
        int writingRegionCount = 0;
        long totalUsage = 0L;
        int[] detailCount = new int[10];
        long[] detailUsage = new long[10];
        for (LodRegion r : this.regions) {
            LevelContainer[] container;
            if (r == null) continue;
            ++nonNullRegionCount;
            if (r.needSaving) {
                ++dirtiedRegionCount;
            }
            if (r.isWriting.get() != 0) {
                ++writingRegionCount;
            }
            if ((container = (LevelContainer[])r.debugGetDataContainers().clone()) == null || container.length != 10) {
                ApiShared.LOGGER.warn("DumpRamUsage encountered an invalid region!");
                continue;
            }
            for (int i = 0; i < 10; ++i) {
                if (container[i] == null) continue;
                int n = i;
                detailCount[n] = detailCount[n] + 1;
                long byteUsage = container[i].getRoughRamUsage();
                int n2 = i;
                detailUsage[n2] = detailUsage[n2] + byteUsage;
                totalUsage += byteUsage;
            }
        }
        this.ramLogger.info("================================================", new Object[0]);
        this.ramLogger.info("Non Null Regions: [{}], Dirtied Regions: [{}], Writing Regions: [{}], Bytes: [{}]", nonNullRegionCount, dirtiedRegionCount, writingRegionCount, new UnitBytes(totalUsage));
        this.ramLogger.info("------------------------------------------------", new Object[0]);
        for (int i = 0; i < 10; ++i) {
            this.ramLogger.info("DETAIL {}: Containers: [{}], Bytes: [{}]", i, detailCount[i], new UnitBytes(detailUsage[i]));
        }
        this.ramLogger.info("================================================", new Object[0]);
        this.ramLogger.incLogTries();
        this.fileHandler.dumpBufferMemoryUsage();
    }

    public String toString() {
        return "[Dim = " + this.dimension.getDimensionName() + ", Region = " + this.regions + "]";
    }

    public String toDetailString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Dimension : \n");
        stringBuilder.append(this.regions.toDetailString());
        return stringBuilder.toString();
    }

    public void shutdown() {
        this.cutAndExpandThread.shutdown();
        try {
            boolean worked = this.cutAndExpandThread.awaitTermination(5L, TimeUnit.SECONDS);
            if (!worked) {
                ApiShared.LOGGER.error("Cut And Expend threads timed out! May cause crash on game exit due to cleanup failure.");
            }
        }
        catch (InterruptedException e) {
            ApiShared.LOGGER.error("Cut And Expend threads shutdown is interrupted! May cause crash on game exit due to cleanup failure: ", (Throwable)e);
        }
    }

    public static interface PosComsumer {
        public void run(int var1, int var2);
    }
}

