/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.objects.lod;

import com.seibel.lod.core.api.ApiShared;
import com.seibel.lod.core.objects.lod.LodDimension;
import com.seibel.lod.core.wrapperInterfaces.world.IDimensionTypeWrapper;
import java.util.Hashtable;
import java.util.Map;

public class LodWorld {
    private String worldName = "";
    private Map<IDimensionTypeWrapper, LodDimension> lodDimensions;
    private boolean isWorldLoaded = false;
    public static final String NO_WORLD_LOADED = "";

    public void selectWorld(String newWorldName) {
        ApiShared.LOGGER.info("Selecting world {} while in world {}", (Object)newWorldName, (Object)this.worldName);
        if (this.worldName.equals(newWorldName)) {
            return;
        }
        this.deselectWorld();
        this.worldName = newWorldName;
        this.lodDimensions = new Hashtable<IDimensionTypeWrapper, LodDimension>();
        this.isWorldLoaded = true;
    }

    public void deselectWorld() {
        ApiShared.LOGGER.info("Deselecting world {}", (Object)this.worldName);
        this.worldName = NO_WORLD_LOADED;
        this.saveAllDimensions(true);
        this.lodDimensions = null;
        this.isWorldLoaded = false;
    }

    public void addLodDimension(LodDimension newDimension) {
        if (this.lodDimensions == null) {
            return;
        }
        ApiShared.LOGGER.info("Adding dim {} to world {}", (Object)newDimension, (Object)this.worldName);
        LodDimension oldDim = this.lodDimensions.put(newDimension.dimension, newDimension);
        if (oldDim != null) {
            oldDim.saveDirtyRegionsToFile(true);
        }
    }

    public LodDimension getLodDimension(IDimensionTypeWrapper dimType) {
        if (this.lodDimensions == null) {
            return null;
        }
        return this.lodDimensions.get(dimType);
    }

    public void resizeDimensionRegionWidth(int newRegionWidth) {
        if (this.lodDimensions == null) {
            return;
        }
        this.saveAllDimensions(true);
        for (IDimensionTypeWrapper key : this.lodDimensions.keySet()) {
            this.lodDimensions.get(key).setRegionWidth(newRegionWidth);
        }
    }

    public void saveAllDimensions(boolean isBlocking) {
        if (this.lodDimensions == null) {
            return;
        }
        ApiShared.LOGGER.info("Saving LODs");
        for (IDimensionTypeWrapper key : this.lodDimensions.keySet()) {
            this.lodDimensions.get(key).saveDirtyRegionsToFile(isBlocking);
        }
    }

    public void shutdownAllDimensions() {
        if (this.lodDimensions == null) {
            return;
        }
        for (IDimensionTypeWrapper key : this.lodDimensions.keySet()) {
            this.lodDimensions.get(key).shutdown();
        }
    }

    public boolean getIsWorldNotLoaded() {
        return !this.isWorldLoaded;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public String toString() {
        return "World name: " + this.worldName;
    }
}

