/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.util;

import com.seibel.lod.core.enums.config.ServerFolderNameMode;
import com.seibel.lod.core.enums.config.VanillaOverdraw;
import com.seibel.lod.core.handlers.IReflectionHandler;
import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.objects.ParsedIp;
import com.seibel.lod.core.objects.Pos2D;
import com.seibel.lod.core.objects.lod.LodDimension;
import com.seibel.lod.core.objects.lod.RegionPos;
import com.seibel.lod.core.objects.opengl.DefaultLodVertexFormats;
import com.seibel.lod.core.objects.opengl.LodVertexFormat;
import com.seibel.lod.core.util.ColorUtil;
import com.seibel.lod.core.util.gridList.EdgeDistanceBooleanGrid;
import com.seibel.lod.core.wrapperInterfaces.IVersionConstants;
import com.seibel.lod.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.lod.core.wrapperInterfaces.chunk.AbstractChunkPosWrapper;
import com.seibel.lod.core.wrapperInterfaces.config.ILodConfigWrapperSingleton;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.lod.core.wrapperInterfaces.world.IDimensionTypeWrapper;
import com.seibel.lod.core.wrapperInterfaces.world.IWorldWrapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

public class LodUtil {
    private static final IMinecraftClientWrapper MC = SingletonHandler.get(IMinecraftClientWrapper.class);
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonHandler.get(IMinecraftRenderWrapper.class);
    private static final ILodConfigWrapperSingleton CONFIG = SingletonHandler.get(ILodConfigWrapperSingleton.class);
    private static final IWrapperFactory FACTORY = SingletonHandler.get(IWrapperFactory.class);
    private static final IReflectionHandler REFLECTION_HANDLER = SingletonHandler.get(IReflectionHandler.class);
    private static final IVersionConstants VERSION_CONSTANTS = SingletonHandler.get(IVersionConstants.class);
    public static final int MINIMUM_RENDER_DISTANCE_FOR_PARTIAL_OVERDRAW = 4;
    public static final int MINIMUM_RENDER_DISTANCE_FOR_FAR_OVERDRAW = 11;
    public static final int MAX_NUMBER_OF_VERTICAL_LODS = 32;
    public static final int DEBUG_ALPHA = 255;
    public static final int COLOR_DEBUG_BLACK = ColorUtil.rgbToInt(255, 0, 0, 0);
    public static final int COLOR_DEBUG_WHITE = ColorUtil.rgbToInt(255, 255, 255, 255);
    public static final int COLOR_INVISIBLE = ColorUtil.rgbToInt(0, 0, 0, 0);
    public static final int CEILED_DIMENSION_MAX_RENDER_DISTANCE = 64;
    public static final int[] DEBUG_DETAIL_LEVEL_COLORS = new int[]{ColorUtil.rgbToInt(255, 0, 0), ColorUtil.rgbToInt(255, 127, 0), ColorUtil.rgbToInt(255, 255, 0), ColorUtil.rgbToInt(127, 255, 0), ColorUtil.rgbToInt(0, 255, 0), ColorUtil.rgbToInt(0, 255, 127), ColorUtil.rgbToInt(0, 255, 255), ColorUtil.rgbToInt(0, 127, 255), ColorUtil.rgbToInt(0, 0, 255), ColorUtil.rgbToInt(127, 0, 255), ColorUtil.rgbToInt(255, 0, 255), ColorUtil.rgbToInt(255, 127, 255), ColorUtil.rgbToInt(255, 255, 255)};
    public static final byte DETAIL_OPTIONS = 10;
    public static final byte REGION_DETAIL_LEVEL = 9;
    public static final byte CHUNK_DETAIL_LEVEL = 4;
    public static final byte BLOCK_DETAIL_LEVEL = 0;
    public static final short REGION_WIDTH = 512;
    public static final short CHUNK_WIDTH = 16;
    public static final short BLOCK_WIDTH = 1;
    public static final int REGION_WIDTH_IN_CHUNKS = 32;
    public static final String INVALID_FILE_CHARACTERS_REGEX = "[\\\\/:*?\"<>|]";
    public static final int MAX_ALLOCATABLE_DIRECT_MEMORY = 0x4000000;
    public static final LodVertexFormat LOD_VERTEX_FORMAT = DefaultLodVertexFormats.POSITION_COLOR_BLOCK_LIGHT_SKY_LIGHT;

    public static IWorldWrapper getServerWorldFromDimension(IDimensionTypeWrapper newDimension) {
        if (!MC.hasSinglePlayerServer()) {
            return null;
        }
        ArrayList<IWorldWrapper> worlds = MC.getAllServerWorlds();
        IWorldWrapper returnWorld = null;
        for (IWorldWrapper world : worlds) {
            if (world.getDimensionType() != newDimension) continue;
            returnWorld = world;
            break;
        }
        return returnWorld;
    }

    public static RegionPos convertGenericPosToRegionPos(int x, int z, int detailLevel) {
        int relativePosX = Math.floorDiv(x, 1 << 9 - detailLevel);
        int relativePosZ = Math.floorDiv(z, 1 << 9 - detailLevel);
        return new RegionPos(relativePosX, relativePosZ);
    }

    public static String getWorldID(IWorldWrapper world) {
        if (MC.hasSinglePlayerServer()) {
            String dimId = LodUtil.getDimensionIDFromWorld(world);
            int saveIndex = dimId.indexOf("saves") + 1 + "saves".length();
            int slashIndex = dimId.indexOf(File.separatorChar, saveIndex);
            dimId = dimId.substring(saveIndex, slashIndex);
            return dimId;
        }
        return LodUtil.getServerFolderName();
    }

    public static String getDimensionIDFromWorld(IWorldWrapper world) {
        if (MC.hasSinglePlayerServer()) {
            IWorldWrapper serverWorld = LodUtil.getServerWorldFromDimension(world.getDimensionType());
            if (serverWorld == null) {
                throw new NullPointerException("getDimensionIDFromWorld wasn't able to get the WorldWrapper for the dimension " + world.getDimensionType().getDimensionName());
            }
            return serverWorld.getSaveFolder().toString();
        }
        return LodUtil.getServerFolderName() + File.separatorChar + "dim_" + world.getDimensionType().getDimensionName() + File.separatorChar;
    }

    public static String getServerFolderName() {
        ParsedIp parsedIp = new ParsedIp(MC.getCurrentServerIp());
        String serverIpCleaned = parsedIp.ip.replaceAll(INVALID_FILE_CHARACTERS_REGEX, "");
        String serverPortCleaned = parsedIp.port != null ? parsedIp.port.replaceAll(INVALID_FILE_CHARACTERS_REGEX, "") : "";
        ServerFolderNameMode folderNameMode = CONFIG.client().multiplayer().getServerFolderNameMode();
        if (folderNameMode == ServerFolderNameMode.AUTO) {
            folderNameMode = parsedIp.isLan() ? ServerFolderNameMode.NAME_IP : ServerFolderNameMode.NAME_IP_PORT;
        }
        String serverName = MC.getCurrentServerName().replaceAll(INVALID_FILE_CHARACTERS_REGEX, "");
        String serverMcVersion = MC.getCurrentServerVersion().replaceAll(INVALID_FILE_CHARACTERS_REGEX, "");
        String folderName = "";
        switch (folderNameMode) {
            default: {
                folderName = serverName;
                break;
            }
            case NAME_IP: {
                folderName = serverName + ", IP " + serverIpCleaned;
                break;
            }
            case NAME_IP_PORT: {
                folderName = serverName + ", IP " + serverIpCleaned + (serverPortCleaned.length() != 0 ? "-" + serverPortCleaned : "");
                break;
            }
            case NAME_IP_PORT_MC_VERSION: {
                folderName = serverName + ", IP " + serverIpCleaned + (serverPortCleaned.length() != 0 ? "-" + serverPortCleaned : "") + ", GameVersion " + serverMcVersion;
            }
        }
        return folderName;
    }

    public static int clamp(int min, int value, int max) {
        return Math.min(max, Math.max(value, min));
    }

    public static float clamp(float min, float value, float max) {
        return Math.min(max, Math.max(value, min));
    }

    public static double clamp(double min, double value, double max) {
        return Math.min(max, Math.max(value, min));
    }

    public static int ceilDiv(int value, int divider) {
        return -Math.floorDiv(-value, divider);
    }

    public static int computeOverdrawOffset(LodDimension lodDim) {
        int chunkRenderDist = MC_RENDER.getRenderDistance() + 1;
        VanillaOverdraw overdraw = CONFIG.client().graphics().advancedGraphics().getVanillaOverdraw();
        if (overdraw == VanillaOverdraw.ALWAYS) {
            return Integer.MAX_VALUE;
        }
        int offset = overdraw == VanillaOverdraw.NEVER ? CONFIG.client().graphics().advancedGraphics().getOverdrawOffset() : (chunkRenderDist < 11 ? 1 : chunkRenderDist / 5);
        if (chunkRenderDist - offset <= 1) {
            return Integer.MAX_VALUE;
        }
        return offset;
    }

    public static EdgeDistanceBooleanGrid readVanillaRenderedChunks(LodDimension lodDim) {
        int offset = LodUtil.computeOverdrawOffset(lodDim);
        if (offset == Integer.MAX_VALUE) {
            return null;
        }
        int renderDist = MC_RENDER.getRenderDistance() + 1;
        final Iterator<AbstractChunkPosWrapper> posIter = MC_RENDER.getVanillaRenderedChunks().iterator();
        return new EdgeDistanceBooleanGrid(new Iterator<Pos2D>(){

            @Override
            public boolean hasNext() {
                return posIter.hasNext();
            }

            @Override
            public Pos2D next() {
                AbstractChunkPosWrapper pos = (AbstractChunkPosWrapper)posIter.next();
                return new Pos2D(pos.getX(), pos.getZ());
            }
        }, MC.getPlayerChunkPos().getX() - renderDist, MC.getPlayerChunkPos().getZ() - renderDist, renderDist * 2 + 1);
    }

    public static float fastInvSqrt(float numb) {
        float half = 0.5f * numb;
        int i = Float.floatToIntBits(numb);
        i = 1597463007 - (i >> 1);
        numb = Float.intBitsToFloat(i);
        return numb * (1.5f - half * numb * numb);
    }

    public static double pow2(double x) {
        return x * x;
    }

    public static long pow2(long x) {
        return x * x;
    }

    public static boolean checkRamUsage(double minFreeMemoryPercent, int minFreeMemoryMB) {
        long freeMem = Runtime.getRuntime().freeMemory() + Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory();
        if (freeMem < (long)(minFreeMemoryMB * 1024 * 1024)) {
            return false;
        }
        long maxMem = Runtime.getRuntime().maxMemory();
        return !((double)freeMem / (double)maxMem < minFreeMemoryPercent);
    }

    public static void checkInterrupts() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public static void checkInterruptsUnchecked() {
        if (Thread.interrupted()) {
            throw new RuntimeException(new InterruptedException());
        }
    }

    public static String shortenString(String str, int maxLength) {
        if (str == null) {
            return "";
        }
        return str.substring(0, Math.min(str.length(), maxLength));
    }
}

