/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.util.gridList;

import com.seibel.lod.core.util.gridList.ArrayGridList;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public class PosArrayGridList<T>
extends ArrayGridList<T> {
    private int offsetX;
    private int offsetY;

    public PosArrayGridList(int gridSize, int offsetX, int offsetY, BiFunction<Integer, Integer, T> filler) {
        super(gridSize, filler);
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public PosArrayGridList(int gridSize, int offsetX, int offsetY) {
        this(gridSize, offsetX, offsetY, (x, y) -> null);
    }

    public PosArrayGridList(PosArrayGridList<T> copy) {
        super(copy);
        this.offsetX = copy.offsetX;
        this.offsetY = copy.offsetY;
    }

    public PosArrayGridList(PosArrayGridList<T> source, int minR, int maxR) {
        super(source, minR, maxR);
    }

    @Override
    protected int _indexOf(int x, int y) {
        return x - this.offsetX + (y - this.offsetY) * this.gridSize;
    }

    @Override
    public void forEachPos(BiConsumer<Integer, Integer> consumer) {
        for (int y = this.offsetY; y < this.offsetY + this.gridSize; ++y) {
            for (int x = this.offsetX; x < this.offsetX + this.gridSize; ++x) {
                consumer.accept(x, y);
            }
        }
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    @Override
    public boolean inRange(int x, int y) {
        return x >= this.offsetX && x < this.offsetX + this.gridSize && y >= this.offsetY && y < this.offsetY + this.gridSize;
    }

    private T _directGet(int x, int y) {
        if (!this.inRange(x, y)) {
            return null;
        }
        return this.get(x, y);
    }

    public boolean move(int deltaX, int deltaY, Consumer<? super T> dealloc) {
        if (deltaX == 0 && deltaY == 0) {
            return false;
        }
        if (Math.abs(deltaX) >= this.gridSize || Math.abs(deltaY) >= this.gridSize) {
            this.clear(dealloc);
            this.offsetX += deltaX;
            this.offsetY += deltaY;
            return true;
        }
        int newMinX = this.offsetX + deltaX;
        int newMinY = this.offsetY + deltaY;
        int newMaxX = newMinX + this.gridSize;
        int newMaxY = newMinY + this.gridSize;
        if (dealloc != null) {
            this.forEachPos((x, y) -> {
                Object t;
                if ((x < newMinX || y < newMinY || x >= newMaxX || y >= newMaxY) && (t = this.get((int)x, (int)y)) != null) {
                    dealloc.accept((T)t);
                }
            });
        }
        this.offsetX = newMinX;
        this.offsetY = newMinY;
        if (deltaX >= 0 && deltaY >= 0) {
            for (int x2 = newMinX; x2 < newMaxX; ++x2) {
                for (int y2 = newMinY; y2 < newMaxY; ++y2) {
                    this.set(x2, y2, this._directGet(x2 + deltaX, y2 + deltaY));
                }
            }
        } else if (deltaX < 0 && deltaY >= 0) {
            for (int x3 = newMaxX - 1; x3 >= newMinX; --x3) {
                for (int y3 = newMinY; y3 < newMaxY; ++y3) {
                    this.set(x3, y3, this._directGet(x3 + deltaX, y3 + deltaY));
                }
            }
        } else if (deltaX >= 0) {
            for (int x4 = newMinX; x4 < newMaxX; ++x4) {
                for (int y4 = newMaxY - 1; y4 >= newMinY; --y4) {
                    this.set(x4, y4, this._directGet(x4 + deltaX, y4 + deltaY));
                }
            }
        } else {
            for (int x5 = newMaxX - 1; x5 >= newMinX; --x5) {
                for (int y5 = newMaxY - 1; y5 >= newMinY; --y5) {
                    this.set(x5, y5, this._directGet(x5 + deltaX, y5 + deltaY));
                }
            }
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().toString() + "[" + this.offsetX + "," + this.offsetY + "] " + this.gridSize + "*" + this.gridSize + "[" + this.size() + "]";
    }
}

