/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.wrapperInterfaces.minecraft;

import com.seibel.lod.core.handlers.dependencyInjection.IBindable;
import com.seibel.lod.core.handlers.dependencyInjection.ModAccessorHandler;
import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.objects.math.Mat4f;
import com.seibel.lod.core.objects.math.Vec3d;
import com.seibel.lod.core.objects.math.Vec3f;
import com.seibel.lod.core.wrapperInterfaces.IVersionConstants;
import com.seibel.lod.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.lod.core.wrapperInterfaces.block.AbstractBlockPosWrapper;
import com.seibel.lod.core.wrapperInterfaces.chunk.AbstractChunkPosWrapper;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.lod.core.wrapperInterfaces.misc.ILightMapWrapper;
import com.seibel.lod.core.wrapperInterfaces.modAccessor.ISodiumAccessor;
import com.seibel.lod.core.wrapperInterfaces.world.IWorldWrapper;
import java.awt.Color;
import java.util.HashSet;

public interface IMinecraftRenderWrapper
extends IBindable {
    public Vec3f getLookAtVector();

    public AbstractBlockPosWrapper getCameraBlockPosition();

    public boolean playerHasBlindnessEffect();

    public Vec3d getCameraExactPosition();

    public Mat4f getDefaultProjectionMatrix(float var1);

    public double getGamma();

    public Color getFogColor(float var1);

    default public Color getSpecialFogColor(float partialTicks) {
        return this.getFogColor(partialTicks);
    }

    public boolean isFogStateSpecial();

    public Color getSkyColor();

    public double getFov(float var1);

    public int getRenderDistance();

    public int getScreenWidth();

    public int getScreenHeight();

    public int getTargetFrameBuffer();

    public int getTargetFrameBufferViewportWidth();

    public int getTargetFrameBufferViewportHeight();

    default public HashSet<AbstractChunkPosWrapper> getVanillaRenderedChunks() {
        ISodiumAccessor sodium = ModAccessorHandler.get(ISodiumAccessor.class);
        return sodium == null ? this.getMaximumRenderedChunks() : sodium.getNormalRenderedChunks();
    }

    public static boolean correctedCheckRadius(int dx, int dz, int radius2Mul4) {
        return (dx *= 2) * dx + (dz *= 2) * dz <= radius2Mul4;
    }

    default public HashSet<AbstractChunkPosWrapper> getMaximumRenderedChunks() {
        IMinecraftClientWrapper mcWrapper = SingletonHandler.get(IMinecraftClientWrapper.class);
        IWrapperFactory factory = SingletonHandler.get(IWrapperFactory.class);
        IVersionConstants versionConstants = SingletonHandler.get(IVersionConstants.class);
        IMinecraftClientWrapper minecraft = SingletonHandler.get(IMinecraftClientWrapper.class);
        IWorldWrapper clientWorld = minecraft.getWrappedClientWorld();
        int chunkDist = this.getRenderDistance() + 1;
        AbstractChunkPosWrapper centerChunkPos = mcWrapper.getPlayerChunkPos();
        int centerChunkX = centerChunkPos.getX();
        int centerChunkZ = centerChunkPos.getZ();
        int chunkDist2Mul4 = chunkDist * chunkDist * 4;
        HashSet<AbstractChunkPosWrapper> renderedPos = new HashSet<AbstractChunkPosWrapper>();
        for (int deltaChunkX = -chunkDist; deltaChunkX <= chunkDist; ++deltaChunkX) {
            for (int deltaChunkZ = -chunkDist; deltaChunkZ <= chunkDist; ++deltaChunkZ) {
                if (!versionConstants.isVanillaRenderedChunkSquare() && !IMinecraftRenderWrapper.correctedCheckRadius(deltaChunkX, deltaChunkZ, chunkDist2Mul4) || !clientWorld.hasChunkLoaded(centerChunkX + deltaChunkX, centerChunkZ + deltaChunkZ)) continue;
                renderedPos.add(factory.createChunkPos(centerChunkX + deltaChunkX, centerChunkZ + deltaChunkZ));
            }
        }
        return renderedPos;
    }

    public ILightMapWrapper getLightmapWrapper();

    public boolean tryDisableVanillaFog();
}

