/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.seibel.lod.common.wrappers.block;

import com.seibel.lod.core.enums.LodDirection;
import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.util.ColorUtil;
import com.seibel.lod.core.wrapperInterfaces.block.AbstractBlockPosWrapper;
import com.seibel.lod.core.wrapperInterfaces.block.IBlockDetailWrapper;
import com.seibel.lod.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.lod.core.wrapperInterfaces.config.ILodConfigWrapperSingleton;
import fabric.com.seibel.lod.common.wrappers.McObjectConverter;
import fabric.com.seibel.lod.common.wrappers.block.TextureAtlasSpriteWrapper;
import fabric.com.seibel.lod.common.wrappers.block.TintGetterOverrideFast;
import fabric.com.seibel.lod.common.wrappers.block.TintGetterOverrideSmooth;
import fabric.com.seibel.lod.common.wrappers.chunk.ChunkWrapper;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2356;
import net.minecraft.class_238;
import net.minecraft.class_2397;
import net.minecraft.class_2464;
import net.minecraft.class_2465;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4538;
import net.minecraft.class_777;

public class BlockDetailWrapper
extends IBlockDetailWrapper {
    private static final ILodConfigWrapperSingleton CONFIG = SingletonHandler.get(ILodConfigWrapperSingleton.class);
    public static final int FLOWER_COLOR_SCALE = 5;
    public static final Random random = new Random(0L);
    private static final class_2248[] BLOCK_TO_AVOID = new class_2248[]{class_2246.field_10124, class_2246.field_10543, class_2246.field_10499};
    private static final class_2350[] DIRECTION_ORDER = new class_2350[]{class_2350.field_11036, class_2350.field_11043, class_2350.field_11034, class_2350.field_11039, class_2350.field_11035, class_2350.field_11033};
    final class_2680 state;
    boolean[] dontOccludeFaces = null;
    boolean noCollision = false;
    boolean noFullFace = false;
    boolean isColorResolved = false;
    int baseColor = 0;
    boolean needShade = true;
    boolean needPostTinting = false;
    int tintIndex = 0;
    public static BlockDetailWrapper NULL_BLOCK_DETAIL = new BlockDetailWrapper();

    private static int calculateColorFromTexture(class_1058 texture, ColorMode colorMode) {
        int tempColor;
        int count = 0;
        double alpha = 0.0;
        double red = 0.0;
        double green = 0.0;
        double blue = 0.0;
        for (int u = 0; u < texture.method_4578(); ++u) {
            for (int v = 0; v < texture.method_4595(); ++v) {
                tempColor = TextureAtlasSpriteWrapper.getPixelRGBA(texture, 0, u, v);
                double r = (double)(tempColor & 0xFF) / 255.0;
                double g = (double)((tempColor & 0xFF00) >>> 8) / 255.0;
                double b = (double)((tempColor & 0xFF0000) >>> 16) / 255.0;
                double a = (double)((tempColor & 0xFF000000) >>> 24) / 255.0;
                int scale = 1;
                if (colorMode == ColorMode.Leaves) {
                    r *= a;
                    g *= a;
                    b *= a;
                    a = 1.0;
                } else {
                    if (a == 0.0) continue;
                    if (colorMode == ColorMode.Flower && (g + 0.1 < b || g + 0.1 < r)) {
                        scale = 5;
                    }
                }
                count += scale;
                alpha += a * a * (double)scale;
                red += r * r * (double)scale;
                green += g * g * (double)scale;
                blue += b * b * (double)scale;
            }
        }
        tempColor = count == 0 ? ColorUtil.rgbToInt(255, 255, 0, 255) : ColorUtil.rgbToInt((int)(Math.sqrt(alpha / (double)count) * 255.0), (int)(Math.sqrt(red / (double)count) * 255.0), (int)(Math.sqrt(green / (double)count) * 255.0), (int)(Math.sqrt(blue / (double)count) * 255.0));
        double colorAlpha = (double)ColorUtil.getAlpha(tempColor) / 255.0;
        tempColor = ColorUtil.rgbToInt(ColorUtil.getAlpha(tempColor), (int)((double)ColorUtil.getRed(tempColor) * colorAlpha), (int)((double)ColorUtil.getGreen(tempColor) * colorAlpha), (int)((double)ColorUtil.getBlue(tempColor) * colorAlpha));
        return tempColor;
    }

    private static boolean isBlockToBeAvoid(class_2248 b) {
        for (class_2248 bta : BLOCK_TO_AVOID) {
            if (bta != b) continue;
            return true;
        }
        return false;
    }

    public BlockDetailWrapper(class_2680 state, class_2338 pos, class_4538 getter) {
        this.state = state;
        this.resolveShapes(getter, pos);
    }

    private BlockDetailWrapper() {
        this.state = null;
    }

    static BlockDetailWrapper make(class_2680 bs, class_2338 pos, class_4538 getter) {
        if (!bs.method_26227().method_15769()) {
            if (BlockDetailWrapper.isBlockToBeAvoid(bs.method_26204())) {
                return NULL_BLOCK_DETAIL;
            }
            if (bs.method_26215()) {
                return NULL_BLOCK_DETAIL;
            }
            return new BlockDetailWrapper(bs, pos, getter);
        }
        if (bs.method_26217() != class_2464.field_11458) {
            return NULL_BLOCK_DETAIL;
        }
        if (BlockDetailWrapper.isBlockToBeAvoid(bs.method_26204())) {
            return NULL_BLOCK_DETAIL;
        }
        return new BlockDetailWrapper(bs, pos, getter);
    }

    private void resolveShapes(class_4538 sampleGetter, class_2338 samplePos) {
        if (this.state.method_26227().method_15769()) {
            this.noCollision = this.state.method_26220((class_1922)sampleGetter, samplePos).method_1110();
            this.dontOccludeFaces = new boolean[6];
            if (!this.state.method_26225()) {
                Arrays.fill(this.dontOccludeFaces, true);
            }
            class_265 voxelShape = this.state.method_26218((class_1922)sampleGetter, samplePos);
            if (voxelShape.method_1110()) {
                this.noFullFace = true;
            } else {
                class_238 bbox = voxelShape.method_1107();
                double xWidth = bbox.field_1320 - bbox.field_1323;
                double yWidth = bbox.field_1325 - bbox.field_1322;
                double zWidth = bbox.field_1324 - bbox.field_1321;
                this.noFullFace = xWidth < 1.0 && zWidth < 1.0 && yWidth < 1.0;
            }
        } else {
            this.dontOccludeFaces = new boolean[6];
        }
    }

    private void resolveColors() {
        if (this.isColorResolved) {
            return;
        }
        if (this.state.method_26227().method_15769()) {
            List quads = null;
            for (class_2350 direction : DIRECTION_ORDER) {
                quads = class_310.method_1551().method_1554().method_4743().method_3335(this.state).method_4707(this.state, direction, random);
                if (!quads.isEmpty() && (!(this.state.method_26204() instanceof class_2465) || direction != class_2350.field_11036)) break;
            }
            if (quads == null || quads.isEmpty()) {
                quads = class_310.method_1551().method_1554().method_4743().method_3335(this.state).method_4707(this.state, null, random);
            }
            if (quads != null && !quads.isEmpty()) {
                this.needPostTinting = ((class_777)quads.get(0)).method_3360();
                this.needShade = ((class_777)quads.get(0)).method_24874();
                this.tintIndex = ((class_777)quads.get(0)).method_3359();
                this.baseColor = BlockDetailWrapper.calculateColorFromTexture(((class_777)quads.get((int)0)).field_4176, ColorMode.getColorMode(this.state.method_26204()));
            } else {
                this.needPostTinting = false;
                this.needShade = false;
                this.tintIndex = 0;
                this.baseColor = BlockDetailWrapper.calculateColorFromTexture(class_310.method_1551().method_1554().method_4743().method_3339(this.state), ColorMode.getColorMode(this.state.method_26204()));
            }
        } else {
            this.needPostTinting = true;
            this.needShade = false;
            this.tintIndex = 0;
            this.baseColor = BlockDetailWrapper.calculateColorFromTexture(class_310.method_1551().method_1554().method_4743().method_3339(this.state), ColorMode.getColorMode(this.state.method_26204()));
        }
        this.isColorResolved = true;
    }

    private class_1920 wrapColorResolver(class_4538 level) {
        int blendDistance = CONFIG.client().graphics().quality().getLodBiomeBlending();
        if (blendDistance == 0) {
            return new TintGetterOverrideFast(level);
        }
        return new TintGetterOverrideSmooth(level, blendDistance);
    }

    @Override
    public int getAndResolveFaceColor(LodDirection dir, IChunkWrapper chunk, AbstractBlockPosWrapper blockPos) {
        this.resolveColors();
        if (!this.needPostTinting) {
            return this.baseColor;
        }
        int tintColor = class_310.method_1551().method_1505().method_1697(this.state, this.wrapColorResolver(((ChunkWrapper)chunk).getColorResolver()), McObjectConverter.Convert(blockPos), this.tintIndex);
        if (tintColor == -1) {
            return this.baseColor;
        }
        return ColorUtil.multiplyARGBwithRGB(this.baseColor, tintColor);
    }

    @Override
    public boolean hasFaceCullingFor(LodDirection dir) {
        return !this.dontOccludeFaces[dir.ordinal()];
    }

    @Override
    public boolean hasNoCollision() {
        return this.noCollision;
    }

    @Override
    public boolean noFaceIsFullFace() {
        return this.noFullFace;
    }

    @Override
    public String serialize() {
        return null;
    }

    @Override
    protected boolean isSame(IBlockDetailWrapper iBlockDetail) {
        return ((BlockDetailWrapper)iBlockDetail).state.method_26204().equals(this.state.method_26204());
    }

    @Override
    public String toString() {
        return "BlockDetail{" + this.state + "}";
    }

    static enum ColorMode {
        Default,
        Flower,
        Leaves;


        static ColorMode getColorMode(class_2248 b) {
            if (b instanceof class_2397) {
                return Leaves;
            }
            if (b instanceof class_2356) {
                return Flower;
            }
            return Default;
        }
    }
}

