/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.seibel.lod.common.wrappers.chunk;

import com.seibel.lod.core.enums.LodDirection;
import com.seibel.lod.core.util.LevelPosUtil;
import com.seibel.lod.core.wrapperInterfaces.block.IBlockDetailWrapper;
import com.seibel.lod.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.lod.core.wrapperInterfaces.world.IBiomeWrapper;
import fabric.com.seibel.lod.common.wrappers.WrapperUtil;
import fabric.com.seibel.lod.common.wrappers.block.BlockDetailMap;
import fabric.com.seibel.lod.common.wrappers.block.BlockDetailWrapper;
import fabric.com.seibel.lod.common.wrappers.world.BiomeWrapper;
import fabric.com.seibel.lod.common.wrappers.worldGeneration.mimicObject.LightedWorldGenRegion;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2402;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2902;
import net.minecraft.class_3737;
import net.minecraft.class_4538;

public class ChunkWrapper
implements IChunkWrapper {
    private final class_2791 chunk;
    private final class_4538 lightSource;

    public ChunkWrapper(class_2791 chunk, class_4538 lightSource) {
        this.chunk = chunk;
        this.lightSource = lightSource;
    }

    @Override
    public int getHeight() {
        return 255;
    }

    @Override
    public int getMinBuildHeight() {
        return 0;
    }

    @Override
    public int getMaxBuildHeight() {
        return this.chunk.method_8322();
    }

    @Override
    public int getHeightMapValue(int xRel, int zRel) {
        return this.chunk.method_12032(WrapperUtil.DEFAULT_HEIGHTMAP).method_12603(xRel, zRel);
    }

    @Override
    public IBiomeWrapper getBiome(int x, int y, int z) {
        return BiomeWrapper.getBiomeWrapper(this.chunk.method_12036().method_16359(x >> 2, y >> 2, z >> 2));
    }

    @Override
    public IBlockDetailWrapper getBlockDetail(int x, int y, int z) {
        class_2338 pos = new class_2338(x, y, z);
        class_2680 blockState = this.chunk.method_8320(pos);
        BlockDetailWrapper blockDetail = BlockDetailMap.getOrMakeBlockDetailCache(blockState, pos, this.lightSource);
        return blockDetail == BlockDetailWrapper.NULL_BLOCK_DETAIL ? null : blockDetail;
    }

    @Override
    public IBlockDetailWrapper getBlockDetailAtFace(int x, int y, int z, LodDirection dir) {
        int fy = y + dir.getNormal().y;
        if (fy < this.getMinBuildHeight() || fy > this.getMaxBuildHeight()) {
            return null;
        }
        class_2338 pos = new class_2338(x + dir.getNormal().x, fy, z + dir.getNormal().z);
        class_2680 blockState = this.blockPosInsideChunk(x, y, z) ? this.chunk.method_8320(pos) : this.lightSource.method_8320(pos);
        if (blockState == null || blockState.method_26215()) {
            return null;
        }
        BlockDetailWrapper blockDetail = BlockDetailMap.getOrMakeBlockDetailCache(blockState, pos, this.lightSource);
        return blockDetail == BlockDetailWrapper.NULL_BLOCK_DETAIL ? null : blockDetail;
    }

    public class_2791 getChunk() {
        return this.chunk;
    }

    @Override
    public int getChunkPosX() {
        return this.chunk.method_12004().field_9181;
    }

    @Override
    public int getChunkPosZ() {
        return this.chunk.method_12004().field_9180;
    }

    @Override
    public int getRegionPosX() {
        return LevelPosUtil.convert((byte)4, this.chunk.method_12004().field_9181, (byte)9);
    }

    @Override
    public int getRegionPosZ() {
        return LevelPosUtil.convert((byte)4, this.chunk.method_12004().field_9180, (byte)9);
    }

    @Override
    public int getMaxY(int x, int z) {
        return this.chunk.method_12005(class_2902.class_2903.field_13202, Math.floorMod(x, 16), Math.floorMod(z, 16));
    }

    @Override
    public int getMaxX() {
        return this.chunk.method_12004().method_8327();
    }

    @Override
    public int getMaxZ() {
        return this.chunk.method_12004().method_8329();
    }

    @Override
    public int getMinX() {
        return this.chunk.method_12004().method_8326();
    }

    @Override
    public int getMinZ() {
        return this.chunk.method_12004().method_8328();
    }

    @Override
    public long getLongChunkPos() {
        return this.chunk.method_12004().method_8324();
    }

    @Override
    public boolean isLightCorrect() {
        return true;
    }

    @Override
    public boolean isWaterLogged(int x, int y, int z) {
        class_2680 blockState = this.chunk.method_8320(new class_2338(x, y, z));
        return !(blockState.method_26204() instanceof class_2402) && blockState.method_26204() instanceof class_3737 && blockState.method_28498((class_2769)class_2741.field_12508) && (Boolean)blockState.method_11654((class_2769)class_2741.field_12508) != false;
    }

    @Override
    public int getEmittedBrightness(int x, int y, int z) {
        return this.chunk.method_8317(new class_2338(x, y, z));
    }

    @Override
    public int getBlockLight(int x, int y, int z) {
        if (this.lightSource == null) {
            return -1;
        }
        return this.lightSource.method_8314(class_1944.field_9282, new class_2338(x, y, z));
    }

    @Override
    public int getSkyLight(int x, int y, int z) {
        if (this.lightSource == null) {
            return -1;
        }
        return this.lightSource.method_8314(class_1944.field_9284, new class_2338(x, y, z));
    }

    @Override
    public boolean doesNearbyChunksExist() {
        if (this.lightSource instanceof LightedWorldGenRegion) {
            return true;
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                if (dx == 0 && dz == 0 || this.lightSource.method_8402(dx + this.getChunkPosX(), dz + this.getChunkPosZ(), class_2806.field_12794, false) != null) continue;
                return false;
            }
        }
        return true;
    }

    public class_4538 getColorResolver() {
        return this.lightSource;
    }

    @Override
    public String toString() {
        return this.chunk.getClass().getSimpleName() + this.chunk.method_12004();
    }
}

