/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.seibel.lod.common.wrappers.world;

import com.seibel.lod.core.enums.WorldType;
import com.seibel.lod.core.wrapperInterfaces.chunk.AbstractChunkPosWrapper;
import com.seibel.lod.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.lod.core.wrapperInterfaces.world.IWorldWrapper;
import fabric.com.seibel.lod.common.wrappers.chunk.ChunkWrapper;
import fabric.com.seibel.lod.common.wrappers.world.DimensionTypeWrapper;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_1936;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2802;
import net.minecraft.class_2806;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public class WorldWrapper
implements IWorldWrapper {
    private static final ConcurrentMap<class_1936, WorldWrapper> worldWrapperMap = new ConcurrentHashMap<class_1936, WorldWrapper>();
    private final class_1936 world;
    public final WorldType worldType;

    public WorldWrapper(class_1936 newWorld) {
        this.world = newWorld;
        this.worldType = this.world.getClass() == class_3218.class ? WorldType.ServerWorld : (this.world.getClass() == class_638.class ? WorldType.ClientWorld : WorldType.Unknown);
    }

    @Nullable
    public static WorldWrapper getWorldWrapper(class_1936 world) {
        if (world == null) {
            return null;
        }
        if (worldWrapperMap.containsKey(world) && worldWrapperMap.get(world) != null) {
            return (WorldWrapper)worldWrapperMap.get(world);
        }
        WorldWrapper worldWrapper = new WorldWrapper(world);
        worldWrapperMap.put(world, worldWrapper);
        return worldWrapper;
    }

    public static void clearMap() {
        worldWrapperMap.clear();
    }

    @Override
    public WorldType getWorldType() {
        return this.worldType;
    }

    @Override
    public DimensionTypeWrapper getDimensionType() {
        return DimensionTypeWrapper.getDimensionTypeWrapper(this.world.method_8597());
    }

    @Override
    public int getBlockLight(int x, int y, int z) {
        return this.world.method_8314(class_1944.field_9282, new class_2338(x, y, z));
    }

    @Override
    public int getSkyLight(int x, int y, int z) {
        return this.world.method_8314(class_1944.field_9284, new class_2338(x, y, z));
    }

    public class_1936 getWorld() {
        return this.world;
    }

    @Override
    public boolean hasCeiling() {
        return this.world.method_8597().method_27998();
    }

    @Override
    public boolean hasSkyLight() {
        return this.world.method_8597().method_12491();
    }

    @Override
    public int getHeight() {
        return this.world.method_24853();
    }

    @Override
    public short getMinHeight() {
        return 0;
    }

    @Override
    public File getSaveFolder() throws UnsupportedOperationException {
        if (this.worldType != WorldType.ServerWorld) {
            throw new UnsupportedOperationException("getSaveFolder can only be called for ServerWorlds.");
        }
        class_3215 chunkSource = ((class_3218)this.world).method_14178();
        return chunkSource.method_17981().field_17664;
    }

    public class_3218 getServerWorld() throws UnsupportedOperationException {
        if (this.worldType != WorldType.ServerWorld) {
            throw new UnsupportedOperationException("getSaveFolder can only be called for ServerWorlds.");
        }
        return (class_3218)this.world;
    }

    @Override
    public int getSeaLevel() {
        return this.world.method_8615();
    }

    @Override
    public IChunkWrapper tryGetChunk(AbstractChunkPosWrapper pos) {
        class_2791 chunk = this.world.method_8402(pos.getX(), pos.getZ(), class_2806.field_12798, false);
        if (chunk == null) {
            return null;
        }
        return new ChunkWrapper(chunk, (class_4538)this.world);
    }

    @Override
    public boolean hasChunkLoaded(int chunkX, int chunkZ) {
        class_2802 source = this.world.method_8398();
        return source.method_12123(chunkX, chunkZ);
    }
}

