/*
 * Decompiled with CFR 0.152.
 */
package forge.com.seibel.lod.common.networking;

import io.netty.buffer.Unpooled;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CCustomPayloadPacket;
import net.minecraft.network.play.server.SCustomPayloadPlayPacket;
import net.minecraft.util.ResourceLocation;

public class Networking {
    public static final ResourceLocation resourceLocation_meow = new ResourceLocation("lod", "meow");

    public static PacketBuffer createNew() {
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        buf.writeInt(1);
        return buf;
    }

    public static void send(ServerPlayerEntity player, PacketBuffer buf) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        Objects.requireNonNull(resourceLocation_meow, "Channel name cannot be null");
        Objects.requireNonNull(buf, "Packet byte buf cannot be null");
        player.field_71135_a.func_147359_a(Networking.createS2CPacket(resourceLocation_meow, buf));
    }

    public static void send(PacketBuffer buf) throws IllegalStateException {
        if (Minecraft.func_71410_x().func_147114_u() != null) {
            Minecraft.func_71410_x().func_147114_u().func_147297_a(Networking.createC2SPacket(resourceLocation_meow, buf));
            return;
        }
        throw new IllegalStateException("Cannot send packets when not in game!");
    }

    public static IPacket<?> createS2CPacket(ResourceLocation channelName, PacketBuffer buf) {
        Objects.requireNonNull(channelName, "Channel cannot be null");
        Objects.requireNonNull(buf, "Buf cannot be null");
        return Networking.createPlayS2CPacket(channelName, buf);
    }

    public static IPacket<?> createPlayS2CPacket(ResourceLocation channel, PacketBuffer buf) {
        return new SCustomPayloadPlayPacket(channel, buf);
    }

    public static IPacket<?> createC2SPacket(ResourceLocation channelName, PacketBuffer buf) {
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        Objects.requireNonNull(buf, "Buf cannot be null");
        return Networking.createPlayC2SPacket(channelName, buf);
    }

    public static IPacket<?> createPlayC2SPacket(ResourceLocation channelName, PacketBuffer buf) {
        return new CCustomPayloadPacket(channelName, buf);
    }
}

