/*
 * Decompiled with CFR 0.152.
 */
package forge.com.seibel.lod.common.wrappers.config;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.seibel.lod.core.config.ConfigAnnotations;
import forge.com.seibel.lod.common.LodCommonMain;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shaded.electronwill.nightconfig.core.file.CommentedFileConfig;

@Deprecated
public abstract class ConfigGui {
    private static final Pattern INTEGER_ONLY_REGEX = Pattern.compile("(-?[0-9]*)");
    private static final Pattern DECIMAL_ONLY_REGEX = Pattern.compile("-?([\\d]+\\.?[\\d]*|[\\d]*\\.?[\\d]+|\\.)");
    private static final List<EntryInfo> entries = new ArrayList<EntryInfo>();
    public static final Map<String, EntryInfo> entryMap = new HashMap<String, EntryInfo>();
    private static final String MOD_NAME = "DistantHorizons";
    private static final String MOD_NAME_READABLE = "Distant Horizons";
    private static final Logger LOGGER = LogManager.getLogger((String)"DistantHorizons");
    private static Path configFilePath;

    public static void init(Class<?> config) {
        Minecraft mc = Minecraft.func_71410_x();
        configFilePath = mc.field_71412_D.toPath().resolve("config").resolve("DistantHorizons.toml");
        ConfigGui.initNestedClass(config, "");
        for (EntryInfo info : entries) {
            if (!info.field.isAnnotationPresent(ConfigAnnotations.Entry.class)) continue;
            try {
                info.value = info.field.get(null);
                info.tempValue = info.value.toString();
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        ConfigGui.loadFromFile();
    }

    private static void initNestedClass(Class<?> config, String category) {
        for (Field field : config.getFields()) {
            EntryInfo info = new EntryInfo();
            if (field.isAnnotationPresent(ConfigAnnotations.Entry.class) || field.isAnnotationPresent(ConfigAnnotations.Comment.class) || field.isAnnotationPresent(ConfigAnnotations.ScreenEntry.class)) {
                info.category = category;
                if (!LodCommonMain.serverSided) {
                    ConfigGui.initClient(field, info, category);
                }
            }
            if (field.isAnnotationPresent(ConfigAnnotations.Entry.class)) {
                entryMap.put((!category.isEmpty() ? category + "." : "") + field.getName(), info);
                info.varClass = field.getType();
                try {
                    info.defaultValue = field.get(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            if (field.isAnnotationPresent(ConfigAnnotations.ScreenEntry.class)) {
                ConfigGui.initNestedClass(field.getType(), (!category.isEmpty() ? category + "." : "") + field.getName());
            }
            if (field.isAnnotationPresent(ConfigAnnotations.FileComment.class)) {
                entryMap.put((!category.isEmpty() ? category + "." : "") + field.getName(), info);
                info.fileComment = true;
                try {
                    info.value = info.defaultValue = field.get(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            info.field = field;
        }
    }

    private static void initClient(Field field, EntryInfo info, String category) {
        Class<?> fieldClass = field.getType();
        ConfigAnnotations.Entry entry = field.getAnnotation(ConfigAnnotations.Entry.class);
        ConfigAnnotations.ScreenEntry screenEntry = field.getAnnotation(ConfigAnnotations.ScreenEntry.class);
        if (entry != null) {
            info.width = entry.width();
        } else if (screenEntry != null) {
            info.width = screenEntry.width();
        }
        if (entry != null) {
            if (!entry.name().equals("")) {
                info.name = new TranslationTextComponent(entry.name());
            }
            if (fieldClass == Integer.TYPE) {
                ConfigGui.textField(info, Integer::parseInt, INTEGER_ONLY_REGEX, entry.minValue(), entry.maxValue(), true);
            } else if (fieldClass == Double.TYPE) {
                ConfigGui.textField(info, Double::parseDouble, DECIMAL_ONLY_REGEX, entry.minValue(), entry.maxValue(), false);
            } else if (fieldClass == String.class || fieldClass == List.class) {
                info.max = entry.maxValue() == Double.MAX_VALUE ? Integer.MAX_VALUE : (int)entry.maxValue();
                ConfigGui.textField(info, String::length, null, Math.min(entry.minValue(), 0.0), Math.max(entry.maxValue(), 1.0), true);
            } else if (fieldClass == Boolean.TYPE) {
                Function<Object, ITextComponent> func = value -> new StringTextComponent((Boolean)value != false ? "True" : "False").func_240699_a_((Boolean)value != false ? TextFormatting.GREEN : TextFormatting.RED);
                info.widget = new AbstractMap.SimpleEntry<Button.IPressable, Function<Object, ITextComponent>>(button -> {
                    info.value = (Boolean)info.value == false;
                    button.func_238482_a_((ITextComponent)func.apply(info.value));
                }, func);
            } else if (fieldClass.isEnum()) {
                List<?> values = Arrays.asList(field.getType().getEnumConstants());
                Function<Object, ITextComponent> func = value -> new TranslationTextComponent("DistantHorizons.config.enum." + fieldClass.getSimpleName() + "." + info.value.toString());
                info.widget = new AbstractMap.SimpleEntry<Button.IPressable, Function<Object, ITextComponent>>(button -> {
                    int index = values.indexOf(info.value) + 1;
                    info.value = values.get(index >= values.size() ? 0 : index);
                    button.func_238482_a_((ITextComponent)func.apply(info.value));
                }, func);
            }
        } else if (screenEntry != null) {
            if (!screenEntry.name().equals("")) {
                info.name = new TranslationTextComponent(screenEntry.name());
            }
            info.screenButton = true;
            info.gotoScreen = (!info.category.isEmpty() ? info.category + "." : "") + field.getName();
        }
        entries.add(info);
    }

    private static void textField(EntryInfo info, Function<String, Number> func, Pattern pattern, double minValue, double maxValue, boolean cast) {
        boolean isNumber = pattern != null;
        info.widget = (editBox, button) -> stringValue -> {
            if (!(stringValue = stringValue.trim()).isEmpty() && isNumber && !pattern.matcher((CharSequence)stringValue).matches()) {
                return false;
            }
            Number value = 0;
            boolean inLimits = false;
            info.error = null;
            if (isNumber && !stringValue.isEmpty() && !stringValue.equals("-") && !stringValue.equals(".")) {
                value = (Number)func.apply((String)stringValue);
                boolean bl = inLimits = value.doubleValue() >= minValue && value.doubleValue() <= maxValue;
                info.error = inLimits ? null : new AbstractMap.SimpleEntry<TextFieldWidget, StringTextComponent>((TextFieldWidget)editBox, new StringTextComponent(value.doubleValue() < minValue ? "\u00a7cMinimum length" + (cast ? " is " + (int)minValue : " is " + minValue) : "\u00a7cMaximum length" + (cast ? " is " + (int)maxValue : " is " + maxValue)));
            }
            info.tempValue = stringValue;
            editBox.func_146193_g(inLimits ? -1 : -34953);
            info.inLimits = inLimits;
            button.field_230693_o_ = entries.stream().allMatch(e -> e.inLimits);
            if (inLimits && info.field.getType() != List.class) {
                info.value = value;
            } else if (inLimits) {
                if (((List)info.value).size() == info.index) {
                    ((List)info.value).add("");
                }
                ((List)info.value).set(info.index, (String)Arrays.stream(info.tempValue.replace("[", "").replace("]", "").split(", ")).collect(Collectors.toList()).get(0));
            }
            return true;
        };
    }

    public static void saveToFile() {
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(configFilePath.toFile()).build();
        try {
            if (!configFilePath.getParent().toFile().exists()) {
                Files.createDirectory(configFilePath.getParent(), new FileAttribute[0]);
            }
            if (!Files.exists(configFilePath, new LinkOption[0])) {
                Files.createFile(configFilePath, new FileAttribute[0]);
            }
        }
        catch (Exception e) {
            LOGGER.info("Failed creating config file for Distant Horizons at the path [" + configFilePath.toString() + "].");
            e.printStackTrace();
        }
        ConfigGui.loadFileWithErrorCheck(config);
        config.set("_version", (Object)1);
        for (EntryInfo info : entries) {
            if (!info.field.isAnnotationPresent(ConfigAnnotations.Entry.class)) continue;
            editSingleOption.saveOption(info, config);
            if (editSingleOption.getEntry((info.category.isEmpty() ? "" : info.category + ".") + "_" + info.field.getName()) == null) continue;
            config.setComment((info.category.isEmpty() ? "" : info.category + ".") + info.field.getName(), String.valueOf(editSingleOption.getEntry((String)new StringBuilder().append((String)(info.category.isEmpty() ? "" : new StringBuilder().append((String)info.category).append((String)".").toString())).append((String)"_").append((String)info.field.getName()).toString()).defaultValue));
        }
        config.save();
        config.close();
    }

    public static void loadFromFile() {
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(configFilePath.toFile()).autosave().build();
        if (!Files.exists(configFilePath, new LinkOption[0])) {
            LOGGER.info("Config file not found for Distant Horizons. Creating config...");
            ConfigGui.saveToFile();
            return;
        }
        ConfigGui.loadFileWithErrorCheck(config);
        config.set("_version", (Object)1);
        for (EntryInfo info : entries) {
            if (!info.field.isAnnotationPresent(ConfigAnnotations.Entry.class)) continue;
            editSingleOption.loadOption(info, config);
            if (editSingleOption.getEntry((info.category.isEmpty() ? "" : info.category + ".") + "_" + info.field.getName()) == null) continue;
            config.setComment((info.category.isEmpty() ? "" : info.category + ".") + info.field.getName(), String.valueOf(editSingleOption.getEntry((String)new StringBuilder().append((String)(info.category.isEmpty() ? "" : new StringBuilder().append((String)info.category).append((String)".").toString())).append((String)"_").append((String)info.field.getName()).toString()).defaultValue));
        }
        config.close();
    }

    public static void loadFileWithErrorCheck(CommentedFileConfig config) {
        try {
            config.load();
        }
        catch (Exception e) {
            LOGGER.info("Error loading config for Distant Horizons at the path [" + configFilePath.toString() + "].");
            LOGGER.info("Creating a new config...");
            try {
                Files.deleteIfExists(configFilePath);
                ConfigGui.saveToFile();
            }
            catch (Exception f) {
                LOGGER.info("Failed creating config file for Distant Horizons at the path [" + configFilePath.toString() + "].");
                f.printStackTrace();
            }
        }
    }

    public static Screen getScreen(Screen parent, String category) {
        return new ConfigScreen(parent, category);
    }

    public static class EntryInfo<T> {
        Field field;
        Object widget;
        int width = 0;
        int max;
        Map.Entry<TextFieldWidget, ITextComponent> error;
        Object defaultValue;
        Object value;
        String tempValue;
        boolean inLimits = true;
        TranslationTextComponent name;
        int index;
        boolean hideOption = false;
        boolean screenButton = false;
        String gotoScreen = "";
        String category;
        Class<T> varClass;
        @Deprecated
        boolean fileComment = false;
    }

    public static class editSingleOption {
        public static EntryInfo getEntry(String name) {
            return entryMap.get(name);
        }

        public static void saveOption(String name) {
            editSingleOption.saveOption(entryMap.get(name));
        }

        public static void saveOption(EntryInfo info) {
            CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(configFilePath.toFile()).autosave().build();
            ConfigGui.loadFileWithErrorCheck(config);
            editSingleOption.saveOption(info, config);
            config.close();
        }

        public static void saveOption(EntryInfo info, CommentedFileConfig config) {
            config.set((info.category.isEmpty() ? "" : info.category + ".") + info.field.getName(), info.value);
        }

        public static void loadOption(String name) {
            editSingleOption.loadOption(entryMap.get(name));
        }

        public static void loadOption(EntryInfo info) {
            CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(configFilePath.toFile()).autosave().build();
            ConfigGui.loadFileWithErrorCheck(config);
            editSingleOption.loadOption(info, config);
            config.close();
        }

        public static void loadOption(EntryInfo info, CommentedFileConfig config) {
            String itemPath = (info.category.isEmpty() ? "" : info.category + ".") + info.field.getName();
            if (config.contains(itemPath)) {
                if (info.field.getType().isEnum()) {
                    try {
                        info.value = config.getEnum(itemPath, info.varClass);
                    }
                    catch (IllegalArgumentException ignored) {
                        return;
                    }
                } else {
                    info.value = config.get(itemPath);
                }
            } else {
                config.set(itemPath, info.value);
            }
            try {
                info.field.set(null, info.value);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private static class ConfigScreen
    extends Screen {
        private final String translationPrefix;
        private final Screen parent;
        private final String category;
        private ConfigListWidget list;
        private boolean reload = false;

        protected ConfigScreen(Screen parent, String category) {
            super((ITextComponent)new TranslationTextComponent(I18n.func_188566_a((String)("DistantHorizons.config" + (category.isEmpty() ? "." + category : "") + ".title")) ? "DistantHorizons.config.title" : "DistantHorizons.config" + (category.isEmpty() ? "" : "." + category) + ".title"));
            this.parent = parent;
            this.category = category;
            this.translationPrefix = "DistantHorizons.config.";
        }

        public void func_231023_e_() {
            super.func_231023_e_();
        }

        public void func_231175_as__() {
            ConfigGui.saveToFile();
            Objects.requireNonNull(this.field_230706_i_).func_147108_a(this.parent);
        }

        private Button addBtn(Button button) {
            this.func_230480_a_((Widget)button);
            return button;
        }

        protected void func_231160_c_() {
            super.func_231160_c_();
            if (!this.reload) {
                ConfigGui.loadFromFile();
            }
            this.addBtn(new Button(this.field_230708_k_ / 2 - 154, this.field_230709_l_ - 28, 150, 20, DialogTexts.field_240633_d_, button -> {
                ConfigGui.loadFromFile();
                Objects.requireNonNull(this.field_230706_i_).func_147108_a(this.parent);
            }));
            Button done = this.addBtn(new Button(this.field_230708_k_ / 2 + 4, this.field_230709_l_ - 28, 150, 20, DialogTexts.field_240632_c_, button -> {
                ConfigGui.saveToFile();
                Objects.requireNonNull(this.field_230706_i_).func_147108_a(this.parent);
            }));
            this.list = new ConfigListWidget(this.field_230706_i_, this.field_230708_k_ * 2, this.field_230709_l_, 32, this.field_230709_l_ - 32, 25);
            if (this.field_230706_i_ != null && this.field_230706_i_.field_71441_e != null) {
                this.list.func_244605_b(false);
            }
            this.func_230481_d_((IGuiEventListener)this.list);
            for (EntryInfo info : entries) {
                Predicate processor;
                Map.Entry widget;
                if (!info.category.matches(this.category) || info.hideOption) continue;
                TranslationTextComponent name = info.name == null ? new TranslationTextComponent(this.translationPrefix + (!info.category.isEmpty() ? info.category + "." : "") + info.field.getName()) : info.name;
                Button resetButton = new Button(this.field_230708_k_ - 10 - info.width - 5 - 40, 0, 40, 20, (ITextComponent)new StringTextComponent("Reset").func_240699_a_(TextFormatting.RED), button -> {
                    info.value = info.defaultValue;
                    info.tempValue = info.defaultValue.toString();
                    info.index = 0;
                    this.reload = true;
                    Objects.requireNonNull(this.field_230706_i_).func_147108_a((Screen)this);
                });
                if (info.widget instanceof Map.Entry) {
                    widget = (Map.Entry)info.widget;
                    if (info.field.getType().isEnum()) {
                        widget.setValue(value -> new TranslationTextComponent(this.translationPrefix + "enum." + info.field.getType().getSimpleName() + "." + info.value.toString()));
                    }
                    this.list.addButton((Widget)new Button(this.field_230708_k_ - info.width - 10, 0, info.width, 20, (ITextComponent)((Function)widget.getValue()).apply(info.value), (Button.IPressable)widget.getKey()), (Widget)resetButton, null, (ITextComponent)name);
                    continue;
                }
                if (info.field.getType() == List.class) {
                    if (!this.reload) {
                        info.index = 0;
                    }
                    widget = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ - info.width - 10, 0, info.width, 20, null);
                    widget.func_146203_f(info.width);
                    if (info.index < ((List)info.value).size()) {
                        widget.func_146191_b(String.valueOf(((List)info.value).get(info.index)));
                    } else {
                        widget.func_146191_b("");
                    }
                    processor = (Predicate)((BiFunction)info.widget).apply(widget, done);
                    widget.func_200675_a(processor);
                    resetButton.func_230991_b_(20);
                    resetButton.func_238482_a_((ITextComponent)new StringTextComponent("R").func_240699_a_(TextFormatting.RED));
                    Button cycleButton = new Button(this.field_230708_k_ - 185, 0, 20, 20, (ITextComponent)new StringTextComponent(String.valueOf(info.index)).func_240699_a_(TextFormatting.GOLD), button -> {
                        ((List)info.value).remove("");
                        this.reload = true;
                        ++info.index;
                        if (info.index > ((List)info.value).size()) {
                            info.index = 0;
                        }
                        Objects.requireNonNull(this.field_230706_i_).func_147108_a((Screen)this);
                    });
                    this.list.addButton((Widget)widget, (Widget)resetButton, (Widget)cycleButton, (ITextComponent)name);
                    continue;
                }
                if (info.widget != null) {
                    widget = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ - info.width - 10 + 2, 0, info.width - 4, 20, null);
                    widget.func_146203_f(info.width);
                    widget.func_146191_b(String.valueOf(info.value));
                    processor = (Predicate)((BiFunction)info.widget).apply(widget, done);
                    widget.func_200675_a(processor);
                    this.list.addButton((Widget)widget, (Widget)resetButton, null, (ITextComponent)name);
                    continue;
                }
                if (info.screenButton) {
                    widget = new Button(this.field_230708_k_ / 2 - info.width, this.field_230709_l_ - 28, info.width * 2, 20, (ITextComponent)name, button -> {
                        ConfigGui.saveToFile();
                        Objects.requireNonNull(this.field_230706_i_).func_147108_a(ConfigGui.getScreen(this, info.gotoScreen));
                    });
                    this.list.addButton((Widget)widget, null, null, null);
                    continue;
                }
                if (info.fileComment) continue;
                this.list.addButton(null, null, null, (ITextComponent)name);
            }
        }

        public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
            this.func_230446_a_(matrices);
            this.list.func_230430_a_(matrices, mouseX, mouseY, delta);
            ConfigScreen.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)15, (int)0xFFFFFF);
            for (EntryInfo info : entries) {
                if (!info.category.matches(this.category) || info.hideOption || !this.list.getHoveredButton(mouseX, mouseY).isPresent()) continue;
                Widget buttonWidget = this.list.getHoveredButton(mouseX, mouseY).get();
                ITextComponent text = ButtonEntry.buttonsWithText.get(buttonWidget);
                TranslationTextComponent name = new TranslationTextComponent(this.translationPrefix + (info.category.isEmpty() ? "" : info.category + ".") + info.field.getName());
                String key = this.translationPrefix + (info.category.isEmpty() ? "" : info.category + ".") + info.field.getName() + ".@tooltip";
                if (info.error != null && text.equals(name)) {
                    this.func_238652_a_(matrices, info.error.getValue(), mouseX, mouseY);
                    continue;
                }
                if (!I18n.func_188566_a((String)key) || text == null || !text.equals(name)) continue;
                ArrayList<StringTextComponent> list = new ArrayList<StringTextComponent>();
                for (String str : I18n.func_135052_a((String)key, (Object[])new Object[0]).split("\n")) {
                    list.add(new StringTextComponent(str));
                }
                this.func_243308_b(matrices, list, mouseX, mouseY);
            }
            super.func_230430_a_(matrices, mouseX, mouseY, delta);
        }
    }

    public static class ButtonEntry
    extends AbstractOptionList.Entry<ButtonEntry> {
        private static final FontRenderer textRenderer = Minecraft.func_71410_x().field_71466_p;
        public final Widget button;
        private final Widget resetButton;
        private final Widget indexButton;
        private final ITextComponent text;
        private final List<Widget> children = new ArrayList<Widget>();
        public static final Map<Widget, ITextComponent> buttonsWithText = new HashMap<Widget, ITextComponent>();

        private ButtonEntry(Widget button, ITextComponent text, Widget resetButton, Widget indexButton) {
            buttonsWithText.put(button, text);
            this.button = button;
            this.resetButton = resetButton;
            this.text = text;
            this.indexButton = indexButton;
            if (button != null) {
                this.children.add(button);
            }
            if (resetButton != null) {
                this.children.add(resetButton);
            }
            if (indexButton != null) {
                this.children.add(indexButton);
            }
        }

        public static ButtonEntry create(Widget button, ITextComponent text, Widget resetButton, Widget indexButton) {
            return new ButtonEntry(button, text, resetButton, indexButton);
        }

        public void func_230432_a_(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            if (this.button != null) {
                this.button.field_230691_m_ = y;
                this.button.func_230430_a_(matrices, mouseX, mouseY, tickDelta);
            }
            if (this.resetButton != null) {
                this.resetButton.field_230691_m_ = y;
                this.resetButton.func_230430_a_(matrices, mouseX, mouseY, tickDelta);
            }
            if (this.indexButton != null) {
                this.indexButton.field_230691_m_ = y;
                this.indexButton.func_230430_a_(matrices, mouseX, mouseY, tickDelta);
            }
            if (!(this.text == null || this.text.getString().contains("spacer") && this.button == null)) {
                AbstractGui.func_238475_b_((MatrixStack)matrices, (FontRenderer)textRenderer, (ITextComponent)this.text, (int)12, (int)(y + 5), (int)0xFFFFFF);
            }
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return this.children;
        }
    }

    public static class ConfigListWidget
    extends AbstractOptionList<ButtonEntry> {
        FontRenderer textRenderer;

        public ConfigListWidget(Minecraft minecraftClient, int i, int j, int k, int l, int m) {
            super(minecraftClient, i, j, k, l, m);
            this.field_230676_m_ = false;
            this.textRenderer = minecraftClient.field_71466_p;
        }

        public void addButton(Widget button, Widget resetButton, Widget indexButton, ITextComponent text) {
            this.func_230513_b_((AbstractList.AbstractListEntry)ButtonEntry.create(button, text, resetButton, indexButton));
        }

        public int func_230949_c_() {
            return 10000;
        }

        public Optional<Widget> getHoveredButton(double mouseX, double mouseY) {
            for (ButtonEntry buttonEntry : this.func_231039_at__()) {
                if (buttonEntry.button == null || !buttonEntry.button.func_231047_b_(mouseX, mouseY)) continue;
                return Optional.of(buttonEntry.button);
            }
            return Optional.empty();
        }
    }

    private static class ConfigScreenConfigs {
        public static final int SpaceFromRightScreen = 10;
        public static final int ButtonWidthSpacing = 5;
        public static final int ResetButtonWidth = 40;

        private ConfigScreenConfigs() {
        }
    }
}

